@echo off
cd %~dp0

rem # make sure coreboot can be found in a directory named 'coreboot'
if not exist coreboot\src (
   echo.
   echo.
   echo === Please place the coreboot source code in a directory named "coreboot" ===
   echo.
   pause
   exit 1
   )

rem # Locate the msys for coreboot path. Search order is:
rem # 1) msys in the current directory.
rem # 2) msys in the parent directory.
rem # 3) environment variable 'msys_for_coreboot'.

for %%? in ("%~dp0..") do set PARENT_DIR=%%~f?

if exist %PARENT_DIR%\msys\bin set msys_for_coreboot=%PARENT_DIR%\msys
if exist %cd%\msys\bin         set msys_for_coreboot=%cd%\msys

if not exist %msys_for_coreboot%\bin (
   echo.
   echo.
   echo -------------------------------------------------
   echo =      ...Unable to find msys directory...      =
   echo =  Set environment variable msys_for_coreboot,  =
   echo =  or place msys in the current directory,      =
   echo =  or place msys in the parent directory        =
   echo -------------------------------------------------
   echo.
   pause
   exit 1
   )

rem # Set the bash startup dirctory (need a better way, for now pass it to etc/profile).
set COREBOOT_PROJECT_DIR=%cd%\coreboot
rem # convert windows path format to msys path format (example, c:\tmp becomes /c/tmp)
set COREBOOT_PROJECT_DIR=%COREBOOT_PROJECT_DIR:\=/%
set COREBOOT_PROJECT_DIR=%COREBOOT_PROJECT_DIR::=%
set COREBOOT_PROJECT_DIR=/%COREBOOT_PROJECT_DIR%

rem # manually set locations for cross compiler component
set xgccpath=/gcc481/bin

echo # generated by go.bat, edit that one> coreboot\.xcompile
echo # elf32-i386 toolchain>> coreboot\.xcompile
echo CC_i386:=%xgccpath%/i386-elf-gcc -Wno-unused-but-set-variable -Wa,--divide -fno-stack-protector -Wl,--build-id=none>> coreboot\.xcompile
echo AS_i386:=%xgccpath%/i386-elf-as>> coreboot\.xcompile 
echo LD_i386:=%xgccpath%/i386-elf-ld>> coreboot\.xcompile 
echo NM_i386:=%xgccpath%/i386-elf-nm>> coreboot\.xcompile
echo OBJCOPY_i386:=%xgccpath%/i386-elf-objcopy>> coreboot\.xcompile
echo OBJDUMP_i386:=%xgccpath%/i386-elf-objdump>> coreboot\.xcompile
echo READELF_i386:=%xgccpath%/i386-elf-readelf>> coreboot\.xcompile
echo STRIP_i386:=%xgccpath%/i386-elf-strip>> coreboot\.xcompile
echo AR_i386:=%xgccpath%/i386-elf-ar>> coreboot\.xcompile
echo IASL:=iasl>> coreboot\.xcompile
echo HOSTCC:=gcc>> coreboot\.xcompile
echo CPP_i386:=cpp>> coreboot\.xcompile
echo CC_x86_32:=$(CC_i386)>> coreboot\.xcompile
echo AS_x86_32:=$(AS_i386)>> coreboot\.xcompile
echo LD_x86_32:=$(LD_i386)>> coreboot\.xcompile
echo NM_x86_32:=$(NM_i386)>> coreboot\.xcompile
echo OBJCOPY_x86_32:=$(OBJCOPY_i386)>> coreboot\.xcompile
echo OBJDUMP_x86_32:=$(OBJDUMP_i386)>> coreboot\.xcompile
echo READELF_x86_32:=$(READELF_i386)>> coreboot\.xcompile
echo STRIP_x86_32:=$(STRIP_i386)>> coreboot\.xcompile
echo AR_x86_32:=$(AR_i386)>> coreboot\.xcompile




rem # add tools directory to the path (for iasl.exe)
set path=%msys_for_coreboot%\tools

rem # add python to the path (needed to build seabios)
set path=%path%;%msys_for_coreboot%\tools\Python27

rem # optional: add your subversion path so that the svnversion command will work
rem #

rem # start msys build environment
%msys_for_coreboot%\msys.bat


