/**
 * @file
 *
 * SMU firmware.
 *
 *
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  GNB
 * @e \$Revision: 18962 \$   @e \$Date: 2009-09-07 20:35:39 -0700 (Mon, 07 Sep 2009) \$
 *
 */
/*****************************************************************************
 *
 * Copyright (C) 2012 Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 ***************************************************************************/


#ifndef  _HOTPLUGFIRMWARE_H_
#define  _HOTPLUGFIRMWARE_H_

UINT32 DataBlock0[] = {
  0xbdff018e,
  0x16ceee15,
  0x1cce1807,
  0xa6082000,
  0x00a71800,
  0x8c081808,
  0xf3256716,
  0x270000cc,
  0x601cce0b,
  0x8308006f,
  0xf8260100,
  0x16bd098d,
  0x02fb2003,
  0xde1c0206,
  0x9f343c06,
  0xbd0fc606,
  0x06de0004,
  0xfece016f,
  0xe702c668,
  0x69fece00,
  0x1806de18,
  0x00e701e6,
  0xe764fece,
  0x18c4c600,
  0x1865fece,
  0xffc600e7,
  0x66fece18,
  0xce00e718,
  0x00e767fe,
  0x1806de18,
  0x1cf701e6,
  0xf704c600,
  0x06bd041c,
  0x06de18e0,
  0xf701e618,
  0xfece001c,
  0xf600e764,
  0xce18011c,
  0xe71865fe,
  0x021cf600,
  0xe766fece,
  0x031cf600,
  0x67fece18,
  0xf600e718,
  0xffce4b1c,
  0xf600e78e,
  0xffce4a1c,
  0xbd00e78d,
  0x00cc2b06,
  0x7efece01,
  0x07bd00ed,
  0x0200ce2b,
  0x7efece18,
  0xbd00efcd,
  0x00ce8407,
  0xfece1803,
  0x00efcd7e,
  0xe674fece,
  0x2601c100,
  0x06de181a,
  0x3701e618,
  0x081ccc34,
  0x31480fbd,
  0x6c06de31,
  0xc101e601,
  0xcee62307,
  0xce180400,
  0xefcd7efe,
  0x4b1cf600,
  0x1cf702ca,
  0x8effce4b,
  0xfece00e7,
  0x2600e675,
  0x0812bd03,
  0xfd8009bd,
  0x1c2a101c,
  0x180500ce,
  0xcd7efece,
  0x01c600ef,
  0xce540bbd,
  0xce180600,
  0xefcd7efe,
  0xfe200e00,
  0x0cbd01c6,
  0xbd01c690,
  0x00ce9a10,
  0xfece1807,
  0x00efcd7e,
  0x540bbd5f,
  0x180800ce,
  0xcd7efece,
  0xffce00ef,
  0xe701c68f,
  0x00ce0e00,
  0x00efcd09,
  0x274e1cf6,
  0x1cf75f29,
  0x0a00ce4e,
  0x7efece18,
  0xc600efcd,
  0x900cbd01,
  0x10bd00c6,
  0x0b00ce9a,
  0x7efece18,
  0xce00efcd,
  0x01c68fff,
  0xffce00e7,
  0xf700e687,
  0x01c54d1c,
  0x00ce1a27,
  0xfece180c,
  0x00efcd7e,
  0xbd5f1ccc,
  0x00cefa0a,
  0xfece180d,
  0x00efcd7e,
  0xe675fece,
  0x18a52600,
  0x1823f0ce,
  0x80c400e6,
  0x00cc9a27,
  0x7efece10,
  0x11bd00ed,
  0xf0ce181c,
  0x001c1823,
  0x1100cc80,
  0xed7efece,
  0x7c037e00,
  0x9f3c06de,
  0x3c08de06,
  0xd73c0ade,
  0x3d10ce0b,
  0xf0c400e6,
  0x0bd68f18,
  0x00dd8f18,
  0x01da8f18,
  0xdf3800e7,
  0x08df380a,
  0x3906df38,
  0x3c3c06de,
  0x08de069f,
  0x3c0ade3c,
  0x0bee06de,
  0x1cf70adf,
  0x06de1800,
  0x1809ee18,
  0x1cf700e6,
  0xf718c607,
  0xde18061c,
  0x08e61806,
  0x7f041cf7,
  0x007f0900,
  0xe006bd08,
  0xfdbe05bd,
  0x152a101c,
  0x1cf709d6,
  0x7f032006,
  0x06bd061c,
  0xfa05bde0,
  0x20101cfc,
  0x08de1877,
  0x240a9c18,
  0x1a06de54,
  0x081809ee,
  0xbd01ef1a,
  0x1cfd0e06,
  0xdcd82b10,
  0xffffc30a,
  0x2708931a,
  0xf708c638,
  0x06bd061c,
  0x06de18e0,
  0x1801ee18,
  0x1cf700e6,
  0xf718c607,
  0xde18061c,
  0x08e61806,
  0xbd041cf7,
  0x06dee006,
  0x1801ee1a,
  0x01ef1a08,
  0xdf0808de,
  0x250a9c08,
  0x1cf75fb6,
  0xe006bd06,
  0x1cf712c6,
  0xe006bd06,
  0x5ffa05bd,
  0xbd061cf7,
  0x5f4fe006,
  0x380adf38,
  0x383808df,
  0xde3906df,
  0x069f3c06,
  0xde3c08de,
  0x0cde3c0a,
  0xee06de3c,
  0x180cdf07,
  0xee1806de,
  0x0adf1809,
  0x7f09007f,
  0x1cf70800,
  0xf714c600,
  0xde18061c,
  0x06e61806,
  0xbd041cf7,
  0x05bde006,
  0x101cfdbe,
  0x09d6102a,
  0xbd061cf7,
  0x05bde006,
  0x101cfcfa,
  0xde185f20,
  0x0a9c1808,
  0x05bd3d24,
  0x0cde18e5,
  0x00df08de,
  0x00d38f18,
  0x1cf68f18,
  0x00e71804,
  0xffc30adc,
  0x08931aff,
  0x04c61d27,
  0xbd061cf7,
  0x14c6e006,
  0xbd061cf7,
  0xde18e006,
  0x18081808,
  0x9c1808df,
  0x5fc3250a,
  0xbd061cf7,
  0x12c6e006,
  0xbd061cf7,
  0x528de006,
  0x061cf75f,
  0x4fe006bd,
  0x0cdf385f,
  0x380adf38,
  0xdf3808df,
  0x06de3906,
  0xbd069f3c,
  0x1cf67306,
  0x2702c505,
  0x205f4f04,
  0x2708c510,
  0xffffcc05,
  0x04c50720,
  0xffcce527,
  0x06df38fe,
  0x3c06de39,
  0x06bd069f,
  0x051cf673,
  0xf62701c4,
  0xdf385f4f,
  0x06de3906,
  0x8d069f3c,
  0x051cf672,
  0xf72740c4,
  0xdf385f4f,
  0x06de3906,
  0x8d069f3c,
  0x061cf65e,
  0xf72701c5,
  0x042602c5,
  0x03205f4f,
  0x38faffcc,
  0xde3906df,
  0x069f3c06,
  0x001cf75f,
  0xf7041c7f,
  0x01c6051c,
  0x5f061cf7,
  0xbd071cf7,
  0x0e8de006,
  0x5f101cfd,
  0xbd061cf7,
  0xdf38e006,
  0x06de3906,
  0x8d069f3c,
  0x051cf616,
  0x042720c5,
  0x07205f4f,
  0xef2710c5,
  0x38fdffcc,
  0xde3906df,
  0x9f3c3c06,
  0x67fece06,
  0xfece00e6,
  0xc400e660,
  0x831a4f03,
  0x08270100,
  0x0200831a,
  0xe5201a27,
  0xe668fece,
  0x041cf700,
  0xe669fece,
  0x06de1800,
  0xce01e718,
  0x16206afe,
  0xe66cfece,
  0x041cf700,
  0xe66dfece,
  0x06de1800,
  0xce01e718,
  0x00e66efe,
  0xe602e718,
  0x071cf700,
  0x1806de18,
  0x1cf702e6,
  0x01e61806,
  0x38051cf7,
  0x3906df38,
  0x9f3c06de,
  0x001cf606,
  0xe764fece,
  0x071cf600,
  0xe763fece,
  0x061cf600,
  0xe762fece,
  0x051cf600,
  0xe761fece,
  0x60fece00,
  0xe7041cf6,
  0xc400e600,
  0xce0b2704,
  0x00e660fe,
  0xf72604c4,
  0xfece0920,
  0xc400e660,
  0x38f72704,
  0xde3906df,
  0x3c3c3c06,
  0x06de069f,
  0x0ec6026f,
  0x1806de18,
  0x183d02a6,
  0x1cc303ed,
  0x0100ce12,
  0x1808183c,
  0x0000ce3c,
  0x188f183c,
  0x05bd00e6,
  0x38383803,
  0x112600dd,
  0xee1a06de,
  0xc38f1803,
  0x8f181b1c,
  0xe71801c6,
  0x06de1800,
  0x18026c18,
  0x03c102e6,
  0x3838b823,
  0x3906df38,
  0x3c3c06de,
  0x069f343c,
  0x016f06de,
  0xde180ec6,
  0x01a61806,
  0x02ed183d,
  0x181b1cc3,
  0x00e6188f,
  0x712601c1,
  0x1806de18,
  0x1cc302ec,
  0x04ed1812,
  0x3c0200ce,
  0xc302ec18,
  0x3637171c,
  0x0400ce18,
  0x06de3c18,
  0x00e604ee,
  0xfd2c04bd,
  0x3838101c,
  0xce422b38,
  0x183c0200,
  0xec1806de,
  0x131cc302,
  0xcd3c3637,
  0x00e604ee,
  0xfd2c04bd,
  0x3838101c,
  0xce222b38,
  0x183c0200,
  0xec1806de,
  0x191cc302,
  0x00ce3637,
  0xee183c06,
  0x00e61804,
  0xfd2c04bd,
  0x3838101c,
  0x6c06de38,
  0xc101e601,
  0x7e032203,
  0x5f4f9007,
  0x38313838,
  0xde3906df,
  0x3c3c3c06,
  0xde069f3c,
  0x0ade3c08,
  0x3c0cde3c,
  0x01e706de,
  0x54545454,
  0x1cc34f54,
  0x188f1808,
  0x03e700e6,
  0x08c502ec,
  0x087e0326,
  0x5801e6eb,
  0x09d710c4,
  0x585801e6,
  0xe7585858,
  0x1880c401,
  0x1809d68f,
  0x1800dd8f,
  0x1801da8f,
  0xc401e68f,
  0x1800dd40,
  0x1801da8f,
  0xc401e68f,
  0x1800dd20,
  0xd701da8f,
  0xe68f180b,
  0x03c45403,
  0x02ec06e7,
  0xdd01c44f,
  0xa60ec608,
  0x0cdd3d06,
  0x0cd308dc,
  0x1cc304ed,
  0xd68f1813,
  0x00e7180b,
  0xc38f0cde,
  0x188f121c,
  0x180100ce,
  0x06de183c,
  0xc304ec18,
  0x3637131c,
  0x00c308dc,
  0x1808dd02,
  0x3c1808de,
  0x04bd00e6,
  0x101cfd2c,
  0x38383838,
  0xdf380cdf,
  0x08df380a,
  0x38383838,
  0xde3906df,
  0x02de3c00,
  0x3c04de3c,
  0x9f3c06de,
  0xf701c606,
  0xffce4e1c,
  0x38006f8f,
  0xdf3806df,
  0x02df3804,
  0x3b00df38,
  0xde3c00de,
  0x04de3c02,
  0x3c06de3c,
  0xb407069f,
  0x0e06bf00,
  0x3806df38,
  0xdf3804df,
  0x00df3802,
  0x3c00de3b,
  0xde3c02de,
  0x06de3c04,
  0x38069f3c,
  0xdf3806df,
  0x02df3804,
  0x3b00df38,
  0xde3c00de,
  0x04de3c02,
  0x3c06de3c,
  0xdf38069f,
  0x04df3806,
  0x3802df38,
  0xde3b00df,
  0x069f3c06,
  0x3906df38,
  0x3c3c06de,
  0x069f343c,
  0xde3c08de,
  0x0cde3c0a,
  0x6f06de3c,
  0x0dd75f01,
  0xdd081ccc,
  0xde04df02,
  0x1800e602,
  0xe71806de,
  0x04ec1805,
  0x08c504de,
  0x0a7e0326,
  0x05e61836,
  0x1803c454,
  0x06de02e7,
  0x05e68f18,
  0x8f1801c4,
  0xdf18054f,
  0x4f01db00,
  0xcc8f0fc4,
  0x15bd0100,
  0xc60bd7f1,
  0xa606de0e,
  0x08dd3d02,
  0xed1b1cc3,
  0x00e68f04,
  0x2d2601c1,
  0x00df184f,
  0x08d301d6,
  0x1806de18,
  0x1cc304ed,
  0x01c68f1c,
  0x06de00e7,
  0x1804ee1a,
  0x1e1cc38f,
  0x01e68f18,
  0xd600e718,
  0x270bd50d,
  0xfbffcc05,
  0x8f182f20,
  0x8f180dd6,
  0x8f0bd68f,
  0x8f1800df,
  0x0dd701da,
  0x04df8f18,
  0x180802de,
  0x6c1806de,
  0x01e61801,
  0x04de02df,
  0x032207c1,
  0x4f9d097e,
  0x0cdf385f,
  0x380adf38,
  0x383808df,
  0x06df3831,
  0x3c06de39,
  0x9f3c3c3c,
  0xe706de06,
  0xf7fec404,
  0xffce4a1c,
  0xde00e78d,
  0xc404e606,
  0xfa585801,
  0x01ca4b1c,
  0xce4b1cf7,
  0x00e78eff,
  0x1806de18,
  0xffce026f,
  0x1800e686,
  0xe71806de,
  0x05ec1806,
  0x052710c5,
  0xe71801c6,
  0x06de1802,
  0x27026d18,
  0x06e618e1,
  0xf64c1cf7,
  0x02c44b1c,
  0xf704e718,
  0xf75f4b1c,
  0xffce4a1c,
  0x04e6188e,
  0xffce00e7,
  0x00e75f8d,
  0xe686ffce,
  0x06de1800,
  0xc403e718,
  0x18032610,
  0x06de02e7,
  0xe826026d,
  0x1cf703e6,
  0x385f4f4c,
  0xdf383838,
  0x06de3906,
  0x069f3c3c,
  0x01c68f18,
  0x01e706de,
  0xe686ffce,
  0x4c1cf700,
  0xbd00e718,
  0x1cf62f08,
  0xf710ca4b,
  0xffce4b1c,
  0xce00e78e,
  0x00e687ff,
  0x1806de18,
  0x01c402e7,
  0xe7180326,
  0x6d06de01,
  0xe6e82601,
  0x4d1cf702,
  0xc44b1cf6,
  0x4b1cf702,
  0xe78effce,
  0x385f4f00,
  0x3906df38,
  0x3c3c06de,
  0x9f343c3c,
  0x3c08de06,
  0x026f06de,
  0x7e03265d,
  0xde18ee0b,
  0x02e61806,
  0x58585858,
  0x01e71858,
  0x10011c18,
  0xbd01e618,
  0x06de610a,
  0x02e6026c,
  0xde2307c1,
  0xde18026f,
  0x02e61806,
  0x58585858,
  0x01e71858,
  0x18011c18,
  0xbd01e618,
  0x06de610a,
  0x02e6026c,
  0xde2307c1,
  0xde18026f,
  0x02e61806,
  0x58585858,
  0x1808ca58,
  0x0abd01e7,
  0x6c06de61,
  0xc102e602,
  0x6fe32307,
  0x06de1802,
  0x5802e618,
  0x58585858,
  0xbd01e718,
  0x06de610a,
  0x02e6026c,
  0xe52307c1,
  0xde187620,
  0x026f1806,
  0xcd081cce,
  0xde1805ef,
  0x05ee1806,
  0x1800e618,
  0xe71806de,
  0x03ec1804,
  0x402708c5,
  0x5404e618,
  0xe71803c4,
  0x03ec1807,
  0xdd01c44f,
  0x0ec68f08,
  0x9600df8f,
  0x07e61801,
  0xc308d33d,
  0x8f18151c,
  0x02e606de,
  0x58585858,
  0x1801e758,
  0x01c400e6,
  0x01e701ea,
  0xe608011c,
  0x610abd01,
  0xcd06de18,
  0xcd0805ee,
  0x6c1805ef,
  0x02e61802,
  0x962307c1,
  0x3808df38,
  0x38313838,
  0xde3906df,
  0x069f3c06,
  0xdd3c08de,
  0x1a5f4f08,
  0x09240893,
  0x0100c301,
  0x2508931a,
  0x08df38f7,
  0x3906df38,
  0x303c06de,
  0xefffc38f,
  0x069f358f,
  0x05e706de,
  0x01ed5f4f,
  0x07e703ed,
  0x05e608e7,
  0x0cc60426,
  0xde1807e7,
  0x066f1806,
  0x06de0ec6,
  0xed3d06a6,
  0x1b1cc309,
  0xe6188f18,
  0x2701c100,
  0x560e7e03,
  0x1809ee1a,
  0x1c1cc38f,
  0xe6188f18,
  0x2701c100,
  0xf60d7e03,
  0x1809ee1a,
  0x1d1cc38f,
  0xe6188f18,
  0x2701c100,
  0x940d7e03,
  0x1cc309ec,
  0x00ce1812,
  0xce3c1802,
  0xd38f0300,
  0x183c8f06,
  0x180000ce,
  0x00e68f3c,
  0xfd0305bd,
  0x3838101c,
  0x7e032a38,
  0xde18560e,
  0x03e61806,
  0xe7180fc4,
  0x03e7180b,
  0xc404e618,
  0x0ce7180f,
  0xde04e718,
  0x09ee1a06,
  0x1cc38f18,
  0xe68f1815,
  0x180de70b,
  0x112600e1,
  0x1809ee1a,
  0x161cc38f,
  0x0ce68f18,
  0x2700e118,
  0x06de180d,
  0xc105e618,
  0x18032601,
  0x0ec6076f,
  0x06a606de,
  0xc310ed3d,
  0x188f151c,
  0xe61806de,
  0xde00e70d,
  0x10ee1a06,
  0x1cc38f18,
  0xe68f1816,
  0x530e7e04,
  0x1806de18,
  0x1cc309ec,
  0x0100ce12,
  0x0806de3c,
  0x183c0808,
  0x180000ce,
  0x00e68f3c,
  0xfd0305bd,
  0x3838101c,
  0x7e032a38,
  0x06de560e,
  0x0fc403e6,
  0xde1803e7,
  0x09eecd06,
  0x151cc38f,
  0x0ee7188f,
  0x0a2700e1,
  0xc105e618,
  0x18032601,
  0x0ec6076f,
  0x1806de18,
  0xc33d06a6,
  0x8f18151c,
  0x0ee606de,
  0xde185d20,
  0x09ec1806,
  0xce121cc3,
  0xde3c0100,
  0x08080806,
  0x00ce183c,
  0x8f3c1801,
  0x05bd00e6,
  0x101cfd03,
  0x2b383838,
  0xe606de39,
  0xe70fc403,
  0x06de1803,
  0x8f09eecd,
  0x8f161cc3,
  0xe10fe718,
  0x180a2700,
  0x01c105e6,
  0x6f180326,
  0x180ec607,
  0xa61806de,
  0x1cc33d06,
  0xde8f1816,
  0x180fe606,
  0xde1800e7,
  0x066c1806,
  0xc106e618,
  0x7e032203,
  0xe618b80c,
  0x260cc107,
  0x1801c607,
  0x062008e7,
  0x1806de18,
  0x06de076c,
  0x0326086d,
  0x30b20c7e,
  0x1100c38f,
  0xdf38358f,
  0x06de3906,
  0x3c3c3c3c,
  0xde069f3c,
  0x0ade3c08,
  0x3c0cde3c,
  0x08e706de,
  0x04e7036f,
  0xcd06de18,
  0xc38f03ee,
  0xe68f081c,
  0x06e71800,
  0x1803c454,
  0xe61801e7,
  0x58585808,
  0x0bd75858,
  0x4f05ec18,
  0x0cdd01c4,
  0xa6180ec6,
  0x08dd3d01,
  0x08d30cdc,
  0x18151cc3,
  0x00e6188f,
  0x02e706de,
  0x8f1801c4,
  0x8f180bd6,
  0x8f1800dd,
  0x0bd701da,
  0x0e6d8f18,
  0x02e62c26,
  0xc4585858,
  0x1800dd10,
  0x1801da8f,
  0x5802e68f,
  0x00dd08c4,
  0x01da8f18,
  0x02e68f18,
  0x02c45454,
  0x8f1800dd,
  0x0bd701da,
  0x0bd68f18,
  0xce610abd,
  0x00cc7efe,
  0x3800ed12,
  0xdf380cdf,
  0x08df380a,
  0x38383838,
  0x3906df38,
  0x3c3c06de,
  0xde069f34,
  0x02dd3c08,
  0xc44b1cf6,
  0x06de18fd,
  0x1801e718,
  0x188effce,
  0x06de00e7,
  0x585809e6,
  0xfa585858,
  0x1cf74a1c,
  0x8dffce4a,
  0x06de00e7,
  0x01ca01e6,
  0x184b1cf7,
  0x026f00e7,
  0xe686ffce,
  0x2710c400,
  0x1801c608,
  0xe71806de,
  0x06de1802,
  0x27026d18,
  0xf700e6e7,
  0xffce4c1c,
  0xf700e687,
  0x02de4d1c,
  0x3a09e618,
  0xf600e75f,
  0x02c44c1c,
  0x09d75858,
  0x1cf600e7,
  0x1804c44c,
  0x1809d68f,
  0x1800dd8f,
  0xd701da8f,
  0xd68f1809,
  0xf600e709,
  0x08c44c1c,
  0x00dd5454,
  0x01da8f18,
  0x8f1809d7,
  0x00e709d6,
  0xc44d1cf6,
  0xe709da01,
  0x1cf75f00,
  0x4a1cf74b,
  0xe78effce,
  0x8dffce00,
  0xffce00e7,
  0x1800e686,
  0xe71806de,
  0x2610c403,
  0x02e71803,
  0x026d06de,
  0x03e6e826,
  0x4f4c1cf7,
  0x08df385f,
  0xdf383138,
  0x06de3906,
  0x343c3c3c,
  0x06de069f,
  0x026f01e7,
  0x1803e75f,
  0x1a081cce,
  0x06de04ef,
  0x1804ee1a,
  0x08c400e6,
  0x03e62b27,
  0xffce2126,
  0xf700e687,
  0x01c54d1c,
  0x06de0f27,
  0x0abd8f08,
  0x1801c6fa,
  0xe71806de,
  0x6d06de03,
  0x18df2703,
  0x6f1806de,
  0x1a06de03,
  0x081804ee,
  0x6c04ef1a,
  0xc102e602,
  0x38b72307,
  0xdf383138,
  0x06de3906,
  0x9f3c3c3c,
  0xe706de06,
  0xc6026f01,
  0xa606de0e,
  0x03ed3d02,
  0x181b1cc3,
  0x00e6188f,
  0x502601c1,
  0x1803ee1a,
  0x1c1cc38f,
  0xe6188f18,
  0x2601c100,
  0x03ee1a16,
  0x1cc38f18,
  0xe68f181e,
  0x18343701,
  0x0ebd00e6,
  0xde31318e,
  0x03ee1a06,
  0x1cc38f18,
  0x188f181d,
  0x01c100e6,
  0xee1a1626,
  0xc38f1803,
  0x8f181f1c,
  0x343701e6,
  0xbd00e618,
  0x31318e0e,
  0x026c06de,
  0x03c102e6,
  0x38389123,
  0x3906df38,
  0x3c3c06de,
  0xde069f3c,
  0x0ade3c08,
  0x8dffce3c,
  0xcc01001c,
  0x36376000,
  0x3700fecc,
  0xbdfdc636,
  0x1cfd5715,
  0x5b1cff5d,
  0x378c00cc,
  0x375f4f36,
  0x6000cc36,
  0xfecc3637,
  0xc6363700,
  0xf814bdfd,
  0xfc06de18,
  0xed18591c,
  0x571cfc03,
  0x1801ed18,
  0x0add03ec,
  0xdd01ec18,
  0x840adc08,
  0x03ed18df,
  0xed1808dc,
  0x03eecd01,
  0x01eecd3c,
  0x6400cc3c,
  0xfecc3637,
  0xc6363700,
  0xf814bdfd,
  0xec72fece,
  0x6f0cbd00,
  0x3c591cfe,
  0x3c571cfe,
  0x376400cc,
  0x00fecc36,
  0xfdc63637,
  0xfef814bd,
  0xfe3c5d1c,
  0xcc3c5b1c,
  0x36376000,
  0x3700fecc,
  0xbdfdc636,
  0xce18f814,
  0x1d188dff,
  0xf0ce0100,
  0xfd00ec0e,
  0xfe18551c,
  0xfece551c,
  0xdd00ec70,
  0xd38f1800,
  0xce8f1800,
  0xef1a16f0,
  0xc38f3000,
  0x358f2400,
  0x380adf38,
  0x383808df,
  0x3906df38,
  0x3c3c06de,
  0x9f3c3c3c,
  0x3c08de06,
  0x183c0ade,
  0x5f4f06de,
  0x1803ed18,
  0xed1801ed,
  0x05ed1807,
  0x1c8dffce,
  0xfece0100,
  0x2700e676,
  0xbd137e03,
  0x374c00cc,
  0x00fecc36,
  0xfdc63637,
  0x185715bd,
  0xed1806de,
  0x01efcd03,
  0xdd03ec18,
  0x01ec180a,
  0x0adc08dd,
  0xca8f08de,
  0x08df8f02,
  0xdc03ed18,
  0x01ed1808,
  0x3c03eecd,
  0x3c01eecd,
  0x374c00cc,
  0x00fecc36,
  0xfdc63637,
  0xccf814bd,
  0x36378400,
  0x3700fecc,
  0xbdfdc636,
  0xde185715,
  0x07ed1806,
  0x1805efcd,
  0x0add07ec,
  0xdd05ec18,
  0xca0adc08,
  0x07ed1880,
  0xed1808dc,
  0x07eecd05,
  0x05eecd3c,
  0x8400cc3c,
  0xfecc3637,
  0xc6363700,
  0xf814bdfd,
  0x3701f0cc,
  0x375f4f36,
  0x1800cc36,
  0xfecc3637,
  0xc6363700,
  0xf814bdfd,
  0x3a20c630,
  0x77fece35,
  0x342600e6,
  0x370100cc,
  0x375f4f36,
  0x01f0cc36,
  0xfccc3637,
  0xc6363700,
  0xf814bdfd,
  0x36375f4f,
  0x00cc3637,
  0xcc363718,
  0x363700fe,
  0x14bdfdc6,
  0xc38f30f8,
  0x358f1000,
  0x1806de18,
  0x0add07ec,
  0xdd05ec18,
  0xc40adc08,
  0x07ed187f,
  0xed1808dc,
  0x07eecd05,
  0x05eecd3c,
  0x8400cc3c,
  0xfecc3637,
  0xc6363700,
  0xf814bdfd,
  0x1806de18,
  0x0add03ec,
  0xdd01ec18,
  0xde0adc08,
  0xfdc48f08,
  0x1808df8f,
  0x08dc03ed,
  0xcd01ed18,
  0xcd3c03ee,
  0xcc3c01ee,
  0x36374c00,
  0x3700fecc,
  0xbdfdc636,
  0xde18f814,
  0x03ec1806,
  0xec180add,
  0xdc08dd01,
  0x18078a0a,
  0x08dc03ed,
  0xcd01ed18,
  0xcd3c03ee,
  0xcc3c01ee,
  0x36374c00,
  0x3700fecc,
  0xbdfdc636,
  0x8f30f814,
  0x8f1800c3,
  0x6000cc35,
  0xfecc3637,
  0xc6363700,
  0x5715bdfd,
  0xff5d1cfd,
  0x00cc5b1c,
  0x4f36378c,
  0xcc36375f,
  0x36376000,
  0x3700fecc,
  0xbdfdc636,
  0x00ccf814,
  0xcc363764,
  0x363700fe,
  0x15bdfdc6,
  0x591cfd57,
  0xfe571cff,
  0xfe3c5d1c,
  0xcc3c5b1c,
  0x36376000,
  0x3700fecc,
  0xbdfdc636,
  0xffcef814,
  0x01001d8d,
  0x1c24f0ce,
  0xf0ce0300,
  0xfd00ec0e,
  0xfe18551c,
  0xfece551c,
  0xdd00ec70,
  0xd38f1800,
  0xce8f1800,
  0xef1a16f0,
  0x23f0ce00,
  0x3080001c,
  0x1800c38f,
  0xdf38358f,
  0x08df380a,
  0x38383838,
  0x3906df38,
  0x8a8cffb6,
  0x267f817f,
  0x038639f7,
  0x398cffb7,
  0xffb70186,
  0xa618398c,
  0x81048403,
  0x86042704,
  0x8604200f,
  0xa70020f0,
  0xce183905,
  0xe6180038,
  0x80ffce08,
  0xec1804e7,
  0xe703a700,
  0x02ec1802,
  0xf8c401a7,
  0x00e702ca,
  0x02cccc8d,
  0xe706a700,
  0x06ec1807,
  0x08e709a7,
  0xa704ec18,
  0x860ae70b,
  0x0ba71802,
  0x988da48d,
  0x38ce1839,
  0x08e61800,
  0xe780ffce,
  0x00ec1804,
  0x02e703a7,
  0xa702ec18,
  0xcaf8c401,
  0x8d00e704,
  0x0002cc8d,
  0x07e706a7,
  0xa7180486,
  0x6c14bd0b,
  0x395c14bd,
  0x343c06de,
  0x08de069f,
  0x3c0ade3c,
  0xde3c0cde,
  0x06de3c0e,
  0xde1801e7,
  0x08ec1806,
  0xec180add,
  0x1808dd06,
  0x0edd0cec,
  0xdd0aec18,
  0x0838ce0c,
  0xe701e618,
  0x0038ce00,
  0x02ed0adc,
  0x00ed08dc,
  0xdc0438ce,
  0xdc02ed0e,
  0xbd00ed0c,
  0xdf388614,
  0x0cdf380e,
  0x380adf38,
  0x383108df,
  0xde3906df,
  0x9f343c06,
  0x3c08de06,
  0xde3c0ade,
  0x0ede3c0c,
  0xe706de3c,
  0x06de1801,
  0xdd08ec18,
  0x06ec180a,
  0x38ce08dd,
  0x01e61808,
  0x38ce00e7,
  0xed0adc00,
  0xed08dc02,
  0xc514bd00,
  0xdd83ffcc,
  0xde0edc02,
  0x00ce180c,
  0x183c8d08,
  0xde1804df,
  0x00ea1802,
  0x0cdf0edd,
  0xdf180918,
  0x1800de00,
  0xde1802df,
  0x7fff8c04,
  0x0cded722,
  0xdf183818,
  0x1838180e,
  0x38180cdf,
  0x180adf18,
  0x08df1838,
  0x18381831,
  0x183906df,
  0x1fc44f8f,
  0x09278f18,
  0x49598f05,
  0x2609188f,
  0x064f39f7,
  0x10008c39,
  0x008c0a2c,
  0x05042700,
  0x39fc2609,
  0x0e395f4f,
  0x00fc203e,
  0x00ffffc0,
  0x00000000,
  0x00000000,
  0x00000000,
  0x00007400,
  0x07070000,
  0x00010f0f,
  0x75000000,
  0x00000000,
  0x0f0f0707,
  0x00000000,
  0x00007600,
  0x07070000,
  0x00000f0f,
  0x77000000,
  0x00000000,
  0x0f0f0707,
  0x00000000,
  0x00000000,
  0x01000100,
  0x00000000,
  0x00000000,
  0x00000000,
  0x00000000
};

UINT32 DataBlock1[] = {
  0x41094109,
  0x41094109,
  0x41094109,
  0x41094109,
  0x41094109,
  0x41094109,
  0x41094109,
  0x41094109,
  0x41094109,
  0x41094109,
  0x41095c09,
  0x41094109,
  0xfb084109,
  0x41092009,
  0x00020002,
  0x00020002
};

SMU_FIRMWARE_BLOCK FmBlockArray[] = {
  {
    0x200,
    0x51a,
    &DataBlock0[0]
  },
  {
    0xffc0,
    0x10,
    &DataBlock1[0]
  }
};

SMU_FIRMWARE_HEADER Fm = {
  {
    0x0, 0x0
  },
  2,
  &FmBlockArray[0]
};
#endif

