IMAGE_BUFFER_LOW=0x20000     ;export IMAGE_BUFFER_LOW=$((IMAGE_BUFFER_LOW))
X64_STACK_TOP=0x60000        ;export X64_STACK_TOP=$((X64_STACK_TOP))
FAKE_NVRAM_BASE=0x70000      ;export FAKE_NVRAM_BASE=$((FAKE_NVRAM_BASE))
FAKE_NVRAM_SIZE=0x10000      ;export FAKE_NVRAM_SIZE=$((FAKE_NVRAM_SIZE))
X64_PAGE_TABLE_BASE=0x80000  ;export X64_PAGE_TABLE_BASE=$((X64_PAGE_TABLE_BASE))
X64_PAGE_TABLE_SIZE=0x6000   ;export X64_PAGE_TABLE_SIZE=$((X64_PAGE_TABLE_SIZE))
IMAGE_BUFFER_HIGH=0x100000   ;export IMAGE_BUFFER_HIGH=$((IMAGE_BUFFER_HIGH))
START64CODESIZE=0x2000       ;export START64CODESIZE=$((START64CODESIZE))
EFI64CODESIZE=0x3000         ;export EFI64CODESIZE=$((EFI64CODESIZE))
export EFI64CODESTART=$((IMAGE_BUFFER_HIGH+START64CODESIZE))

# -----coreboot payload logic assumes-----
#   IMAGE_BUFFER_HIGH = 0x100000
#   START64CODESIZE   = 0x2000

export DEBUG_PRINT_LEVEL=0x8000004F
BUILDTARGET=DEBUG
TOOL_CHAIN_TAG=GCC47
TARGETARCH=X64
PROJECT_NAME=DuetPkg

. edksetup.sh
BUILD_DIR=$WORKSPACE/Build
IMAGE_DIR=$BUILD_DIR/images
BASETOOLS_DIR=$WORKSPACE/BaseTools/Source/C/bin
OUTPUT_DIR=$BUILD_DIR/$PROJECT_NAME/${BUILDTARGET}_$TOOL_CHAIN_TAG
OUTPUT_DIR_PROC=$OUTPUT_DIR/$TARGETARCH
BOOTSECTOR_BIN_DIR=$BUILD_DIR/$PROJECT_NAME/${BUILDTARGET}_$TOOL_CHAIN_TAG/$TARGETARCH/DuetPkg/BootSector/BootSector/OUTPUT
PLATFORMFILE=$WORKSPACE/$PROJECT_NAME/DuetPkg$TARGETARCH.dsc

# these can be deleted for cleaning but need to be present for building
mkdir Conf 2>/dev/null
mkdir Build 2>/dev/null

make -C BaseTools
chmod +x BaseTools/Source/C/bin/*
chmod +x BaseTools/BinWrappers/PosixLike/*
chmod +x BaseTools/Bin/linux/*

build -p $PLATFORMFILE -b $BUILDTARGET -t $TOOL_CHAIN_TAG -a $TARGETARCH -D DEBUG_PRINT_LEVEL=$DEBUG_PRINT_LEVEL -D BUILD_NEW_SHELL -D LOGO_FILE=DuetPkg/Coreboot_full_web.bmp -D X64_STACK_TOP=$X64_STACK_TOP -D FAKE_NVRAM_BASE=$FAKE_NVRAM_BASE -D FAKE_NVRAM_SIZE=$FAKE_NVRAM_SIZE -n 16

cd $OUTPUT_DIR/FV                                                                                           
$BASETOOLS_DIR/LzmaCompress -e -o FLASHIMAGE.z DUETEFIMAINFV.Fv                                              
$BASETOOLS_DIR/LzmaCompress -e -o DxeMain.z $OUTPUT_DIR_PROC/DxeCore.efi                                 
$BASETOOLS_DIR/LzmaCompress -e -o DxeIpl.z $OUTPUT_DIR_PROC/DxeIpl.efi                                   
$BASETOOLS_DIR/EfiLdrImage -o Efildr64 $OUTPUT_DIR_PROC/EfiLoader.efi DxeIpl.z DxeMain.z FLASHIMAGE.z
mkdir $IMAGE_DIR 2>/dev/null                                                                                    
cat $BOOTSECTOR_BIN_DIR/st16_64.com $BOOTSECTOR_BIN_DIR/efi64.com2 Efildr64 > $IMAGE_DIR/EFILDR16  
cd $BOOTSECTOR_BIN_DIR
$BASETOOLS_DIR/BuildFatImage mbr=Mbr.com bs=bs16.com ldr=$IMAGE_DIR/EFILDR16 out=$IMAGE_DIR/FAT16.img
cd $WORKSPACE
