/* $NoKeywords:$ */
/**
 * @file
 *
 * AMD F16Kb Microcode patch.
 *
 * F16Kb Microcode Patch rev 07000106 for 7001 or equivalent.
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  CPU/Family/0x16/KB
 * @e \$Revision: 86822 $   @e \$Date: 2013-01-28 00:17:14 -0500 (Mon, 28 Jan 2013) $
 */
/*****************************************************************************
 *
 * Copyright (c) 2008 - 2013, Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/



/*----------------------------------------------------------------------------------------
 *                             M O D U L E S    U S E D
 *----------------------------------------------------------------------------------------
 */
#include "AGESA.h"
#include "Ids.h"
#include "cpuRegisters.h"
#include "cpuEarlyInit.h"
CODE_GROUP (G3_DXE)
RDATA_GROUP (G3_DXE)

/*----------------------------------------------------------------------------------------
 *                   D E F I N I T I O N S    A N D    M A C R O S
 *----------------------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------------------
 *                  T Y P E D E F S     A N D     S T R U C T U R E S
 *----------------------------------------------------------------------------------------
 */


// Encrypt Patch code 07000106 for 7001 and equivalent

CONST UINT8 ROMDATA arr2 [IDS_PAD_4K] =
{
  0x13,
  0x20,
  0x22,
  0x01,
  0x06,
  0x01,
  0x00,
  0x07,
  0x03,
  0x80,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x01,
  0x70,
  0x00,
  0x00,
  0x00,
  0xaa,
  0xaa,
  0xaa,
  0x49,
  0x66,
  0xa8,
  0x8e,
  0x7a,
  0x20,
  0xc7,
  0xae,
  0xe4,
  0xf4,
  0xb4,
  0x4a,
  0x32,
  0x58,
  0xbb,
  0x8b,
  0x60,
  0x57,
  0x0e,
  0x35,
  0x36,
  0xda,
  0x53,
  0x69,
  0xb7,
  0xaf,
  0x84,
  0xe0,
  0x66,
  0x54,
  0x71,
  0x2a,
  0xef,
  0x0f,
  0xf0,
  0x0e,
  0x9d,
  0x5a,
  0xbe,
  0xbe,
  0x19,
  0x2a,
  0xe1,
  0x53,
  0xdf,
  0x30,
  0x15,
  0xe9,
  0x9e,
  0xa2,
  0xb4,
  0x74,
  0x0f,
  0xfa,
  0x38,
  0x6e,
  0x5c,
  0x08,
  0xa5,
  0xe5,
  0xd7,
  0xc3,
  0x24,
  0x04,
  0x5c,
  0x6e,
  0xf5,
  0x57,
  0xb6,
  0x2e,
  0x41,
  0x1d,
  0x5d,
  0xa2,
  0x62,
  0x9c,
  0xce,
  0x79,
  0xfb,
  0xd8,
  0xda,
  0x01,
  0x36,
  0xfe,
  0xcf,
  0x18,
  0x78,
  0xcd,
  0x8b,
  0x49,
  0x92,
  0x0a,
  0x59,
  0x40,
  0x8f,
  0xc9,
  0x3e,
  0xf6,
  0xd7,
  0xea,
  0x78,
  0x89,
  0xc1,
  0xea,
  0xf8,
  0x2e,
  0x35,
  0xf8,
  0xfb,
  0x15,
  0x48,
  0x8f,
  0x07,
  0xd4,
  0x3f,
  0x1f,
  0x85,
  0x38,
  0x87,
  0x17,
  0x38,
  0x23,
  0x9b,
  0xcc,
  0x4a,
  0xea,
  0xfd,
  0x49,
  0x5a,
  0xfe,
  0xb6,
  0x11,
  0x21,
  0xa6,
  0x5d,
  0x26,
  0x5a,
  0x2e,
  0xc9,
  0x49,
  0x4a,
  0x2a,
  0x5b,
  0xc7,
  0x8f,
  0xde,
  0x65,
  0x27,
  0xfd,
  0x9d,
  0x59,
  0x02,
  0xf9,
  0xad,
  0x13,
  0x4a,
  0x19,
  0xb9,
  0x63,
  0x1b,
  0x94,
  0xd8,
  0x24,
  0x87,
  0xd2,
  0xfc,
  0x1d,
  0x4f,
  0xa2,
  0xf1,
  0xf1,
  0x4e,
  0x1a,
  0x8e,
  0x7a,
  0xbd,
  0xaf,
  0xd4,
  0x24,
  0x07,
  0x3b,
  0x43,
  0x2d,
  0xe3,
  0xbf,
  0xc3,
  0x03,
  0x4c,
  0x81,
  0x9b,
  0xec,
  0x8a,
  0x91,
  0x7b,
  0x1c,
  0xe0,
  0x70,
  0xa4,
  0x3f,
  0x83,
  0x4d,
  0xa5,
  0x4b,
  0x9d,
  0xbe,
  0xfe,
  0xdf,
  0xed,
  0xb8,
  0xa9,
  0x0e,
  0xe1,
  0x11,
  0x71,
  0x4d,
  0xfa,
  0x27,
  0x32,
  0x5c,
  0xd1,
  0xe9,
  0x84,
  0xbb,
  0xeb,
  0x65,
  0x19,
  0x09,
  0xc9,
  0x2f,
  0x0c,
  0x80,
  0x14,
  0x3f,
  0x94,
  0x1f,
  0xcd,
  0xaf,
  0x29,
  0x51,
  0x7c,
  0x88,
  0x36,
  0xf3,
  0xcb,
  0x41,
  0x20,
  0xcb,
  0x4c,
  0x1c,
  0x4b,
  0xb2,
  0xaa,
  0x6c,
  0x2c,
  0xab,
  0x37,
  0x5b,
  0x2a,
  0x58,
  0x44,
  0x53,
  0xdf,
  0x59,
  0xbc,
  0x14,
  0xe3,
  0x7f,
  0xd6,
  0x4a,
  0xd6,
  0x98,
  0x59,
  0x8c,
  0xbb,
  0xce,
  0xe6,
  0x86,
  0xdb,
  0x66,
  0xbd,
  0xeb,
  0x51,
  0xf1,
  0xce,
  0x80,
  0x0f,
  0xd9,
  0x83,
  0x86,
  0x17,
  0xed,
  0x78,
  0x3e,
  0x5d,
  0xac,
  0xd1,
  0x13,
  0xfa,
  0x01,
  0x58,
  0x35,
  0xe9,
  0x66,
  0x16,
  0x5d,
  0xa8,
  0x70,
  0x08,
  0x0e,
  0xa3,
  0xab,
  0x3b,
  0xd1,
  0x75,
  0xbf,
  0x2f,
  0xb2,
  0x9a,
  0x7c,
  0xd8,
  0x84,
  0x66,
  0x1a,
  0x07,
  0x00,
  0xe0,
  0x04,
  0xbf,
  0x0e,
  0x04,
  0xaa,
  0x0e,
  0x91,
  0x6f,
  0xb4,
  0xb8,
  0xff,
  0xfa,
  0xad,
  0xb0,
  0xd8,
  0x41,
  0x65,
  0xf5,
  0xd5,
  0x0d,
  0x12,
  0x15,
  0xbf,
  0x40,
  0x5b,
  0xed,
  0xeb,
  0x81,
  0x2a,
  0x1f,
  0x48,
  0x00,
  0x5b,
  0xf7,
  0x08,
  0x35,
  0x86,
  0x8d,
  0xe4,
  0x15,
  0x52,
  0x40,
  0x1b,
  0x88,
  0x5a,
  0x8f,
  0xd0,
  0x4f,
  0xb5,
  0xbc,
  0xdb,
  0x45,
  0x30,
  0xc5,
  0x89,
  0x32,
  0x98,
  0xf9,
  0xa7,
  0x18,
  0x27,
  0xf1,
  0x0b,
  0xc7,
  0x6d,
  0xeb,
  0x7f,
  0x39,
  0xd2,
  0x25,
  0x99,
  0x6d,
  0x3a,
  0x1b,
  0x24,
  0xa4,
  0xc5,
  0x7c,
  0xdf,
  0x33,
  0x3d,
  0x7c,
  0x43,
  0x40,
  0x5b,
  0x8d,
  0xd1,
  0xec,
  0x0c,
  0xca,
  0x76,
  0xd9,
  0x1a,
  0x32,
  0xee,
  0x45,
  0xee,
  0xb6,
  0x30,
  0x21,
  0xf8,
  0x66,
  0xb5,
  0xbf,
  0xfb,
  0x66,
  0x13,
  0x9c,
  0xf0,
  0xcf,
  0xae,
  0xca,
  0x54,
  0xbc,
  0xf1,
  0xce,
  0x76,
  0x57,
  0x8d,
  0xf5,
  0xee,
  0x02,
  0x14,
  0xc0,
  0x62,
  0x3f,
  0xa1,
  0xad,
  0x9d,
  0xbb,
  0x83,
  0x3d,
  0x8f,
  0xf2,
  0xe9,
  0x41,
  0x42,
  0xca,
  0x04,
  0xf9,
  0xf7,
  0x4f,
  0xf7,
  0xc6,
  0x77,
  0xf0,
  0x0e,
  0x8c,
  0xea,
  0xb6,
  0x6c,
  0x47,
  0xae,
  0xd1,
  0x1b,
  0x2c,
  0x89,
  0xbf,
  0x4b,
  0x61,
  0xdc,
  0x2d,
  0x06,
  0x6d,
  0x79,
  0x5c,
  0x5e,
  0x82,
  0xc0,
  0x4f,
  0x54,
  0x5d,
  0x68,
  0x55,
  0x5b,
  0x1c,
  0x75,
  0xb6,
  0xcc,
  0x4b,
  0xb6,
  0x3e,
  0x2b,
  0xec,
  0x30,
  0xa7,
  0x90,
  0xd8,
  0x99,
  0x44,
  0x85,
  0xe7,
  0x21,
  0x33,
  0x00,
  0x48,
  0xf3,
  0xbb,
  0x92,
  0xe9,
  0x48,
  0x99,
  0x45,
  0x66,
  0xd5,
  0xe6,
  0xd9,
  0x9e,
  0x92,
  0x8b,
  0x42,
  0x94,
  0xa3,
  0x2f,
  0x44,
  0xb1,
  0x5e,
  0x07,
  0xd7,
  0x0a,
  0xb4,
  0x7b,
  0x49,
  0x7e,
  0x15,
  0xab,
  0x34,
  0x6b,
  0xff,
  0x1f,
  0xcf,
  0x84,
  0x7f,
  0x57,
  0x6c,
  0xdb,
  0xc3,
  0x3e,
  0xc1,
  0xef,
  0x05,
  0xea,
  0x39,
  0xe0,
  0xe6,
  0x15,
  0x4f,
  0x9a,
  0xdd,
  0x93,
  0x01,
  0x00,
  0x00,
  0x00,
  0x06,
  0x01,
  0x00,
  0x07,
  0xe2,
  0x13,
  0xe7,
  0x13,
  0x93,
  0x07,
  0x66,
  0x04,
  0x60,
  0x04,
  0xd7,
  0x19,
  0x04,
  0x07,
  0xf0,
  0x0c,
  0xf0,
  0x0c,
  0xf0,
  0x0c,
  0xf0,
  0x0c,
  0xf0,
  0x0c,
  0xf0,
  0x0c,
  0xf0,
  0x0c,
  0xf0,
  0x0c,
  0xf0,
  0x0c,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x6f,
  0xd7,
  0x3a,
  0x00,
  0xc0,
  0x9f,
  0xdb,
  0xeb,
  0xff,
  0x57,
  0x7f,
  0x29,
  0xa0,
  0x9f,
  0xc9,
  0xe7,
  0x55,
  0xa0,
  0x06,
  0x00,
  0x67,
  0xd9,
  0x3a,
  0x00,
  0xc0,
  0x9f,
  0xdb,
  0xeb,
  0xc0,
  0xff,
  0xff,
  0x28,
  0xe0,
  0x1f,
  0xe0,
  0xac,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x67,
  0xd9,
  0x3a,
  0x00,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x17,
  0xac,
  0x06,
  0x00,
  0x9d,
  0xf1,
  0xef,
  0x2b,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x16,
  0xac,
  0x06,
  0x00,
  0xf9,
  0xff,
  0xff,
  0x2d,
  0xe1,
  0x9f,
  0xaf,
  0xfe,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x6b,
  0xb8,
  0x06,
  0x00,
  0xf5,
  0xff,
  0xff,
  0x28,
  0xe1,
  0x9f,
  0xaf,
  0xfe,
  0x90,
  0xff,
  0xff,
  0x29,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xdf,
  0xff,
  0xff,
  0x2e,
  0xe0,
  0x1f,
  0xab,
  0xfa,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x9d,
  0x4b,
  0xe1,
  0x53,
  0xa0,
  0x06,
  0x00,
  0xd9,
  0xff,
  0xff,
  0x00,
  0xe1,
  0xcf,
  0x43,
  0xd7,
  0x70,
  0x5c,
  0x39,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xa3,
  0xdb,
  0x38,
  0x00,
  0xc1,
  0xdf,
  0xd9,
  0xeb,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xd7,
  0xb8,
  0x06,
  0x00,
  0x00,
  0xff,
  0xff,
  0x3c,
  0xe1,
  0x5f,
  0xeb,
  0xfe,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xdd,
  0x7f,
  0x2c,
  0xe0,
  0x0f,
  0x6b,
  0xff,
  0x4b,
  0xd8,
  0x38,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0x91,
  0xbb,
  0x06,
  0x00,
  0x2b,
  0xce,
  0x38,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x90,
  0xbb,
  0x06,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x29,
  0xe1,
  0x4f,
  0x2a,
  0xca,
  0xff,
  0x81,
  0x7f,
  0x2d,
  0xe1,
  0x4f,
  0x2b,
  0xca,
  0xfa,
  0xb8,
  0x06,
  0x00,
  0xfb,
  0xff,
  0xff,
  0x2d,
  0xe1,
  0xdf,
  0xab,
  0xfe,
  0x23,
  0xd3,
  0x38,
  0x00,
  0xc1,
  0x1d,
  0x00,
  0xf9,
  0x19,
  0xa1,
  0x06,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x76,
  0x5e,
  0x39,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0xf5,
  0xff,
  0xff,
  0x2e,
  0xe1,
  0x1f,
  0xe0,
  0xac,
  0x93,
  0xbf,
  0x06,
  0x00,
  0xff,
  0xdd,
  0x7f,
  0x2f,
  0xe0,
  0xdf,
  0xab,
  0xff,
  0x76,
  0x5e,
  0x39,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xd1,
  0x7f,
  0x28,
  0xe0,
  0x1f,
  0x6b,
  0xf1,
  0x67,
  0xd1,
  0x3a,
  0x00,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0x33,
  0xa1,
  0x06,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x32,
  0xa1,
  0x06,
  0x00,
  0xf8,
  0xff,
  0xff,
  0x00,
  0xe1,
  0x9d,
  0x0b,
  0xf9,
  0xfe,
  0xff,
  0xff,
  0x00,
  0xe1,
  0xcf,
  0x43,
  0xd7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x2b,
  0xce,
  0x38,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x94,
  0x5b,
  0x02,
  0x00,
  0x57,
  0xdc,
  0x38,
  0x00,
  0xc0,
  0xdf,
  0xdb,
  0xeb,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x98,
  0x5b,
  0x06,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x13,
  0x42,
  0x99,
  0xf4,
  0x9c,
  0x43,
  0x10,
  0xb9,
  0x93,
  0x17,
  0x40,
  0x75,
  0x1b,
  0x3d,
  0x9e,
  0xa9,
  0x4f,
  0xbf,
  0xac,
  0x60,
  0x92,
  0x6b,
  0xbb,
  0x51,
  0x50,
  0x1a,
  0x56,
  0xc0,
  0x34,
  0x59,
  0xb6,
  0x4a,
  0x30,
  0x0a,
  0x21,
  0xa2,
  0x14,
  0x1f,
  0x8d,
  0x89,
  0xc4,
  0x82,
  0xb0,
  0x5c,
  0x8d,
  0x49,
  0x3d,
  0xb8,
  0x34,
  0x7a,
  0x54,
  0xb2,
  0xc2,
  0x0e,
  0x5b,
  0xbc,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
};

/*----------------------------------------------------------------------------------------
 *           P R O T O T Y P E S     O F     L O C A L     F U N C T I O N S
 *----------------------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------------------
 *                          E X P O R T E D    F U N C T I O N S
 *----------------------------------------------------------------------------------------
 */
