/* $NoKeywords:$ */
/**
 * @file
 *
 * AMD F16Kb Microcode patch.
 *
 * F16Kb Microcode Patch rev 0700002A for 7000 or equivalent.
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  CPU/Family/0x16/KB
 * @e \$Revision: 84798 $   @e \$Date: 2012-12-19 21:26:23 -0600 (Wed, 19 Dec 2012) $
 */
/*****************************************************************************
 *
 * Copyright (c) 2008 - 2013, Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/



/*----------------------------------------------------------------------------------------
 *                             M O D U L E S    U S E D
 *----------------------------------------------------------------------------------------
 */
#include "AGESA.h"
#include "Ids.h"
#include "cpuRegisters.h"
#include "cpuEarlyInit.h"
CODE_GROUP (G3_DXE)
RDATA_GROUP (G3_DXE)

/*----------------------------------------------------------------------------------------
 *                   D E F I N I T I O N S    A N D    M A C R O S
 *----------------------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------------------
 *                  T Y P E D E F S     A N D     S T R U C T U R E S
 *----------------------------------------------------------------------------------------
 */


// Encrypt Patch code 0700002A for 7000 and equivalent

CONST UINT8 ROMDATA arr1 [IDS_PAD_4K] =
{
  0x12,
  0x20,
  0x18,
  0x12,
  0x2a,
  0x00,
  0x00,
  0x07,
  0x03,
  0x80,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x70,
  0x00,
  0x00,
  0x00,
  0xaa,
  0xaa,
  0xaa,
  0x49,
  0x98,
  0x47,
  0x92,
  0x9e,
  0x94,
  0x1c,
  0x90,
  0x43,
  0x82,
  0xfb,
  0x61,
  0x5c,
  0xc3,
  0x8a,
  0xb1,
  0xd7,
  0x77,
  0xc5,
  0x2f,
  0xe2,
  0x32,
  0x8e,
  0xa2,
  0xfe,
  0x17,
  0x86,
  0x8b,
  0xea,
  0xf8,
  0x9c,
  0x9a,
  0xdb,
  0x75,
  0x44,
  0x1c,
  0x12,
  0xd5,
  0x0f,
  0x64,
  0x9f,
  0x29,
  0x38,
  0x9c,
  0xec,
  0xfd,
  0x20,
  0xb9,
  0x5c,
  0x11,
  0xfa,
  0xac,
  0xde,
  0xa7,
  0xaf,
  0xb2,
  0x71,
  0x1b,
  0x5d,
  0x8d,
  0x0a,
  0x84,
  0xff,
  0xae,
  0x77,
  0xef,
  0xee,
  0xe8,
  0xb9,
  0xe4,
  0x4c,
  0xcf,
  0x43,
  0x69,
  0xda,
  0x62,
  0x85,
  0x56,
  0x75,
  0xf4,
  0xa9,
  0x9e,
  0x2a,
  0x63,
  0x6d,
  0xdd,
  0xcb,
  0x04,
  0x18,
  0xeb,
  0xa5,
  0xab,
  0x8d,
  0xd7,
  0x03,
  0x48,
  0x71,
  0x18,
  0x18,
  0x3e,
  0xff,
  0x33,
  0x60,
  0xb0,
  0x43,
  0x6c,
  0xa3,
  0xc6,
  0x78,
  0x0a,
  0xc8,
  0x88,
  0x0b,
  0x85,
  0x34,
  0x41,
  0x72,
  0xe7,
  0x2f,
  0xac,
  0x22,
  0x75,
  0x9c,
  0xe3,
  0x58,
  0xa0,
  0xf4,
  0xa7,
  0x39,
  0x42,
  0x6c,
  0x39,
  0xe6,
  0x8e,
  0xd2,
  0xbc,
  0x6d,
  0xea,
  0x84,
  0xb6,
  0x83,
  0xdf,
  0xfa,
  0x39,
  0xf8,
  0x22,
  0x55,
  0xd4,
  0x69,
  0x89,
  0x6a,
  0xcd,
  0xb0,
  0x3d,
  0xdc,
  0x2e,
  0x16,
  0xcd,
  0xd6,
  0xeb,
  0x66,
  0x67,
  0x74,
  0xc1,
  0x3c,
  0x7c,
  0xed,
  0xce,
  0x4c,
  0x15,
  0xdf,
  0x64,
  0x80,
  0xbc,
  0x7f,
  0xee,
  0x45,
  0x2f,
  0xa2,
  0x64,
  0x3b,
  0xed,
  0x26,
  0xdd,
  0xb5,
  0xb7,
  0xef,
  0xa2,
  0x7d,
  0x9b,
  0x05,
  0x67,
  0xbe,
  0x6e,
  0xbd,
  0xb4,
  0x7d,
  0x22,
  0x9f,
  0xea,
  0x5b,
  0xe5,
  0xf2,
  0x4b,
  0x5c,
  0xfa,
  0xad,
  0xcc,
  0x41,
  0x10,
  0x63,
  0x1a,
  0xc3,
  0x7a,
  0x8a,
  0x1e,
  0xc2,
  0x41,
  0x3f,
  0xde,
  0x82,
  0x7c,
  0xa9,
  0x49,
  0x43,
  0xd2,
  0x05,
  0x83,
  0xe6,
  0x2c,
  0x3f,
  0xb1,
  0x61,
  0xac,
  0x78,
  0x8a,
  0x03,
  0xe9,
  0xda,
  0x54,
  0xfd,
  0x80,
  0x93,
  0x32,
  0x84,
  0xf6,
  0xee,
  0xb1,
  0x5b,
  0xa4,
  0x3e,
  0x0d,
  0x7a,
  0x6a,
  0x53,
  0x85,
  0x61,
  0x29,
  0x17,
  0xb6,
  0xd3,
  0xaa,
  0x02,
  0x2e,
  0xef,
  0x99,
  0x23,
  0x88,
  0x70,
  0xa8,
  0xfa,
  0xbf,
  0x0a,
  0xac,
  0x41,
  0x1f,
  0x38,
  0x03,
  0x12,
  0x9f,
  0x87,
  0xd8,
  0x74,
  0xdb,
  0xf5,
  0x51,
  0x53,
  0xb0,
  0x57,
  0x74,
  0x1d,
  0xcd,
  0x21,
  0x0e,
  0xa8,
  0x0f,
  0x3e,
  0x0c,
  0x40,
  0x09,
  0xd2,
  0x1d,
  0xd7,
  0xb1,
  0x85,
  0x0d,
  0x1f,
  0x47,
  0x3e,
  0x59,
  0x67,
  0x09,
  0x95,
  0xbb,
  0x05,
  0x52,
  0x7f,
  0xf3,
  0xc2,
  0xf5,
  0x1a,
  0x80,
  0x6d,
  0x31,
  0x18,
  0x9d,
  0xc4,
  0x47,
  0xb4,
  0x5f,
  0x3c,
  0xbb,
  0x20,
  0x51,
  0x02,
  0x5a,
  0x32,
  0x13,
  0x8d,
  0x25,
  0x99,
  0x8d,
  0xa1,
  0x87,
  0x53,
  0xff,
  0x0b,
  0x74,
  0x68,
  0x85,
  0x34,
  0x3a,
  0x56,
  0xfd,
  0x68,
  0x0c,
  0x15,
  0xd2,
  0x67,
  0x4b,
  0x45,
  0xa5,
  0x1b,
  0x5c,
  0x5b,
  0xc9,
  0x08,
  0x73,
  0x99,
  0xd4,
  0xbb,
  0xca,
  0x5c,
  0x96,
  0x39,
  0x9c,
  0xbb,
  0xfe,
  0x1d,
  0xff,
  0x70,
  0xe1,
  0xdd,
  0xfb,
  0xb7,
  0x5a,
  0xce,
  0x1f,
  0x16,
  0xc8,
  0x2b,
  0x2d,
  0xa5,
  0xdc,
  0xbf,
  0x08,
  0xfe,
  0x8a,
  0xf8,
  0xd6,
  0xd7,
  0xf5,
  0x0e,
  0x5e,
  0xcf,
  0xb1,
  0x0f,
  0xf8,
  0x0c,
  0x89,
  0xb4,
  0x36,
  0xd3,
  0x81,
  0xe4,
  0xd5,
  0x16,
  0x23,
  0xe3,
  0x1c,
  0xb3,
  0xe1,
  0x82,
  0x41,
  0x81,
  0xd4,
  0x6b,
  0xc2,
  0x51,
  0xfb,
  0x26,
  0x59,
  0x9c,
  0x01,
  0xc2,
  0xc7,
  0xc1,
  0x60,
  0xf9,
  0xe0,
  0xfc,
  0x46,
  0xc0,
  0xd1,
  0xf7,
  0xc7,
  0xe1,
  0x44,
  0x23,
  0x3c,
  0x9d,
  0xec,
  0xbb,
  0x6e,
  0x88,
  0xae,
  0x2c,
  0xec,
  0xfb,
  0x5f,
  0xf4,
  0x12,
  0x35,
  0xff,
  0x09,
  0x81,
  0x66,
  0x81,
  0x56,
  0xcd,
  0xee,
  0x62,
  0x61,
  0x4d,
  0xc3,
  0xb7,
  0x45,
  0xa4,
  0xec,
  0x07,
  0xca,
  0x49,
  0xce,
  0x34,
  0x56,
  0x33,
  0xdf,
  0xaa,
  0xcb,
  0xf4,
  0xf8,
  0x00,
  0x29,
  0x2f,
  0x30,
  0xf4,
  0xb9,
  0x7a,
  0x5b,
  0x1b,
  0xb5,
  0xe4,
  0x14,
  0x78,
  0x04,
  0x04,
  0xb6,
  0x51,
  0xd2,
  0xf6,
  0xf1,
  0xf4,
  0x09,
  0xca,
  0x66,
  0xe5,
  0x79,
  0xda,
  0xff,
  0xbd,
  0x23,
  0x3e,
  0xb9,
  0xcb,
  0x81,
  0x4b,
  0x32,
  0xff,
  0x3d,
  0x64,
  0x5b,
  0xf3,
  0x78,
  0xe7,
  0x91,
  0x40,
  0x89,
  0xf4,
  0xdc,
  0x50,
  0xa7,
  0xd7,
  0x2c,
  0xd1,
  0x93,
  0x4d,
  0x7f,
  0x35,
  0xa7,
  0xd1,
  0xd1,
  0x17,
  0x99,
  0x63,
  0xae,
  0x8a,
  0x4c,
  0x5a,
  0x50,
  0x47,
  0xa7,
  0x15,
  0x5e,
  0xbc,
  0x09,
  0xce,
  0x7f,
  0x54,
  0x70,
  0xfc,
  0x22,
  0xef,
  0x86,
  0x57,
  0xa7,
  0x68,
  0x01,
  0x00,
  0x00,
  0x00,
  0x2a,
  0x00,
  0x00,
  0x07,
  0x0c,
  0x1b,
  0xae,
  0x1d,
  0x63,
  0x04,
  0x5d,
  0x04,
  0x05,
  0x1a,
  0xd4,
  0x06,
  0xa0,
  0x0d,
  0x0e,
  0x13,
  0xec,
  0x0f,
  0x1b,
  0x10,
  0xe7,
  0x13,
  0x40,
  0x1f,
  0x70,
  0x10,
  0x3e,
  0x11,
  0xe2,
  0x13,
  0x93,
  0x07,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xff,
  0xf7,
  0x7f,
  0x22,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0x43,
  0x0c,
  0xfe,
  0x00,
  0xe1,
  0xcf,
  0x43,
  0xd7,
  0xf1,
  0xa4,
  0x06,
  0x00,
  0x65,
  0xd1,
  0x38,
  0x80,
  0xc1,
  0x1f,
  0x10,
  0xe0,
  0xf7,
  0xff,
  0xff,
  0x80,
  0xe1,
  0x1b,
  0x8a,
  0xfa,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xff,
  0xbf,
  0x2e,
  0xe0,
  0x9f,
  0xab,
  0xff,
  0xff,
  0x7f,
  0xff,
  0xff,
  0xff,
  0xff,
  0xcf,
  0xbf,
  0xf8,
  0xb9,
  0x06,
  0x00,
  0x5a,
  0x5c,
  0x39,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xdf,
  0xff,
  0xff,
  0x2e,
  0xe0,
  0x1f,
  0xab,
  0xfa,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x9d,
  0x4b,
  0xe1,
  0x0a,
  0xa0,
  0x06,
  0x00,
  0x8e,
  0xff,
  0xff,
  0x00,
  0xe1,
  0xcf,
  0x43,
  0xd7,
  0x70,
  0x5c,
  0x39,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xa3,
  0xdb,
  0x38,
  0x00,
  0xc1,
  0xdf,
  0xd9,
  0xeb,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xda,
  0xb8,
  0x06,
  0x00,
  0x00,
  0xff,
  0xff,
  0x3c,
  0xe1,
  0x5f,
  0xeb,
  0xfe,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xdb,
  0x7a,
  0x00,
  0xc0,
  0x1f,
  0xdb,
  0xeb,
  0xf4,
  0x01,
  0x39,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0x4d,
  0xa0,
  0x06,
  0x00,
  0x5b,
  0xd4,
  0x38,
  0x00,
  0x80,
  0x1f,
  0xc0,
  0xff,
  0x9f,
  0xfa,
  0xff,
  0xac,
  0xe1,
  0x1f,
  0xeb,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xf8,
  0xff,
  0xff,
  0x2c,
  0xe1,
  0x1f,
  0xeb,
  0xfe,
  0xe2,
  0xff,
  0xff,
  0x2e,
  0xe1,
  0x9f,
  0xab,
  0xfa,
  0x27,
  0xb9,
  0x06,
  0x00,
  0x0d,
  0xdd,
  0x38,
  0xc0,
  0xa1,
  0x1f,
  0xc0,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x26,
  0xb9,
  0x06,
  0x00,
  0xfd,
  0xff,
  0xff,
  0x2c,
  0xe0,
  0x9f,
  0x6b,
  0xf1,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xf3,
  0xb8,
  0x06,
  0x00,
  0xf0,
  0x58,
  0x39,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0xf0,
  0x5c,
  0x39,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x43,
  0xdc,
  0x38,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0x3f,
  0xdc,
  0x38,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0x1f,
  0xa3,
  0x06,
  0x00,
  0xff,
  0x7f,
  0xff,
  0x2e,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0x8d,
  0xdf,
  0x38,
  0x00,
  0xc1,
  0x1f,
  0x10,
  0xe0,
  0xff,
  0xbd,
  0x07,
  0x00,
  0x38,
  0xdd,
  0x38,
  0xc0,
  0xa1,
  0x1f,
  0xc0,
  0xe7,
  0xb1,
  0xfe,
  0x38,
  0xc0,
  0xa1,
  0x1f,
  0xc0,
  0xe7,
  0xe6,
  0x2f,
  0x06,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x56,
  0x5f,
  0x06,
  0x00,
  0xf8,
  0xff,
  0xff,
  0x2d,
  0xe1,
  0x5f,
  0xeb,
  0xfe,
  0xf0,
  0xff,
  0xff,
  0x2e,
  0xe1,
  0x9f,
  0xeb,
  0xfe,
  0x56,
  0xb8,
  0x06,
  0x00,
  0xff,
  0xdd,
  0x7f,
  0x00,
  0xe1,
  0x5d,
  0x8b,
  0xfe,
  0xff,
  0xdb,
  0x7f,
  0x2e,
  0xe1,
  0x8f,
  0x6b,
  0xcb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x67,
  0xd9,
  0x3a,
  0x00,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x42,
  0xa0,
  0x06,
  0x00,
  0x9d,
  0xf1,
  0xef,
  0x2b,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xe0,
  0xff,
  0xff,
  0x2f,
  0xe1,
  0x1f,
  0xe0,
  0xac,
  0xdf,
  0xfb,
  0xff,
  0x2c,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0x2c,
  0xa0,
  0x06,
  0x00,
  0xf7,
  0x63,
  0x3f,
  0x00,
  0xc0,
  0x9f,
  0xd9,
  0xeb,
  0xef,
  0x61,
  0x3f,
  0x00,
  0xc0,
  0x9f,
  0xd9,
  0xeb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xd7,
  0x7a,
  0x00,
  0xc0,
  0xdf,
  0xda,
  0xeb,
  0xe7,
  0xff,
  0xff,
  0x00,
  0xe0,
  0xdd,
  0x0a,
  0xf9,
  0x81,
  0xaf,
  0x06,
  0x00,
  0xef,
  0x56,
  0x39,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0xdf,
  0xff,
  0xff,
  0x2f,
  0xe0,
  0xdf,
  0xab,
  0xfa,
  0x80,
  0xaf,
  0x06,
  0x00,
  0x7f,
  0xfd,
  0x38,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0x67,
  0xf9,
  0x38,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0x0d,
  0xa0,
  0x06,
  0x00,
  0x77,
  0xd5,
  0x38,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0xff,
  0xd9,
  0x7f,
  0x3f,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x6f,
  0xd7,
  0x3a,
  0x00,
  0xc0,
  0x9f,
  0xdb,
  0xeb,
  0xff,
  0x57,
  0x7f,
  0x29,
  0xa0,
  0x9f,
  0xc9,
  0xe7,
  0x0c,
  0xa0,
  0x06,
  0x00,
  0x67,
  0xd9,
  0x3a,
  0x00,
  0xc0,
  0x9f,
  0xdb,
  0xeb,
  0xc0,
  0xff,
  0xff,
  0x28,
  0xe0,
  0x1f,
  0xe0,
  0xac,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xf9,
  0xff,
  0xff,
  0x2d,
  0xe1,
  0x9f,
  0xaf,
  0xfe,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x6b,
  0xb8,
  0x06,
  0x00,
  0xf5,
  0xff,
  0xff,
  0x28,
  0xe1,
  0x9f,
  0xaf,
  0xfe,
  0x90,
  0xff,
  0xff,
  0x29,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x0b,
  0xd0,
  0x38,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0x7b,
  0xfa,
  0xff,
  0xa8,
  0xe1,
  0x1f,
  0xea,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xdb,
  0x7a,
  0x00,
  0xc1,
  0x1f,
  0x1a,
  0xe0,
  0x00,
  0xff,
  0xff,
  0x2d,
  0xe1,
  0x5b,
  0xeb,
  0xfe,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x07,
  0xd0,
  0x38,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0x6f,
  0xfc,
  0xff,
  0xa8,
  0xe1,
  0x1f,
  0xea,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xd9,
  0x7a,
  0x00,
  0xc1,
  0x1f,
  0x1a,
  0xe0,
  0xff,
  0xff,
  0xff,
  0xac,
  0xe1,
  0x1f,
  0xeb,
  0xe1,
  0x5b,
  0x92,
  0x06,
  0x00,
  0xff,
  0xd9,
  0x7f,
  0x2d,
  0xe1,
  0x5f,
  0xab,
  0xfe,
  0xa1,
  0xdb,
  0x38,
  0x00,
  0xa1,
  0x1f,
  0xc0,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xf9,
  0xff,
  0xff,
  0x2f,
  0xe1,
  0xdf,
  0xab,
  0xfa,
  0xfc,
  0xff,
  0xff,
  0x2f,
  0xe1,
  0xdf,
  0xeb,
  0xfe,
  0x1e,
  0xa0,
  0x06,
  0x00,
  0xfe,
  0xff,
  0xff,
  0x00,
  0xe1,
  0xdb,
  0x8b,
  0xfe,
  0xff,
  0xff,
  0xff,
  0x00,
  0xe1,
  0xd7,
  0xc3,
  0xd6,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xfb,
  0xff,
  0x26,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xa3,
  0xdf,
  0x38,
  0x00,
  0xc1,
  0x9f,
  0xd9,
  0xeb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xe7,
  0xff,
  0xff,
  0x2f,
  0xe1,
  0xdf,
  0xeb,
  0xfa,
  0xf7,
  0xff,
  0xff,
  0x2f,
  0xe1,
  0xdf,
  0xeb,
  0xff,
  0x1e,
  0xa0,
  0x06,
  0x00,
  0xef,
  0xdf,
  0x3a,
  0x00,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xd5,
  0x7a,
  0x00,
  0xc1,
  0x1f,
  0xdb,
  0xeb,
  0x81,
  0xff,
  0xff,
  0x2c,
  0xe1,
  0x9f,
  0xea,
  0xfe,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xf7,
  0xff,
  0xff,
  0x2c,
  0xe1,
  0x1f,
  0xeb,
  0xff,
  0xf8,
  0xff,
  0xff,
  0x2a,
  0xe1,
  0x9f,
  0xaa,
  0xfa,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xfe,
  0xff,
  0xff,
  0x2a,
  0xe1,
  0x9f,
  0xea,
  0xfe,
  0xff,
  0xd5,
  0x7f,
  0x2c,
  0xe1,
  0x1f,
  0xab,
  0xfa,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe0,
  0x1f,
  0x4b,
  0xe6,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe0,
  0xdf,
  0x79,
  0xe4,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xab,
  0xdb,
  0x38,
  0x00,
  0xc0,
  0x5f,
  0x9a,
  0xfc,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x2a,
  0xe0,
  0x1f,
  0xe0,
  0xe2,
  0xff,
  0xcf,
  0x7f,
  0x27,
  0xe0,
  0x5f,
  0x6b,
  0xe3,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xdc,
  0xff,
  0xff,
  0x27,
  0xe0,
  0xdd,
  0xa9,
  0xfa,
  0xe2,
  0xff,
  0xff,
  0x2a,
  0xe0,
  0x9f,
  0xea,
  0xfa,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xd5,
  0x7f,
  0x2c,
  0xe0,
  0xcf,
  0x69,
  0xff,
  0x4f,
  0xd8,
  0x38,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x2e,
  0xe0,
  0x1f,
  0xe0,
  0xe2,
  0xff,
  0xd9,
  0x7f,
  0x2c,
  0xe0,
  0x9f,
  0x6b,
  0xe3,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xdf,
  0xff,
  0xff,
  0x2c,
  0xe0,
  0x1d,
  0xab,
  0xfa,
  0xdf,
  0xff,
  0xff,
  0x2e,
  0xe0,
  0x9f,
  0xeb,
  0xfa,
  0xef,
  0xa5,
  0x06,
  0x00,
  0xff,
  0xdd,
  0x7f,
  0x2c,
  0xe0,
  0x0f,
  0x6b,
  0xff,
  0x2b,
  0xce,
  0x38,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0x94,
  0xbb,
  0x06,
  0x00,
  0xdf,
  0xfb,
  0xff,
  0x2c,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0xdf,
  0x7a,
  0x2c,
  0xc0,
  0x9f,
  0xdb,
  0xeb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xf7,
  0x5f,
  0x3f,
  0x00,
  0xa0,
  0x9f,
  0xc9,
  0xe7,
  0xf7,
  0xdf,
  0x3a,
  0x2c,
  0xc0,
  0x9f,
  0xdb,
  0xeb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xef,
  0x5f,
  0x3f,
  0x00,
  0xa0,
  0x9f,
  0xc9,
  0xe7,
  0x2f,
  0xcc,
  0x38,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xf7,
  0xdf,
  0x3a,
  0x2c,
  0xc0,
  0x9f,
  0xdb,
  0xeb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xff,
  0xff,
  0x00,
  0xe1,
  0xdd,
  0x0b,
  0xf9,
  0xfe,
  0xff,
  0xff,
  0x2d,
  0xe1,
  0x4b,
  0x6b,
  0xcb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x5b,
  0x7f,
  0x00,
  0xa0,
  0x9f,
  0xc9,
  0xe7,
  0xe7,
  0xff,
  0xff,
  0x26,
  0xe0,
  0x9f,
  0xe9,
  0xff,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xf3,
  0xff,
  0xff,
  0x00,
  0xe1,
  0xd7,
  0xc3,
  0xd6,
  0x7f,
  0x5e,
  0x3f,
  0x00,
  0xa0,
  0x9f,
  0xc9,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xff,
  0xbf,
  0x2d,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0x0f,
  0xff,
  0xfe,
  0xff,
  0xff,
  0xff,
  0xcf,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xdb,
  0x7f,
  0x2d,
  0xe0,
  0xdf,
  0x6b,
  0xf1,
  0xcc,
  0xff,
  0xff,
  0x2b,
  0xe0,
  0x1f,
  0xe0,
  0xac,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xe0,
  0xff,
  0xff,
  0x28,
  0xe1,
  0x1f,
  0xe0,
  0xac,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xd7,
  0x7f,
  0x2d,
  0xe0,
  0x5f,
  0xab,
  0xff,
  0xf7,
  0xdb,
  0x3a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xd1,
  0x7a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x00,
  0x00,
  0xfe,
  0x2b,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0x00,
  0x00,
  0xfe,
  0x2d,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0x49,
  0x9d,
  0x06,
  0x00,
  0x00,
  0x00,
  0xbf,
  0x2a,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0x00,
  0x80,
  0xff,
  0x7f,
  0x80,
  0x3e,
  0xce,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xdf,
  0xbf,
  0x2a,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0x5d,
  0xff,
  0xff,
  0xff,
  0xff,
  0xcf,
  0xbf,
  0x49,
  0x3d,
  0x06,
  0x00,
  0xb0,
  0xff,
  0xff,
  0x2b,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0xc0,
  0xff,
  0xff,
  0x2a,
  0xe0,
  0x1f,
  0xe0,
  0xac,
  0x49,
  0x3d,
  0x06,
  0x00,
  0x2f,
  0xd4,
  0x38,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0x67,
  0x5e,
  0x3f,
  0x00,
  0xc0,
  0x9f,
  0xda,
  0xeb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xdf,
  0xfb,
  0xff,
  0x2c,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xf7,
  0xdf,
  0x3a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xd1,
  0x7a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x2f,
  0xd4,
  0x38,
  0x00,
  0xc0,
  0x1f,
  0xd0,
  0xeb,
  0xf7,
  0x5f,
  0x3f,
  0x00,
  0xc0,
  0x9f,
  0xda,
  0xeb,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xef,
  0x5b,
  0x3f,
  0x00,
  0xc0,
  0x9f,
  0xda,
  0xeb,
  0x00,
  0xff,
  0xff,
  0x2f,
  0xe1,
  0xdf,
  0xeb,
  0xfe,
  0x48,
  0xba,
  0x06,
  0x00,
  0xff,
  0xdf,
  0x7a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xf7,
  0xdb,
  0x3a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0x47,
  0xba,
  0x06,
  0x00,
  0xe7,
  0xff,
  0xff,
  0x26,
  0xe0,
  0x9f,
  0xe9,
  0xff,
  0xf4,
  0xff,
  0xff,
  0x00,
  0xe1,
  0xcf,
  0x03,
  0xd7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xf7,
  0x81,
  0x3a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0xdf,
  0x7a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x2b,
  0xe0,
  0xdf,
  0xeb,
  0xf3,
  0x00,
  0x00,
  0xfe,
  0x2d,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0x49,
  0x9d,
  0x06,
  0x00,
  0x00,
  0x00,
  0xbf,
  0x2a,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0x00,
  0x80,
  0xff,
  0x7f,
  0x80,
  0x3e,
  0xce,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xdf,
  0xbf,
  0x2a,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0x5d,
  0xff,
  0xff,
  0xff,
  0xff,
  0xcf,
  0xbf,
  0x49,
  0x3d,
  0x06,
  0x00,
  0xb0,
  0xff,
  0xff,
  0x2b,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0xc0,
  0xff,
  0xff,
  0x2a,
  0xe0,
  0x1f,
  0xe0,
  0xac,
  0x49,
  0x3d,
  0x06,
  0x00,
  0xcc,
  0xff,
  0xff,
  0x2d,
  0xe0,
  0x1f,
  0xe0,
  0xac,
  0xff,
  0xe5,
  0x7f,
  0x2a,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x67,
  0x5e,
  0x3f,
  0x00,
  0xc0,
  0x9f,
  0xda,
  0xeb,
  0xff,
  0xdb,
  0x7f,
  0x2d,
  0xe0,
  0xdf,
  0xab,
  0xff,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xfe,
  0xff,
  0xff,
  0x2a,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0xd5,
  0x7f,
  0x2d,
  0xe0,
  0x5f,
  0x6b,
  0xf1,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xdf,
  0xfb,
  0xff,
  0x2c,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xe0,
  0xff,
  0xff,
  0x29,
  0xe1,
  0x1f,
  0xe0,
  0xac,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xf7,
  0xdb,
  0x3a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0xd3,
  0x7a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xf7,
  0xdf,
  0x3a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0xd3,
  0x7a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x00,
  0xff,
  0xff,
  0x31,
  0xe1,
  0x5f,
  0xec,
  0xfe,
  0xff,
  0xe3,
  0x7a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xc3,
  0xb2,
  0x06,
  0x00,
  0xf7,
  0xe1,
  0x3a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xc2,
  0xb2,
  0x06,
  0x00,
  0x0a,
  0x02,
  0xff,
  0x2e,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0x7f,
  0xfd,
  0xff,
  0x2c,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xfa,
  0x3a,
  0x06,
  0x00,
  0x39,
  0x1f,
  0xfe,
  0x00,
  0xe1,
  0xcf,
  0x03,
  0xd7,
  0xe7,
  0xff,
  0xff,
  0x2e,
  0xe0,
  0x9f,
  0xeb,
  0xfa,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xee,
  0xff,
  0xff,
  0x2d,
  0xe1,
  0x1f,
  0xe0,
  0xac,
  0xff,
  0xdb,
  0x7a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x2b,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x2d,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0x11,
  0x20,
  0x06,
  0x00,
  0x17,
  0xfc,
  0xbf,
  0x2d,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0xff,
  0xff,
  0xff,
  0xff,
  0xff,
  0xcf,
  0xbf,
  0x11,
  0x80,
  0x06,
  0x00,
  0xfc,
  0xff,
  0xff,
  0x2b,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xe3,
  0xff,
  0xff,
  0x2b,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xee,
  0xff,
  0xff,
  0x2d,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0x11,
  0x20,
  0x06,
  0x00,
  0xff,
  0xff,
  0xbf,
  0x2d,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0xff,
  0xef,
  0xff,
  0xaa,
  0xff,
  0xcf,
  0xbf,
  0x11,
  0x80,
  0x06,
  0x00,
  0xf1,
  0xff,
  0xff,
  0x2b,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xff,
  0xbf,
  0x2d,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0xff,
  0x9f,
  0xef,
  0xd5,
  0xfe,
  0xcf,
  0xbf,
  0x11,
  0x80,
  0x06,
  0x00,
  0xf0,
  0xff,
  0xff,
  0x2b,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x2b,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xfe,
  0xff,
  0xff,
  0x2d,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0x11,
  0x20,
  0x06,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x56,
  0x5f,
  0x06,
  0x00,
  0x0a,
  0x02,
  0xff,
  0x2e,
  0xe0,
  0x1f,
  0xe0,
  0xe7,
  0xe7,
  0xff,
  0xff,
  0x2e,
  0xe0,
  0x9f,
  0xeb,
  0xfa,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xe0,
  0xff,
  0xff,
  0x29,
  0xe1,
  0x1f,
  0xe0,
  0xac,
  0xdf,
  0xfb,
  0xff,
  0x2c,
  0xe1,
  0x1f,
  0xe0,
  0xe7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xd7,
  0x7f,
  0x2b,
  0xe1,
  0x5f,
  0xaa,
  0xff,
  0xf7,
  0xdb,
  0x3a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xfb,
  0xbf,
  0x07,
  0x00,
  0xff,
  0xd7,
  0x7a,
  0x2c,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xdb,
  0xf7,
  0xff,
  0x3e,
  0xe0,
  0x1f,
  0x2b,
  0xfb,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xe6,
  0x58,
  0x06,
  0x00,
  0xff,
  0xd1,
  0x7f,
  0x28,
  0xe0,
  0x1f,
  0x6b,
  0xf1,
  0x67,
  0xd1,
  0x3a,
  0x00,
  0xa0,
  0x9f,
  0xcb,
  0xe7,
  0x46,
  0xa1,
  0x06,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x45,
  0xa1,
  0x06,
  0x00,
  0xf8,
  0xff,
  0xff,
  0x00,
  0xe1,
  0x9d,
  0x0b,
  0xf9,
  0xfe,
  0xff,
  0xff,
  0x00,
  0xe1,
  0xcf,
  0x43,
  0xd7,
  0xff,
  0xbf,
  0x07,
  0x00,
  0x2b,
  0xce,
  0x38,
  0x00,
  0xa0,
  0x1f,
  0xc0,
  0xe7,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x97,
  0x5b,
  0x02,
  0x00,
  0x57,
  0xdc,
  0x38,
  0x00,
  0xc0,
  0xdf,
  0xdb,
  0xeb,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0x9b,
  0x5b,
  0x06,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0x81,
  0x7f,
  0x00,
  0xe1,
  0x1f,
  0xc0,
  0xbf,
  0xff,
  0xbf,
  0x07,
  0x00,
  0xbc,
  0xa8,
  0x3e,
  0x11,
  0x69,
  0xce,
  0x06,
  0x3f,
  0xb9,
  0x87,
  0xd7,
  0xdd,
  0xc6,
  0x12,
  0xb6,
  0xe2,
  0xc2,
  0x53,
  0x20,
  0xfb,
  0xea,
  0x71,
  0x72,
  0xb5,
  0xe1,
  0xa6,
  0xd8,
  0xee,
  0x9d,
  0x97,
  0xe6,
  0x72,
  0x3f,
  0x73,
  0x88,
  0xed,
  0x14,
  0x8c,
  0xdf,
  0x5d,
  0x8f,
  0x0d,
  0xd0,
  0x70,
  0x64,
  0x1c,
  0x06,
  0x7f,
  0x59,
  0x93,
  0x32,
  0x55,
  0x2a,
  0x10,
  0x61,
  0xde,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
};

/*----------------------------------------------------------------------------------------
 *           P R O T O T Y P E S     O F     L O C A L     F U N C T I O N S
 *----------------------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------------------
 *                          E X P O R T E D    F U N C T I O N S
 *----------------------------------------------------------------------------------------
 */
