/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2011 Advanced Micro Devices, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* ACPI code for SuperIO functions */
#define NO_W83627HF_FDC
#define NO_W83627HF_PPORT
#define NO_W83627HF_UARTB
#define NO_W83627HF_IRDA
#define NO_W83627HF_GAME
#define NO_W83627HF_MIDI
#define NO_W83627HF_HWMON

// Windows 8 not accepting this, just paste in PS/2 kb/mouse support for now
//#include <superio/winbond/w83627hf/acpi/superio.asl>

/* PS/2 Keyboard */
Device(KBC) {
	Name(_HID, EISAID("PNP0303"))
	Name(_CRS, ResourceTemplate() {
		IO(Decode16, 0x0060, 0x0060, 1, 1)
		IO(Decode16, 0x0064, 0x0064, 1, 1)
		IRQNoFlags(){1}
	})
}

/* PS/2 Mouse */
Device(PS2M) {
	Name(_HID, EISAID("PNP0F13"))
	Name(_CRS, ResourceTemplate() {
		IRQNoFlags(){12}
	})
}


	Device (UAR1)
	{
		Name(_HID, EISAID("PNP0501"))
		Name(_UID, 1)
		Name(_DDN, "COM1")

		Method (_STA, 0)
		{
			// always enable for now
			Return (0x0f)
		}

		Method (_DIS, 0) { /* NOOP */ }

		Name (_PRS, ResourceTemplate() {
			StartDependentFn(0, 1) {
				IO(Decode16, 0x3f8, 0x3f8, 0x8, 0x8)
				IRQNoFlags() { 4 }
			} EndDependentFn()
		})

		Method (_CRS, 0)
		{
			Return(ResourceTemplate() {
				IO(Decode16, 0x3f8, 0x3f8, 0x8, 0x8)
				IRQNoFlags() { 4 }
			})
		}
		// Some methods need an implementation here:
		// missing: _STA, _DIS, _CRS, _PRS,
		// missing: _SRS, _PS0, _PS3
	}
