/* $NoKeywords:$ */
/**
 * @file
 *
 * AMD F15Or Microcode patch.
 *
 * F15Or Microcode Patch rev 0600050D for 6011 or equivalent.
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project:      AGESA
 * @e sub-project:  CPU/Family/0x15/OR
 * @e \$Revision: 55872 $   @e \$Date: 2011-07-01 09:09:22 -0600 (Fri, 01 Jul 2011) $
 */
/*****************************************************************************
 *
 * Copyright (C) 2012 Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 ***************************************************************************/



/*----------------------------------------------------------------------------------------
 *                             M O D U L E S    U S E D
 *----------------------------------------------------------------------------------------
 */
#include "AGESA.h"
#include "Ids.h"
#include "cpuRegisters.h"
#include "cpuEarlyInit.h"
CODE_GROUP (G3_DXE)
RDATA_GROUP (G3_DXE)

/*----------------------------------------------------------------------------------------
 *                   D E F I N I T I O N S    A N D    M A C R O S
 *----------------------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------------------
 *                  T Y P E D E F S     A N D     S T R U C T U R E S
 *----------------------------------------------------------------------------------------
 */

UCODE_VS_FLAG (0600050D_Enc)

// Encrypt Patch code 0600050D for 6011 and equivalent

CONST UINT8 ROMDATA CpuF15OrMicrocodePatch0600050D_Enc [IDS_PAD_4K] =
{
  0x11,
  0x20,
  0x27,
  0x06,
  0x0d,
  0x05,
  0x00,
  0x06,
  0x02,
  0x80,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x11,
  0x60,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x5b,
  0x94,
  0xa0,
  0x0d,
  0x78,
  0xaf,
  0xb3,
  0xa7,
  0x4b,
  0xbb,
  0x6b,
  0x18,
  0x7e,
  0xe0,
  0x91,
  0x2a,
  0x6e,
  0xb5,
  0x40,
  0x6e,
  0x39,
  0x62,
  0x3b,
  0x83,
  0xe9,
  0x47,
  0x50,
  0xba,
  0xb5,
  0x7d,
  0x40,
  0x26,
  0xf6,
  0x46,
  0xbc,
  0x45,
  0x3d,
  0xd6,
  0xa3,
  0xa8,
  0x94,
  0x33,
  0xb9,
  0xd3,
  0xa0,
  0xb5,
  0x50,
  0xe2,
  0x6d,
  0x90,
  0x1e,
  0xc9,
  0x30,
  0x91,
  0x70,
  0x3d,
  0xef,
  0x48,
  0xc1,
  0xc5,
  0x21,
  0x73,
  0x94,
  0x26,
  0xce,
  0x40,
  0xb6,
  0x24,
  0x2c,
  0x33,
  0xf9,
  0x64,
  0x2f,
  0xf7,
  0x6f,
  0xf0,
  0x38,
  0x02,
  0x2e,
  0x4d,
  0xfd,
  0x82,
  0x64,
  0x50,
  0x6d,
  0xf0,
  0xb5,
  0xed,
  0xff,
  0xb1,
  0xb9,
  0x8a,
  0xbc,
  0xab,
  0xf9,
  0x2c,
  0x9c,
  0x99,
  0x36,
  0x79,
  0x07,
  0x80,
  0xf8,
  0xa7,
  0x68,
  0xdd,
  0x06,
  0xbe,
  0xd7,
  0xa3,
  0xe0,
  0x74,
  0x25,
  0x9f,
  0xe5,
  0x9d,
  0xff,
  0xee,
  0x08,
  0x44,
  0x78,
  0x16,
  0x3f,
  0xbe,
  0xa9,
  0xf2,
  0xb1,
  0xd1,
  0x01,
  0x20,
  0x8f,
  0xa7,
  0x82,
  0x75,
  0x96,
  0xed,
  0xbe,
  0x6f,
  0xf4,
  0x76,
  0x4b,
  0xc5,
  0x87,
  0x72,
  0xde,
  0x21,
  0x9f,
  0x6c,
  0xa3,
  0x9f,
  0x37,
  0x9a,
  0xf0,
  0xbb,
  0x6c,
  0x9b,
  0xeb,
  0x9d,
  0xeb,
  0xf9,
  0xe2,
  0x40,
  0x1f,
  0x3b,
  0x7f,
  0x8a,
  0x96,
  0x58,
  0x1f,
  0x80,
  0x75,
  0x19,
  0xb1,
  0xdb,
  0xcc,
  0xbe,
  0x6b,
  0x03,
  0x21,
  0xf3,
  0x30,
  0x50,
  0xe7,
  0x39,
  0x59,
  0x9a,
  0xf5,
  0x58,
  0x6b,
  0x02,
  0xac,
  0x96,
  0xbc,
  0x0e,
  0x79,
  0x99,
  0x6c,
  0xda,
  0x46,
  0xcf,
  0x47,
  0xb4,
  0x54,
  0x7d,
  0x83,
  0x95,
  0x6e,
  0x2d,
  0x76,
  0x44,
  0x59,
  0x1e,
  0x86,
  0x08,
  0xcb,
  0x82,
  0x4d,
  0x83,
  0x85,
  0x24,
  0xe5,
  0x05,
  0x3b,
  0x31,
  0x3d,
  0x19,
  0x10,
  0x49,
  0xb9,
  0xa0,
  0xd2,
  0x97,
  0x46,
  0x19,
  0x2b,
  0xc7,
  0x3f,
  0x01,
  0xda,
  0x36,
  0x5c,
  0x50,
  0xc6,
  0xc5,
  0x75,
  0x2d,
  0x1b,
  0x67,
  0x87,
  0x37,
  0xae,
  0x97,
  0x69,
  0xea,
  0x0b,
  0x03,
  0x3e,
  0x98,
  0x93,
  0x94,
  0xa7,
  0x56,
  0x26,
  0x1b,
  0x1f,
  0xb2,
  0x41,
  0x02,
  0x6d,
  0xd5,
  0xcb,
  0xac,
  0x73,
  0x2f,
  0xcb,
  0xf9,
  0x49,
  0xbb,
  0xa6,
  0x65,
  0x6b,
  0x97,
  0x2c,
  0xd6,
  0x71,
  0xd8,
  0xeb,
  0xbb,
  0x77,
  0x7f,
  0xfe,
  0x7c,
  0xc9,
  0x95,
  0xbd,
  0xe0,
  0x0d,
  0x7c,
  0xea,
  0x13,
  0x8d,
  0xb4,
  0xbd,
  0x9f,
  0xa6,
  0x70,
  0x9a,
  0x72,
  0x67,
  0x21,
  0xe5,
  0xf5,
  0xb9,
  0x92,
  0x18,
  0xe6,
  0xd2,
  0x48,
  0xfb,
  0x9b,
  0xae,
  0xd9,
  0x2b,
  0x78,
  0x42,
  0xff,
  0x84,
  0x51,
  0x89,
  0x5c,
  0xab,
  0x46,
  0x8c,
  0x77,
  0x11,
  0x45,
  0x43,
  0x7d,
  0x17,
  0x2c,
  0x10,
  0xf6,
  0x81,
  0x28,
  0x1b,
  0xc4,
  0x4b,
  0x21,
  0xe1,
  0x75,
  0x22,
  0x80,
  0x74,
  0xe7,
  0x2b,
  0x7b,
  0x09,
  0xf6,
  0x64,
  0x05,
  0x24,
  0x87,
  0x4a,
  0xe5,
  0xa5,
  0x94,
  0x96,
  0x1d,
  0x16,
  0x2d,
  0xec,
  0x07,
  0x55,
  0x5e,
  0x0c,
  0xd5,
  0x89,
  0xb1,
  0xd5,
  0x85,
  0xe9,
  0x9d,
  0x85,
  0x68,
  0x3a,
  0x9d,
  0xc0,
  0x30,
  0xc0,
  0xcf,
  0x44,
  0xe0,
  0x3a,
  0x7f,
  0x4c,
  0xc7,
  0x9c,
  0x3e,
  0x1a,
  0x0f,
  0xfc,
  0x3e,
  0x46,
  0xd3,
  0x88,
  0x93,
  0x83,
  0x39,
  0x8e,
  0x9a,
  0xd1,
  0xe3,
  0x98,
  0xfd,
  0x79,
  0xeb,
  0x3d,
  0xe4,
  0x3f,
  0xc7,
  0x49,
  0xd9,
  0xec,
  0xe5,
  0x25,
  0x94,
  0xb0,
  0x46,
  0xaf,
  0x04,
  0x0b,
  0x66,
  0x9e,
  0x01,
  0x1c,
  0xe2,
  0xd9,
  0xf2,
  0xf6,
  0x77,
  0x97,
  0x5a,
  0xe2,
  0xba,
  0x40,
  0x82,
  0x33,
  0x6a,
  0x6f,
  0x92,
  0xae,
  0xa6,
  0x03,
  0xda,
  0xc2,
  0xc5,
  0x4c,
  0xfe,
  0x19,
  0x52,
  0xde,
  0xea,
  0x35,
  0xd9,
  0x46,
  0xd9,
  0x90,
  0xfe,
  0x72,
  0x9e,
  0xfd,
  0x22,
  0x9e,
  0x2b,
  0xca,
  0xa2,
  0x98,
  0x25,
  0x74,
  0x4b,
  0x84,
  0x2a,
  0xde,
  0xd6,
  0x2d,
  0x12,
  0xb0,
  0xba,
  0xd8,
  0xc5,
  0xe9,
  0x6e,
  0x24,
  0x1f,
  0x53,
  0xee,
  0x2a,
  0x26,
  0xe1,
  0x1f,
  0xd6,
  0x3d,
  0xcd,
  0xc9,
  0xd5,
  0xde,
  0xdc,
  0x7d,
  0x30,
  0x81,
  0xdc,
  0x3d,
  0x62,
  0x7a,
  0xa4,
  0x9c,
  0x52,
  0x2e,
  0xb7,
  0xfa,
  0x9c,
  0x9b,
  0x4d,
  0x32,
  0xb2,
  0xbd,
  0xdf,
  0x21,
  0xa0,
  0x0b,
  0x09,
  0x44,
  0xc5,
  0xea,
  0x7a,
  0xb2,
  0x3b,
  0x75,
  0x74,
  0x4c,
  0x5e,
  0x77,
  0x88,
  0xfe,
  0x68,
  0x9d,
  0x64,
  0x24,
  0x18,
  0x74,
  0x8d,
  0xf7,
  0x92,
  0xf6,
  0xd9,
  0x92,
  0x85,
  0xce,
  0x3f,
  0xf7,
  0x00,
  0xdc,
  0x2c,
  0x90,
  0xfc,
  0x4c,
  0xc0,
  0xf5,
  0xf3,
  0x75,
  0x55,
  0x94,
  0x33,
  0xd8,
  0xdc,
  0x3e,
  0x93,
  0x66,
  0xb7,
  0xee,
  0x64,
  0x29,
  0xb5,
  0xf8,
  0x50,
  0xbf,
  0x08,
  0xa0,
  0xfd,
  0x2c,
  0x12,
  0xa7,
  0x45,
  0xae,
  0x45,
  0xaf,
  0x26,
  0x88,
  0xe1,
  0x6b,
  0xa5,
  0x75,
  0xac,
  0xf0,
  0x61,
  0x6d,
  0x09,
  0x95,
  0xba,
  0xc4,
  0x12,
  0xfe,
  0x0d,
  0xf5,
  0x32,
  0xd4,
  0xde,
  0xa8,
  0x29,
  0x0d,
  0x69,
  0xda,
  0x37,
  0x0e,
  0x2d,
  0xdd,
  0x59,
  0xff,
  0x6b,
  0x42,
  0x76,
  0x11,
  0x9f,
  0x39,
  0x30,
  0x84,
  0xf5,
  0xb8,
  0xd7,
  0x02,
  0x82,
  0xf9,
  0x0b,
  0xcf,
  0x4e,
  0xb6,
  0x95,
  0x8f,
  0xab,
  0x21,
  0xe7,
  0x69,
  0x1d,
  0xbb,
  0x96,
  0x77,
  0xfd,
  0xc9,
  0x30,
  0x05,
  0xa8,
  0x8c,
  0x16,
  0xd8,
  0xf9,
  0xe3,
  0x75,
  0xe8,
  0x87,
  0x8e,
  0xfc,
  0x8e,
  0xe5,
  0x32,
  0x86,
  0x57,
  0x85,
  0x64,
  0xfc,
  0x78,
  0xcd,
  0x24,
  0x32,
  0xe8,
  0xa4,
  0xd3,
  0x5f,
  0x87,
  0x5a,
  0x18,
  0xcf,
  0x4b,
  0x61,
  0x58,
  0x0d,
  0xde,
  0x2d,
  0xa3,
  0x36,
  0x46,
  0xd0,
  0x05,
  0x06,
  0x86,
  0x23,
  0xcf,
  0xb5,
  0x2b,
  0x12,
  0xb0,
  0x3b,
  0x92,
  0x36,
  0xbb,
  0x71,
  0xcf,
  0x05,
  0x9c,
  0x68,
  0xf8,
  0x17,
  0x2b,
  0x3c,
  0xb4,
  0x30,
  0xf1,
  0xad,
  0x21,
  0x05,
  0xf1,
  0x8f,
  0x09,
  0xbb,
  0x71,
  0x95,
  0xf8,
  0x5b,
  0x2e,
  0x78,
  0x02,
  0xdd,
  0xcf,
  0x20,
  0x01,
  0x45,
  0xf1,
  0xf0,
  0xc3,
  0x08,
  0x56,
  0xfe,
  0x00,
  0x3a,
  0x2f,
  0xc7,
  0xa1,
  0x92,
  0x37,
  0x47,
  0xf7,
  0x70,
  0xbb,
  0xc2,
  0x1f,
  0x4b,
  0x30,
  0x82,
  0xf1,
  0xa8,
  0x56,
  0x53,
  0x21,
  0x21,
  0x24,
  0xfb,
  0x57,
  0x13,
  0x92,
  0x2c,
  0x86,
  0x1f,
  0xdb,
  0x5d,
  0xa0,
  0x7c,
  0xb2,
  0xc4,
  0xea,
  0x38,
  0xed,
  0xe6,
  0x10,
  0xf4,
  0x8a,
  0xca,
  0xba,
  0x4e,
  0x99,
  0x3e,
  0x40,
  0x49,
  0x84,
  0xe5,
  0xc3,
  0xda,
  0x36,
  0xbd,
  0x5e,
  0xc6,
  0x40,
  0x6b,
  0x06,
  0x81,
  0x40,
  0xe7,
  0x3d,
  0x50,
  0x91,
  0x5a,
  0x7f,
  0x80,
  0x52,
  0xec,
  0x33,
  0xaf,
  0xb9,
  0xa2,
  0x57,
  0x3d,
  0xe6,
  0x00,
  0xc2,
  0x58,
  0x16,
  0xcb,
  0xdd,
  0xe4,
  0xbc,
  0xe6,
  0xbf,
  0x1c,
  0x26,
  0x33,
  0xec,
  0xa3,
  0x3b,
  0x25,
  0xee,
  0x80,
  0xf3,
  0xd2,
  0x65,
  0x72,
  0x12,
  0xe7,
  0x2b,
  0xbc,
  0xa6,
  0x05,
  0x0f,
  0x72,
  0x42,
  0xca,
  0xe0,
  0xe7,
  0x81,
  0xde,
  0x05,
  0x2f,
  0x1f,
  0x2b,
  0xcc,
  0xe5,
  0xc1,
  0x62,
  0x5e,
  0x24,
  0x92,
  0x94,
  0x4a,
  0x99,
  0x7a,
  0x21,
  0x8a,
  0x2f,
  0xa3,
  0x48,
  0x5b,
  0xa8,
  0xa1,
  0x95,
  0x5c,
  0x5c,
  0xe5,
  0x74,
  0x78,
  0xdd,
  0x05,
  0xf4,
  0x46,
  0x44,
  0x0c,
  0xcb,
  0x2f,
  0xf5,
  0xc6,
  0xb3,
  0x3f,
  0x1e,
  0x8e,
  0xc9,
  0x34,
  0xe2,
  0xa7,
  0x31,
  0xa1,
  0x08,
  0x44,
  0x86,
  0x01,
  0xfc,
  0x46,
  0xb9,
  0x44,
  0x86,
  0xc2,
  0x10,
  0x31,
  0xcc,
  0x28,
  0x55,
  0x9e,
  0xad,
  0xe3,
  0x0d,
  0x0e,
  0x05,
  0xa0,
  0x2b,
  0x27,
  0x77,
  0x8e,
  0x0f,
  0xd2,
  0x71,
  0xfc,
  0x0a,
  0x5e,
  0x06,
  0x37,
  0x3f,
  0x2c,
  0xa5,
  0x77,
  0xc6,
  0x24,
  0x10,
  0xfe,
  0xbb,
  0x70,
  0xbd,
  0xe4,
  0xb8,
  0xf4,
  0x1b,
  0x2b,
  0x5a,
  0xcf,
  0x69,
  0xbb,
  0xb5,
  0x26,
  0x69,
  0x0c,
  0xc2,
  0x70,
  0x3f,
  0xef,
  0xe9,
  0x83,
  0x86,
  0x8c,
  0x85,
  0xa3,
  0x0d,
  0xa1,
  0xdf,
  0x58,
  0x19,
  0x86,
  0xcd,
  0xc0,
  0xc4,
  0x84,
  0xca,
  0x6f,
  0x77,
  0x54,
  0x69,
  0x92,
  0xf7,
  0xe9,
  0x48,
  0x63,
  0xb9,
  0x3d,
  0x96,
  0x7a,
  0x42,
  0x4b,
  0x4a,
  0xf3,
  0x3e,
  0x2a,
  0xa9,
  0x62,
  0x25,
  0x42,
  0x35,
  0xbe,
  0xde,
  0xa1,
  0x34,
  0x9b,
  0x94,
  0xdd,
  0xf8,
  0x18,
  0x4d,
  0x04,
  0x9a,
  0x27,
  0xf2,
  0xc7,
  0x41,
  0xa3,
  0x09,
  0x9e,
  0x16,
  0xe3,
  0x02,
  0xdb,
  0x81,
  0xfb,
  0xd2,
  0x88,
  0xf6,
  0xaf,
  0x95,
  0x19,
  0xfa,
  0x52,
  0x6a,
  0xdc,
  0x36,
  0xdd,
  0xc7,
  0xb7,
  0xae,
  0xe8,
  0xb6,
  0x94,
  0x86,
  0x5d,
  0x4e,
  0xcd,
  0x82,
  0x87,
  0xa1,
  0x58,
  0x75,
  0x3c,
  0x73,
  0x82,
  0xbe,
  0x94,
  0xba,
  0xa4,
  0xc7,
  0x92,
  0xfc,
  0xa5,
  0x3b,
  0x78,
  0x17,
  0xf5,
  0x67,
  0x5e,
  0x97,
  0xbe,
  0x7c,
  0x28,
  0xac,
  0x50,
  0x25,
  0xe3,
  0xf6,
  0x75,
  0x5e,
  0x1a,
  0xef,
  0xd3,
  0xba,
  0x39,
  0x03,
  0xe6,
  0xb9,
  0x62,
  0x8e,
  0x6f,
  0xdf,
  0xa7,
  0x8d,
  0x5c,
  0xbf,
  0xd3,
  0x7b,
  0x88,
  0x7f,
  0xcf,
  0x93,
  0x26,
  0xa4,
  0xee,
  0xac,
  0x5a,
  0xa6,
  0x44,
  0x4c,
  0xbb,
  0x90,
  0x9f,
  0xc6,
  0xa9,
  0x2b,
  0x05,
  0x91,
  0xe5,
  0xbe,
  0xd3,
  0xc3,
  0xa2,
  0x13,
  0x70,
  0xd5,
  0x46,
  0x3b,
  0x7f,
  0xf1,
  0xfa,
  0x50,
  0x6c,
  0xec,
  0x35,
  0xfc,
  0xfb,
  0x69,
  0x0e,
  0x86,
  0x04,
  0xb6,
  0xb1,
  0x1e,
  0x58,
  0x63,
  0x35,
  0x8e,
  0x14,
  0x37,
  0xae,
  0x2c,
  0x2d,
  0xcd,
  0x89,
  0x0d,
  0x45,
  0xbd,
  0x58,
  0xa9,
  0xfd,
  0x60,
  0x1d,
  0x4c,
  0xab,
  0x60,
  0xff,
  0x25,
  0x6a,
  0xd0,
  0xd3,
  0x54,
  0x54,
  0xd3,
  0x36,
  0xd5,
  0x80,
  0x34,
  0x64,
  0xf5,
  0x58,
  0x14,
  0xe8,
  0x89,
  0xbe,
  0xd4,
  0xe9,
  0x90,
  0x72,
  0xdc,
  0x25,
  0x66,
  0x89,
  0x7a,
  0xc3,
  0xcd,
  0xd6,
  0x88,
  0xac,
  0xb8,
  0xbb,
  0x54,
  0xf0,
  0x7e,
  0x4d,
  0x75,
  0xfe,
  0x19,
  0x8d,
  0x51,
  0xae,
  0x00,
  0x8a,
  0x43,
  0x00,
  0x92,
  0x0d,
  0xd0,
  0x15,
  0x47,
  0xef,
  0x61,
  0x3e,
  0x68,
  0xd3,
  0xa7,
  0xea,
  0x69,
  0x91,
  0xc4,
  0xf8,
  0x74,
  0x41,
  0xdd,
  0xcc,
  0x2d,
  0x5c,
  0x27,
  0x58,
  0x27,
  0x45,
  0xa8,
  0xd9,
  0xfd,
  0x21,
  0x73,
  0x4e,
  0xea,
  0xc6,
  0x9d,
  0x47,
  0x4d,
  0x44,
  0x78,
  0xfb,
  0x40,
  0x29,
  0x3e,
  0x65,
  0xde,
  0x9b,
  0x40,
  0x3b,
  0xc5,
  0x38,
  0x23,
  0x85,
  0x97,
  0x09,
  0xe8,
  0xd7,
  0x7f,
  0x9e,
  0x5c,
  0xb1,
  0x17,
  0xa8,
  0xaf,
  0xc6,
  0x48,
  0x53,
  0x4f,
  0x8a,
  0x7f,
  0xdc,
  0xe8,
  0x5e,
  0x03,
  0xd6,
  0x9c,
  0x04,
  0xb2,
  0x4f,
  0x3a,
  0x6a,
  0x08,
  0xf3,
  0x3a,
  0xb9,
  0xa4,
  0x6b,
  0x8b,
  0xe1,
  0x5b,
  0x3f,
  0xb4,
  0x14,
  0x10,
  0xdb,
  0x11,
  0xbf,
  0x21,
  0xfc,
  0xd7,
  0xc4,
  0x02,
  0x95,
  0x84,
  0x7d,
  0xab,
  0xce,
  0x6f,
  0x5d,
  0xc3,
  0xb4,
  0xcf,
  0x27,
  0x1b,
  0xca,
  0xc6,
  0xa1,
  0x60,
  0x19,
  0x75,
  0x17,
  0x48,
  0x9b,
  0x25,
  0x6f,
  0x2a,
  0xbb,
  0x12,
  0x51,
  0xc7,
  0xdd,
  0xfa,
  0xba,
  0xe7,
  0x12,
  0x54,
  0xdd,
  0xed,
  0x1c,
  0xd2,
  0x10,
  0xab,
  0x79,
  0xe3,
  0xc6,
  0xaf,
  0x42,
  0xf1,
  0x67,
  0xea,
  0xe7,
  0x6b,
  0x52,
  0xe9,
  0xf4,
  0xa2,
  0xdb,
  0xe1,
  0xe8,
  0x3b,
  0x6e,
  0x0c,
  0xf7,
  0x05,
  0x24,
  0xe4,
  0x97,
  0x54,
  0x39,
  0x38,
  0x79,
  0x65,
  0x8b,
  0xb4,
  0x8b,
  0x01,
  0x16,
  0x6e,
  0x9b,
  0xa2,
  0x6d,
  0xde,
  0xb6,
  0x09,
  0x69,
  0xc5,
  0xf5,
  0xe1,
  0x92,
  0x29,
  0x29,
  0x36,
  0xa7,
  0x1e,
  0x53,
  0x62,
  0xda,
  0x25,
  0x93,
  0x55,
  0x6d,
  0x92,
  0x50,
  0x5b,
  0x55,
  0x6b,
  0x57,
  0xa0,
  0x3d,
  0x61,
  0x2d,
  0x09,
  0x41,
  0x3e,
  0xe7,
  0x1c,
  0x51,
  0x29,
  0x80,
  0x8b,
  0x60,
  0x6c,
  0x63,
  0x73,
  0x5c,
  0x36,
  0x63,
  0xee,
  0xe8,
  0x5a,
  0x30,
  0x01,
  0xec,
  0x7f,
  0xda,
  0x0d,
  0x26,
  0x78,
  0x90,
  0x46,
  0x11,
  0x45,
  0xc1,
  0x61,
  0x33,
  0xe7,
  0xd2,
  0x91,
  0x40,
  0x5f,
  0xdb,
  0xe4,
  0xb4,
  0x32,
  0xb7,
  0x33,
  0xdd,
  0xcf,
  0x06,
  0x23,
  0x10,
  0x1e,
  0xa8,
  0x17,
  0x78,
  0x6f,
  0x93,
  0x9b,
  0xb2,
  0x56,
  0x91,
  0x00,
  0xd4,
  0xf9,
  0x57,
  0x5d,
  0xf3,
  0xd2,
  0x69,
  0x3a,
  0x01,
  0x80,
  0x9d,
  0xca,
  0x61,
  0x98,
  0x31,
  0x24,
  0xfc,
  0x12,
  0x5b,
  0x50,
  0x1e,
  0x2b,
  0x00,
  0xa0,
  0x78,
  0x2f,
  0x60,
  0x7d,
  0xff,
  0x00,
  0x04,
  0x91,
  0x15,
  0xcc,
  0xea,
  0xc0,
  0xb0,
  0x22,
  0xa5,
  0xbc,
  0x76,
  0xcf,
  0x32,
  0xaf,
  0x83,
  0x84,
  0x38,
  0x72,
  0x9e,
  0xa8,
  0xae,
  0x38,
  0xf1,
  0xbd,
  0x50,
  0x3a,
  0xaa,
  0x26,
  0x74,
  0x07,
  0x58,
  0x34,
  0xa1,
  0x08,
  0x6d,
  0x3d,
  0x03,
  0xcf,
  0x85,
  0xca,
  0x71,
  0x23,
  0x5c,
  0xf7,
  0x08,
  0xa8,
  0x77,
  0x0d,
  0x82,
  0x46,
  0x82,
  0xe5,
  0x4e,
  0xd2,
  0x42,
  0x4b,
  0xff,
  0x12,
  0x2a,
  0x9f,
  0x84,
  0xa9,
  0xa2,
  0xda,
  0x08,
  0x63,
  0xb3,
  0xfd,
  0xb8,
  0x07,
  0x68,
  0x6e,
  0x2f,
  0x72,
  0x5a,
  0xec,
  0x0c,
  0x4e,
  0xd6,
  0xc5,
  0xa0,
  0x7d,
  0x5a,
  0xa7,
  0x25,
  0xe0,
  0x41,
  0xb7,
  0x83,
  0xd7,
  0xa9,
  0x0e,
  0xb9,
  0x20,
  0x48,
  0xee,
  0x59,
  0xb4,
  0xea,
  0x81,
  0xd8,
  0x80,
  0x2a,
  0x33,
  0xc2,
  0xb3,
  0xee,
  0x6b,
  0x32,
  0x4c,
  0x67,
  0x2f,
  0xde,
  0x4f,
  0xf2,
  0xa7,
  0xf6,
  0x86,
  0xd9,
  0xbe,
  0x8f,
  0x30,
  0x5e,
  0x44,
  0x7c,
  0x81,
  0x9d,
  0x55,
  0xb2,
  0xbe,
  0xb9,
  0xa6,
  0x12,
  0x0f,
  0xa6,
  0xd4,
  0xae,
  0xe9,
  0x8d,
  0x70,
  0x6d,
  0x71,
  0xb2,
  0xb8,
  0x62,
  0x52,
  0x3c,
  0xda,
  0x6c,
  0x1f,
  0xf0,
  0xc6,
  0x96,
  0x99,
  0x00,
  0x93,
  0x74,
  0x62,
  0xc0,
  0xc9,
  0x75,
  0x9f,
  0x8d,
  0x1a,
  0x6c,
  0x0f,
  0x60,
  0x97,
  0x62,
  0x9f,
  0x21,
  0xb0,
  0x32,
  0x6d,
  0x02,
  0x94,
  0x8d,
  0x7d,
  0x37,
  0x85,
  0xce,
  0x51,
  0xba,
  0x09,
  0xf9,
  0xe8,
  0x05,
  0xed,
  0xeb,
  0xab,
  0xe9,
  0x43,
  0x19,
  0x49,
  0x92,
  0x47,
  0xfa,
  0xfc,
  0xcc,
  0xe8,
  0xc7,
  0xf1,
  0x00,
  0xdf,
  0x4f,
  0xb7,
  0x20,
  0x93,
  0x3a,
  0xe1,
  0x48,
  0x01,
  0x0e,
  0x22,
  0xcb,
  0x84,
  0x6b,
  0x41,
  0x47,
  0xa7,
  0x56,
  0x5d,
  0x2b,
  0xfa,
  0x40,
  0x9a,
  0x5a,
  0x49,
  0x8e,
  0x3c,
  0xda,
  0x01,
  0xf5,
  0x85,
  0x70,
  0x27,
  0x6d,
  0xcb,
  0x3b,
  0x6e,
  0x8a,
  0x11,
  0xc8,
  0x11,
  0x50,
  0x1e,
  0xe3,
  0x92,
  0x8c,
  0x95,
  0xb9,
  0xc0,
  0xcf,
  0x78,
  0x76,
  0xa3,
  0xbd,
  0x1d,
  0x12,
  0xf6,
  0x42,
  0x9c,
  0xac,
  0xe2,
  0x26,
  0x46,
  0xf2,
  0x0b,
  0xeb,
  0x11,
  0xfd,
  0xd5,
  0x16,
  0x04,
  0x37,
  0x10,
  0xf4,
  0xbf,
  0xca,
  0xa7,
  0xad,
  0xa1,
  0x82,
  0x3e,
  0xfb,
  0xf2,
  0x5b,
  0xfc,
  0xfd,
  0x96,
  0x57,
  0x15,
  0x90,
  0x6b,
  0xc2,
  0x84,
  0xc0,
  0x98,
  0x37,
  0xaf,
  0xa2,
  0x32,
  0x3a,
  0x05,
  0x1d,
  0xab,
  0x6d,
  0x2e,
  0xe5,
  0xda,
  0xd7,
  0x10,
  0xfe,
  0x1b,
  0x36,
  0xdd,
  0x91,
  0xdb,
  0x90,
  0xff,
  0x0c,
  0x1f,
  0x85,
  0x62,
  0xb7,
  0xe5,
  0x0a,
  0x14,
  0x99,
  0x60,
  0x92,
  0x5b,
  0xc1,
  0x03,
  0xfc,
  0x2a,
  0x3f,
  0x57,
  0x1a,
  0x6d,
  0xe3,
  0x51,
  0x96,
  0x71,
  0x73,
  0xeb,
  0x42,
  0x66,
  0x30,
  0x99,
  0x3f,
  0x2f,
  0x0e,
  0xe1,
  0xb5,
  0x16,
  0x1d,
  0x3e,
  0x8e,
  0x58,
  0xc5,
  0xf3,
  0xc3,
  0x22,
  0xf2,
  0xfe,
  0x9e,
  0x51,
  0x34,
  0xe1,
  0x51,
  0xc3,
  0x66,
  0x0f,
  0x72,
  0xfc,
  0x41,
  0x30,
  0x47,
  0xa0,
  0xd2,
  0xaf,
  0x1c,
  0x1b,
  0x3e,
  0xc3,
  0x92,
  0x57,
  0x03,
  0x5d,
  0xf6,
  0x71,
  0x94,
  0xdf,
  0xfb,
  0x6c,
  0xd8,
  0x34,
  0xc9,
  0x44,
  0x1f,
  0xa3,
  0xfc,
  0x16,
  0x4e,
  0x78,
  0xb6,
  0xab,
  0x32,
  0x15,
  0x0e,
  0xd0,
  0xfa,
  0x85,
  0xc6,
  0x42,
  0xf9,
  0x83,
  0x1a,
  0xc1,
  0x4d,
  0xd7,
  0x25,
  0x4c,
  0x3c,
  0x48,
  0x52,
  0xa0,
  0x4e,
  0xd3,
  0x7e,
  0x2f,
  0x22,
  0x94,
  0x07,
  0xfb,
  0x61,
  0x04,
  0x7f,
  0x7c,
  0xc6,
  0x66,
  0x2d,
  0x0a,
  0xb4,
  0x93,
  0xf1,
  0xe3,
  0xb3,
  0x23,
  0x77,
  0x06,
  0xaa,
  0x3d,
  0x82,
  0xec,
  0x4d,
  0xdd,
  0x18,
  0xf7,
  0x26,
  0xc2,
  0xf0,
  0x7b,
  0x4e,
  0xb8,
  0x0a,
  0x4e,
  0x09,
  0xec,
  0x1d,
  0x38,
  0xcb,
  0xaf,
  0xef,
  0xda,
  0xda,
  0x9b,
  0x17,
  0x39,
  0xca,
  0x07,
  0xc4,
  0xeb,
  0xfd,
  0xba,
  0x0d,
  0x10,
  0xae,
  0x6b,
  0x8b,
  0xde,
  0xf2,
  0xda,
  0xde,
  0x5f,
  0xd6,
  0xff,
  0x79,
  0xec,
  0x60,
  0xdd,
  0x8f,
  0x7b,
  0x53,
  0xb4,
  0xe2,
  0x98,
  0xcf,
  0xdf,
  0xa2,
  0x3e,
  0xef,
  0x81,
  0x10,
  0xf0,
  0xf9,
  0xa4,
  0x17,
  0x82,
  0xb6,
  0x27,
  0xc7,
  0xcf,
  0x6f,
  0x0a,
  0x81,
  0xef,
  0x38,
  0xd3,
  0xd8,
  0x9e,
  0x38,
  0xdf,
  0xcc,
  0x73,
  0xec,
  0x0b,
  0xdc,
  0x4e,
  0xe1,
  0x4c,
  0x8b,
  0x8d,
  0x9a,
  0x75,
  0x79,
  0x47,
  0x00,
  0xd4,
  0x1c,
  0x05,
  0xd1,
  0x82,
  0xea,
  0xc1,
  0x49,
  0x65,
  0xf5,
  0x38,
  0xc6,
  0x07,
  0x49,
  0xda,
  0x2a,
  0x1d,
  0xe3,
  0x8e,
  0xba,
  0x4d,
  0xc5,
  0x9e,
  0x2a,
  0x9f,
  0x2c,
  0xc1,
  0x3f,
  0x95,
  0x4e,
  0xc5,
  0x72,
  0x77,
  0x1b,
  0x10,
  0x13,
  0xb0,
  0xbc,
  0x2c,
  0x0f,
  0xbb,
  0xd4,
  0x50,
  0x83,
  0x76,
  0xa4,
  0xb9,
  0x9c,
  0xe9,
  0x73,
  0x61,
  0xc8,
  0x41,
  0xf6,
  0x52,
  0xa5,
  0x7b,
  0xaf,
  0x5c,
  0x83,
  0x23,
  0x3b,
  0xc8,
  0x22,
  0x6a,
  0x4c,
  0x24,
  0xb3,
  0x91,
  0x1c,
  0x86,
  0xe3,
  0x63,
  0xa1,
  0xc7,
  0xb3,
  0x1d,
  0x8f,
  0xf7,
  0x75,
  0x70,
  0xaf,
  0x41,
  0x75,
  0x1f,
  0xf4,
  0x31,
  0xc7,
  0x7b,
  0xef,
  0x02,
  0x78,
  0x0e,
  0x40,
  0x7d,
  0xb5,
  0x37,
  0x5a,
  0x5f,
  0xcb,
  0x18,
  0x3f,
  0xb2,
  0x93,
  0xdd,
  0x1b,
  0xd4,
  0xe4,
  0x4f,
  0xd9,
  0xa8,
  0xa4,
  0x20,
  0x64,
  0xd1,
  0xc8,
  0x12,
  0x61,
  0xd4,
  0x97,
  0xae,
  0x10,
  0x94,
  0xdc,
  0x39,
  0x30,
  0xf0,
  0x60,
  0x61,
  0x91,
  0xd2,
  0xd4,
  0x0f,
  0x09,
  0xd1,
  0x65,
  0xc9,
  0xa9,
  0xc6,
  0xe9,
  0x50,
  0x0a,
  0x36,
  0xf0,
  0x37,
  0x2b,
  0xc7,
  0xf2,
  0xc2,
  0x21,
  0x8c,
  0x69,
  0xb6,
  0x67,
  0xb9,
  0x32,
  0x71,
  0x89,
  0x1e,
  0xe7,
  0xd8,
  0x02,
  0xde,
  0xb9,
  0x43,
  0x8f,
  0xec,
  0x7e,
  0x41,
  0x2a,
  0xb4,
  0xc5,
  0x05,
  0xa1,
  0x75,
  0x82,
  0x53,
  0x48,
  0x1c,
  0xed,
  0x17,
  0x35,
  0x74,
  0x61,
  0x59,
  0x0d,
  0x2f,
  0x19,
  0x4e,
  0x9a,
  0x28,
  0x9b,
  0x99,
  0x78,
  0xed,
  0xe6,
  0x36,
  0x35,
  0x74,
  0x75,
  0x21,
  0x5c,
  0x83,
  0x0a,
  0x8d,
  0x3f,
  0xbe,
  0xaf,
  0x5c,
  0x22,
  0x8e,
  0x8b,
  0x99,
  0x51,
  0x7b,
  0xde,
  0x6d,
  0x1a,
  0xbd,
  0xeb,
  0x79,
  0x48,
  0x76,
  0xdb,
  0x3f,
  0xbb,
  0x85,
  0x8a,
  0xb9,
  0xb0,
  0x23,
  0xb0,
  0x40,
  0x58,
  0x5e,
  0x6b,
  0x79,
  0xa1,
  0xb1,
  0x39,
  0x51,
  0x4b,
  0xbf,
  0x52,
  0x5b,
  0xc1,
  0xbe,
  0xba,
  0x1c,
  0xf7,
  0x84,
  0x39,
  0x29,
  0xd9,
  0x9a,
  0x0d,
  0x8f,
  0x6d,
  0x11,
  0xe2,
  0x66,
  0x88,
  0x2e,
  0xe0,
  0x6c,
  0x66,
  0x12,
  0xf1,
  0xd5,
  0x24,
  0x60,
  0xb4,
  0x26,
  0x4e,
  0xc4,
  0x01,
  0x77,
  0x77,
  0x5a,
  0x93,
  0x29,
  0x20,
  0xfe,
  0xe7,
  0x29,
  0xc5,
  0xcb,
  0x2d,
  0x51,
  0xac,
  0x10,
  0x61,
  0x7a,
  0xe4,
  0x4b,
  0xb6,
  0x84,
  0xc1,
  0x1d,
  0x3b,
  0x0a,
  0x82,
  0x9c,
  0x9d,
  0x24,
  0x8d,
  0x5e,
  0xc3,
  0x6e,
  0x05,
  0x16,
  0x74,
  0x2f,
  0x4c,
  0xa4,
  0xec,
  0x73,
  0x58,
  0x2e,
  0xb3,
  0xa7,
  0xaa,
  0xee,
  0xfd,
  0x5d,
  0xf9,
  0x0d,
  0x8f,
  0x16,
  0xf0,
  0x46,
  0x63,
  0x09,
  0xce,
  0x16,
  0x02,
  0xc8,
  0x62,
  0x44,
  0x46,
  0x92,
  0x57,
  0xea,
  0xe4,
  0x8c,
  0x3b,
  0x39,
  0xa9,
  0x5f,
  0xdb,
  0xf2,
  0x06,
  0x04,
  0x9c,
  0x5b,
  0xf7,
  0x46,
  0x2c,
  0xbb,
  0x03,
  0xd6,
  0x22,
  0x00,
  0xe6,
  0xd2,
  0x46,
  0x3a,
  0xc0,
  0x1c,
  0xdc,
  0x2c,
  0xaf,
  0x2d,
  0x15,
  0x19,
  0x0d,
  0xa6,
  0x99,
  0x4d,
  0x21,
  0x5b,
  0xe2,
  0x47,
  0x47,
  0xea,
  0xad,
  0x5d,
  0x02,
  0x8f,
  0x4c,
  0xd7,
  0x0e,
  0xb5,
  0xad,
  0xf3,
  0x93,
  0xb8,
  0x6e,
  0x52,
  0x9b,
  0x2b,
  0x4f,
  0xdc,
  0xff,
  0xd4,
  0xbb,
  0xa6,
  0xc6,
  0x37,
  0x37,
  0x9d,
  0x3d,
  0xd7,
  0x05,
  0xad,
  0xc0,
  0xca,
  0xea,
  0xae,
  0x7e,
  0x09,
  0x6c,
  0x82,
  0xab,
  0x7f,
  0x21,
  0xab,
  0xf0,
  0x33,
  0x87,
  0xd9,
  0x02,
  0xc0,
  0x04,
  0x30,
  0x2a,
  0x63,
  0xbe,
  0x70,
  0x8b,
  0x8a,
  0xb3,
  0x7d,
  0xb9,
  0x6c,
  0x02,
  0x2a,
  0x37,
  0xa9,
  0x65,
  0x53,
  0xd5,
  0x1b,
  0x09,
  0x09,
  0xc9,
  0xe1,
  0x3e,
  0x38,
  0xf2,
  0x17,
  0xba,
  0x99,
  0x65,
  0x61,
  0xb2,
  0xfd,
  0xbf,
  0xc4,
  0x25,
  0xf0,
  0x98,
  0xec,
  0xab,
  0xad,
  0x4d,
};

/*----------------------------------------------------------------------------------------
 *           P R O T O T Y P E S     O F     L O C A L     F U N C T I O N S
 *----------------------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------------------
 *                          E X P O R T E D    F U N C T I O N S
 *----------------------------------------------------------------------------------------
 */