/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2012 Google Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <stdint.h>
#include "i915io.h"

struct iodef iodefs[] = {
{V,0,},
{M, 1, "Linux agpgart interface v0.103", 0x0, 0x0, 0},
{M, 1, "agpgart-intel 0000:00:00.0:Intel 945GM Chipset", 0x0, 0x0, 0},
{M, 1, "agpgart-intel 0000:00:00.0:detected gtt size:262144K total, 262144K mappable", 0x0, 0x0, 0},
{M, 1, "agpgart-intel 0000:00:00.0:detected 8192K stolen memory", 0x0, 0x0, 0},
{M, 1, "agpgart-intel 0000:00:00.0:AGP aperture is 256M @ 0xd0000000", 0x0, 0x0, 0},
{M, 1, "[drm] Initialized drm 1.1.0 20060810", 0x0, 0x0, 0},
{M, 1, "[drm] radeon defaulting to kernel modesetting.", 0x0, 0x0, 0},
{M, 1, "[drm] radeon kernel modesetting enabled.", 0x0, 0x0, 0},
{M, 1, "i915 0000:00:02.0:setting latency timer to 64", 0x0, 0x0, 0},
{W, 1, "", 0x5100, 0x00000000, 0},
{R, 1, "", PP_ON_DELAYS, 0x00000000, 0},
{R, 1, "", PP_OFF_DELAYS, 0x00000000, 0},
{W, 1, "", PP_ON_DELAYS, 0x00000000, 0},
{W, 1, "", PP_OFF_DELAYS, 0x00000000, 0},
{W, 1, "", INSTPM+0x24,  MI_ARB_C3_LP_WRITE_ENABLE |0x08000800, 0},
{W, 1, "", RENDER_RING_BASE, 0x00000000, 0},
{W, 1, "", RENDER_RING_BASE+0x4, 0x00000000, 0},
{W, 1, "", RENDER_RING_BASE+0x8, 0x00000000, 0},
{W, 1, "", RENDER_RING_BASE+0xc, 0x00000000, 0},
{W, 1, "", RENDER_RING_BASE+0x10, 0x00000000, 0},
{W, 1, "", RENDER_RING_BASE+0x14, 0x00000000, 0},
{W, 1, "", RENDER_RING_BASE+0x18, 0x00000000, 0},
{W, 1, "", RENDER_RING_BASE+0x1c, 0x00000000, 0},
{W, 1, "", FENCE_REG_965_0, 0x00000000, 0},
{W, 1, "", FENCE_REG_965_0+0x4, 0x00000000, 0},
{W, 1, "", FENCE_REG_965_0+0x8, 0x00000000, 0},
{W, 1, "", FENCE_REG_965_0+0xc, 0x00000000, 0},
{W, 1, "", FENCE_REG_965_0+0x10, 0x00000000, 0},
{W, 1, "", FENCE_REG_965_0+0x14, 0x00000000, 0},
{W, 1, "", FENCE_REG_965_0+0x18, 0x00000000, 0},
{W, 1, "", FENCE_REG_965_0+0x1c, 0x00000000, 0},
{R, 1, "", DCC,  DCC_ADDRESSING_MODE_DUAL_CHANNEL_INTERLEAVED | DCC_CHANNEL_XOR_BIT_17 |0x000f0202, 0},
{M, 1, "[drm] Supports vblank timestamp caching Rev 1 (10.10.2010).", 0x0, 0x0, 0},
{M, 1, "[drm] Driver supports precise vblank timestamp query.", 0x0, 0x0, 0},
{M, 1, "i915 0000:00:02.0:Invalid ROM contents", 0x0, 0x0, 0},
{M, 1, "[drm] failed to find VBIOS tables", 0x0, 0x0, 0},
{M, 1, "vgaarb:device changed decodes:PCI:0000:00:02.0,olddecodes=io+mem,decodes=io+mem:owns=io+mem", 0x0, 0x0, 0},
{W, 1, "", VGACNTRL,  VGA_DISP_DISABLE |0x80000000, 0},
{R, 1, "", PFIT_CONTROL, 0x00000000, 0},
{W, 1, "", 0x5100, 0x00000003, 0},
{W, 1, "", 0x5104, 0x460100a1, 0},
{R, 1, "", 0x5108, 0x00004a00, 0},
{R, 1, "", 0x510c, 0x00000000, 0},
{R, 1, "", 0x5108, 0x0000c200, 0},
{W, 1, "", 0x5104, 0x48000000, 0},
{R, 1, "", 0x5108, 0x00008800, 0},
{W, 1, "", 0x5100, 0x00000000, 0},
{W, 1, "", 0x5100, 0x00000003, 0},
{W, 1, "", 0x5104, 0x468000a1, 0},
{R, 1, "", 0x5108, 0x00008a08, 0},
{R, 1, "", 0x510c, 0xffffff00, 0},
{R, 1, "", 0x5108, 0x00008a0c, 0},
{R, 1, "", 0x510c, 0x00ffffff, 0},
{R, 1, "", 0x5108, 0x00008a10, 0},
{R, 1, "", 0x510c, 0x4000ae30, 0},
{R, 1, "", 0x5108, 0x00008a14, 0},
{R, 1, "", 0x510c, 0x00000000, 0},
{R, 1, "", 0x5108, 0x00008a18, 0},
{R, 1, "", 0x510c, 0x03010f00, 0},
{R, 1, "", 0x5108, 0x00008a1c, 0},
{R, 1, "", 0x510c, 0x78121980, 0},
{R, 1, "", 0x5108, 0x00008a20, 0},
{R, 1, "", 0x510c, 0x9175edea, 0},
{R, 1, "", 0x5108, 0x00008a24, 0},
{R, 1, "", 0x510c, 0x268b4f57, 0},
{R, 1, "", 0x5108, 0x00008a28, 0},
{R, 1, "", 0x510c, 0x21545021, 0},
{R, 1, "", 0x5108, 0x00008a2c, 0},
{R, 1, "", 0x510c, 0x01010008, 0},
{R, 1, "", 0x5108, 0x00008a30, 0},
{R, 1, "", 0x510c, 0x01010101, 0},
{R, 1, "", 0x5108, 0x00008a34, 0},
{R, 1, "", 0x510c, 0x01010101, 0},
{R, 1, "", 0x5108, 0x00008a38, 0},
{R, 1, "", 0x510c, 0x01010101, 0},
{R, 1, "", 0x5108, 0x00008a3c, 0},
{R, 1, "", 0x510c, 0x15280101, 0},
{R, 1, "", 0x5108, 0x00008a40, 0},
{R, 1, "", 0x510c, 0x00414000, 0},
{R, 1, "", 0x5108, 0x00008a44, 0},
{R, 1, "", 0x510c, 0x88183026, 0},
{R, 1, "", 0x5108, 0x00008a48, 0},
{R, 1, "", 0x510c, 0xb9f60036, 0},
{R, 1, "", 0x5108, 0x00008a4c, 0},
{R, 1, "", 0x510c, 0x18000000, 0},
{R, 1, "", 0x5108, 0x00008a50, 0},
{R, 1, "", 0x510c, 0x400010ed, 0},
{R, 1, "", 0x5108, 0x00008a54, 0},
{R, 1, "", 0x510c, 0x30260041, 0},
{R, 1, "", 0x5108, 0x00008a58, 0},
{R, 1, "", 0x510c, 0x00368818, 0},
{R, 1, "", 0x5108, 0x00008a5c, 0},
{R, 1, "", 0x510c, 0x0000b9f6, 0},
{R, 1, "", 0x5108, 0x00008a60, 0},
{R, 1, "", 0x510c, 0x00001800, 0},
{R, 1, "", 0x5108, 0x00008a64, 0},
{R, 1, "", 0x510c, 0x61000f00, 0},
{R, 1, "", 0x5108, 0x00008a68, 0},
{R, 1, "", 0x510c, 0x43613243, 0},
{R, 1, "", 0x5108, 0x00008a6c, 0},
{R, 1, "", 0x510c, 0x00010f28, 0},
{R, 1, "", 0x5108, 0x00008a70, 0},
{R, 1, "", 0x510c, 0x4a58a34c, 0},
{R, 1, "", 0x5108, 0x00008a74, 0},
{R, 1, "", 0x510c, 0xfe000000, 0},
{R, 1, "", 0x5108, 0x00008a78, 0},
{R, 1, "", 0x510c, 0x4e544c00, 0},
{R, 1, "", 0x5108, 0x00008a7c, 0},
{R, 1, "", 0x510c, 0x58313231, 0},
{R, 1, "", 0x5108, 0x0000ca00, 0},
{R, 1, "", 0x510c, 0x304c2d4a, 0},
{R, 1, "", 0x5108, 0x0000ca00, 0},
{R, 1, "", 0x510c, 0x00000a37, 0},
{R, 1, "", 0x5108, 0x0000c200, 0},
{W, 1, "", 0x5104, 0x48000000, 0},
{R, 1, "", 0x5108, 0x00008800, 0},
{W, 1, "", 0x5100, 0x00000000, 0},
{R, 1, "", PP_CONTROL, 0x00000000, 0},
{W, 1, "", PP_CONTROL, 0xabcd0000, 0},
{R, 2, "", BLC_PWM_CTL, 0x00000000, 0},
{R, 2, "", DVOB, 0x00300000, 0},
{R, 1, "", DVOC, 0x00300000, 0},
{R, 1, "", TV_CTL, 0x00000000, 0},
{R, 1, "", TV_DAC, 0x00000000, 0},
{W, 1, "", TV_DAC, 0x08000000, 0},
{R, 1, "", TV_DAC, 0x08000000, 0},
{W, 1, "", TV_DAC, 0x00000000, 0},
{R, 1, "", TV_DAC, 0x00000000, 0},
{W, 1, "", TV_DAC, 0x00000000, 0},
{M, 1, "tsc:Refined TSC clocksource calibration:1662.499 MHz", 0x0, 0x0, 0},
{W, 1, "", HWS_PGA, 0x352d2000, 0},
{W, 1, "", PRB0_CTL, 0x00000000, 0},
{M, 1, "Switching to clocksource tsc", 0x0, 0x0, 0},
{W, 1, "", PRB0_HEAD, 0x00000000, 0},
{W, 1, "", PRB0_TAIL, 0x00000000, 0},
{R, 1, "", PRB0_HEAD, 0x00000000, 0},
{W, 1, "", PRB0_START, 0x00000000, 0},
{W, 1, "", PRB0_CTL, 0x0001f001, 0},
{R, 1, "", PRB0_CTL, 0x0001f001, 0},
{R, 1, "", PRB0_START, 0x00000000, 0},
{R, 2, "", PRB0_HEAD, 0x00000000, 0},
{R, 1, "", PRB0_TAIL, 0x00000000, 0},
{R, 1, "", 0x6104, 0x00000000, 0},
{W, 1, "", 0x6104, 0x0000000b, 0},
{W, 1, "", ECOSKPD, 0x00010000, 0},
{M, 1, "[drm] initialized overlay support", 0x0, 0x0, 0},
{R, 1, "", _PIPEACONF, 0x00000000, 0},
{R, 1, "", _PIPEBCONF, 0x00000000, 0},
{R, 1, "", LVDS, 0x40000000, 0},
{R, 1, "", _FDI_TXB_CTL, 0x00000000, 0},
{R, 1, "", TV_CTL, 0x00000000, 0},
{R, 1, "", LVDS, 0x40000000, 0},
{R, 1, "", _FDI_TXB_CTL, 0x00000000, 0},
{R, 1, "", TV_CTL, 0x00000000, 0},
{R, 1, "", _PIPEACONF, 0x00000000, 0},
{W, 1, "", _PIPEACONF, 0x00000000, 0},
{R, 1, "", _DSPACNTR, 0x00000000, 0},
{R, 1, "", _PIPEBCONF, 0x00000000, 0},
{W, 1, "", _PIPEBCONF, 0x00000000, 0},
{R, 1, "", _DSPBCNTR, 0x00000000, 0},
{R, 1, "", LVDS, 0x40000000, 0},
{R, 1, "", _FDI_TXB_CTL, 0x00000000, 0},
{R, 1, "", TV_CTL, 0x00000000, 0},
{R, 1, "", LVDS, 0x40000000, 0},
{R, 1, "", _FDI_TXB_CTL, 0x00000000, 0},
{R, 1, "", TV_CTL, 0x00000000, 0},
{R, 1, "", _PIPEACONF, 0x00000000, 0},
{R, 1, "", _PIPEBCONF, 0x00000000, 0},
{W, 1, "", PORT_HOTPLUG_EN, 0x00000000, 0},
{R, 1, "", PORT_HOTPLUG_STAT, 0x00000000, 0},
{W, 1, "", PORT_HOTPLUG_STAT, 0x00000000, 0},
{W, 1, "", HWSTAM, 0x0000effe, 0},
{W, 1, "", _PIPEASTAT, 0x00000000, 0},
{W, 1, "", _PIPEBSTAT, 0x00000000, 0},
{W, 1, "", IMR, 0xffffffff, 0},
{W, 1, "", IER, 0x00000000, 0},
{W, 1, "", EMR, 0xffffffed, 0},
{W, 1, "", IMR, 0xfffd73ae, 0},
{W, 1, "", IER, 0x00028053, 0},
{R, 1, "", PORT_HOTPLUG_EN, 0x00000000, 0},
{W, 1, "", PORT_HOTPLUG_EN,  CRT_HOTPLUG_INT_EN | CRT_HOTPLUG_VOLTAGE_COMPARE_50 |0x00000220, 0},
{R, 1, "", PORT_HOTPLUG_EN,  CRT_HOTPLUG_INT_EN | CRT_HOTPLUG_VOLTAGE_COMPARE_50 |0x00000220, 0},
{W, 1, "", PORT_HOTPLUG_EN,  CRT_HOTPLUG_INT_EN | CRT_HOTPLUG_FORCE_DETECT | CRT_HOTPLUG_VOLTAGE_COMPARE_50 |0x00000228, 0},
{R, 1, "", PORT_HOTPLUG_EN,  CRT_HOTPLUG_INT_EN | CRT_HOTPLUG_FORCE_DETECT | CRT_HOTPLUG_VOLTAGE_COMPARE_50 |0x00000228, 0},
{R, 1, "", PORT_HOTPLUG_EN,  CRT_HOTPLUG_INT_EN | CRT_HOTPLUG_VOLTAGE_COMPARE_50 |0x00000220, 0},
{R, 1, "", PORT_HOTPLUG_STAT, 0x00000000, 0},
{W, 1, "", PORT_HOTPLUG_STAT,  CRT_HOTPLUG_INT_STATUS |0x00000800, 0},
{W, 1, "", PORT_HOTPLUG_EN,  CRT_HOTPLUG_INT_EN | CRT_HOTPLUG_VOLTAGE_COMPARE_50 |0x00000220, 0},
{W, 1, "", 0x5100, 0x00000002, 0},
{W, 1, "", 0x5104, 0x460100a1, 0},
{R, 2, "", 0x5108, 0x00009c00, 0},
{W, 1, "", 0x5104, 0x80000000, 0},
{W, 1, "", 0x5104, 0x00000000, 0},
{W, 2, "", 0x5100, 0x00000000, 0},
{R, 1, "", _PIPEACONF, 0x00000000, 0},
{W, 1, "", _FPA0, 0x00020e08, 0},
{W, 1, "", _FPA1, 0x00020e08, 0},
{W, 1, "", _DPLL_A, 0x14020003, 0},
{W, 2, "", _DPLL_A, 0x94020003, 0},
{R, 1, "", _PIPEACONF, 0x00000000, 0},
{W, 1, "", _HTOTAL_A, 0x06af04ff, 0},
{W, 1, "", _HBLANK_A, 0x06af04ff, 0},
{W, 1, "", _HSYNC_A, 0x05d70557, 0},
{W, 1, "", _VTOTAL_A, 0x044f03ff, 0},
{W, 1, "", _VBLANK_A, 0x044f03ff, 0},
{W, 1, "", _VSYNC_A, 0x04090402, 0},
{W, 1, "", _PIPEASRC, 0x04ff03ff, 0},
{W, 1, "", _DSPBSIZE, 0x03ff04ff, 0},
{W, 1, "", _DSPBPOS, 0x00000000, 0},
{W, 1, "", _PIPEACONF, 0x00000000, 0},
{R, 1, "", _DPLL_A, 0x94020003, 0},
{R, 1, "", _PIPEACONF, 0x00000000, 0},
{W, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_GMBUS_INTERRUPT_STATUS | PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000a03, 0},
{W, 1, "", _PIPEASTAT,  PIPE_GMBUS_INTERRUPT_STATUS | PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000a03, 0},
{R, 2, "", _PIPEASTAT, 0x00000000, 0},
{R, 2, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{W, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{R, 1, "", _PIPEASTAT, 0x00000000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{W, 1, "", _DSPBCNTR, 0x40000000, 0},
{R, 1, "", _DSPBCNTR, 0x40000000, 0},
{W, 1, "", _DSPBCNTR, 0x58000000, 0},
{W, 1, "", _DSPBSTRIDE, 0x00001400, 0},
{W, 1, "", _DSPBADDR, 0x00020000, 0},
{R, 2, "", DSPARB, ( DSPARB_CSTART_SHIFT &0x4)|0x00001d9c, 0},
{W, 1, "", INSTPM+0x20,  FW_BLC_SELF_EN_MASK |0x80000000, 0},
{W, 1, "", FW_BLC, 0x011d011a, 0},
{W, 1, "", FW_BLC2, 0x00000102, 0},
{R, 1, "", TV_CTL, 0x00000000, 0},
{W, 1, "", TV_H_CTL_1, 0x00400359, 0},
{W, 1, "", TV_H_CTL_2, 0x80480022, 0},
{W, 1, "", TV_H_CTL_3, 0x007c0344, 0},
{W, 1, "", TV_V_CTL_1, 0x00f01415, 0},
{W, 1, "", TV_V_CTL_2, 0x00060607, 0},
{W, 1, "", TV_V_CTL_3, 0x80120001, 0},
{W, 1, "", TV_V_CTL_4, 0x000900f0, 0},
{W, 1, "", TV_V_CTL_5, 0x000a00f0, 0},
{W, 1, "", TV_V_CTL_6, 0x000900f0, 0},
{W, 1, "", TV_V_CTL_7, 0x000a00f0, 0},
{W, 1, "", TV_SC_CTL_1, 0xc1710087, 0},
{W, 1, "", TV_SC_CTL_2, 0x6b405140, 0},
{W, 1, "", TV_SC_CTL_3, 0x00000000, 0},
{W, 1, "", TV_CSC_Y, 0x0332012d, 0},
{W, 1, "", TV_CSC_Y2, 0x07d30104, 0},
{W, 1, "", TV_CSC_U, 0x0733052d, 0},
{W, 1, "", TV_CSC_U2, 0x05c70200, 0},
{W, 1, "", TV_CSC_V, 0x0340030c, 0},
{W, 1, "", TV_CSC_V2, 0x06d00200, 0},
{W, 1, "", TV_CLR_KNOBS, 0x00606000, 0},
{W, 1, "", TV_CLR_LEVEL, 0x010b00e1, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _DSPBCNTR, 0x58000000, 0},
{W, 1, "", _DSPBCNTR, 0x58000000, 0},
{R, 1, "", _DSPBADDR, 0x00020000, 0},
{W, 1, "", _DSPBADDR, 0x00020000, 0},
{W, 1, "", _PIPEACONF, 0x00000000, 0},
{R, 1, "", _PIPEADSL, 0x0000029e, 0},
{R, 3, "", _PIPEADSL, 0x000003ff, 0},
{W, 1, "", _PFA_CTL_1, 0x80000000, 0},
{W, 1, "", _PFA_WIN_POS, 0x00360024, 0},
{W, 1, "", _PFA_WIN_SZ, 0x02640198, 0},
{W, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{W, 1, "", _DSPBCNTR, 0x58000000, 0},
{R, 1, "", _DSPBADDR, 0x00020000, 0},
{W, 1, "", _DSPBADDR, 0x00020000, 0},
{W, 1, "", TV_H_LUMA_0, 0xb1403000, 0},
{W, 1, "", TV_H_LUMA_0+0x4, 0x2e203500, 0},
{W, 1, "", TV_H_LUMA_0+0x8, 0x35002e20, 0},
{W, 1, "", TV_H_LUMA_0+0xc, 0x3000b140, 0},
{W, 1, "", TV_H_LUMA_0+0x10, 0x35a0b160, 0},
{W, 1, "", TV_H_LUMA_0+0x14, 0x2dc02e80, 0},
{W, 1, "", TV_H_LUMA_0+0x18, 0xb1403480, 0},
{W, 1, "", TV_H_LUMA_0+0x1c, 0xb1603000, 0},
{W, 1, "", TV_H_LUMA_0+0x20, 0x2ea03640, 0},
{W, 1, "", TV_H_LUMA_0+0x24, 0x34002d80, 0},
{W, 1, "", TV_H_LUMA_0+0x28, 0x3000b120, 0},
{W, 1, "", TV_H_LUMA_0+0x2c, 0x36e0b160, 0},
{W, 1, "", TV_H_LUMA_0+0x30, 0x2d202ef0, 0},
{W, 1, "", TV_H_LUMA_0+0x34, 0xb1203380, 0},
{W, 1, "", TV_H_LUMA_0+0x38, 0xb1603000, 0},
{W, 1, "", TV_H_LUMA_0+0x3c, 0x2f303780, 0},
{W, 1, "", TV_H_LUMA_0+0x40, 0x33002cc0, 0},
{W, 1, "", TV_H_LUMA_0+0x44, 0x3000b100, 0},
{W, 1, "", TV_H_LUMA_0+0x48, 0x3820b160, 0},
{W, 1, "", TV_H_LUMA_0+0x4c, 0x2c802f50, 0},
{W, 1, "", TV_H_LUMA_0+0x50, 0xb10032a0, 0},
{W, 1, "", TV_H_LUMA_0+0x54, 0xb1603000, 0},
{W, 1, "", TV_H_LUMA_0+0x58, 0x2f9038c0, 0},
{W, 1, "", TV_H_LUMA_0+0x5c, 0x32202c20, 0},
{W, 1, "", TV_H_LUMA_0+0x60, 0x3000b0e0, 0},
{W, 1, "", TV_H_LUMA_0+0x64, 0x3980b160, 0},
{W, 1, "", TV_H_LUMA_0+0x68, 0x2bc02fc0, 0},
{W, 1, "", TV_H_LUMA_0+0x6c, 0xb0e031c0, 0},
{W, 1, "", TV_H_LUMA_0+0x70, 0xb1603000, 0},
{W, 1, "", TV_H_LUMA_0+0x74, 0x2ff03a20, 0},
{W, 1, "", TV_H_LUMA_0+0x78, 0x31602b60, 0},
{W, 1, "", TV_H_LUMA_0+0x7c, 0xb020b0c0, 0},
{W, 1, "", 0x68180, 0x3ae0b160, 0},
{W, 1, "", 0x68184, 0x2b001810, 0},
{W, 1, "", 0x68188, 0xb0c03120, 0},
{W, 1, "", 0x6818c, 0xb140b020, 0},
{W, 1, "", 0x68190, 0x18283ba0, 0},
{W, 1, "", 0x68194, 0x30c02a80, 0},
{W, 1, "", 0x68198, 0xb020b0a0, 0},
{W, 1, "", 0x6819c, 0x3c60b140, 0},
{W, 1, "", 0x681a0, 0x2a201838, 0},
{W, 1, "", 0x681a4, 0xb0a03080, 0},
{W, 1, "", 0x681a8, 0xb120b020, 0},
{W, 1, "", 0x681ac, 0x18383d20, 0},
{W, 1, "", 0x681b0, 0x304029c0, 0},
{W, 1, "", 0x681b4, 0xb040b080, 0},
{W, 1, "", 0x681b8, 0x3de0b100, 0},
{W, 1, "", 0x681bc, 0x29601848, 0},
{W, 1, "", 0x681c0, 0xb0803000, 0},
{W, 1, "", 0x681c4, 0xb100b040, 0},
{W, 1, "", 0x681c8, 0x18483ec0, 0},
{W, 1, "", 0x681cc, 0xb0402900, 0},
{W, 1, "", 0x681d0, 0xb040b060, 0},
{W, 1, "", 0x681d4, 0x3f80b0c0, 0},
{W, 1, "", 0x681d8, 0x28801858, 0},
{W, 1, "", 0x681dc, 0xb060b080, 0},
{W, 1, "", 0x681e0, 0xb0a0b060, 0},
{W, 1, "", 0x681e4, 0x18602820, 0},
{W, 1, "", 0x681e8, 0xb0a02820, 0},
{W, 1, "", TV_H_LUMA_59, 0x0000b060, 0},
{W, 1, "", TV_H_CHROMA_0, 0xb1403000, 0},
{W, 1, "", TV_H_CHROMA_0+0x4, 0x2e203500, 0},
{W, 1, "", TV_H_CHROMA_0+0x8, 0x35002e20, 0},
{W, 1, "", TV_H_CHROMA_0+0xc, 0x3000b140, 0},
{W, 1, "", TV_H_CHROMA_0+0x10, 0x35a0b160, 0},
{W, 1, "", TV_H_CHROMA_0+0x14, 0x2dc02e80, 0},
{W, 1, "", TV_H_CHROMA_0+0x18, 0xb1403480, 0},
{W, 1, "", TV_H_CHROMA_0+0x1c, 0xb1603000, 0},
{W, 1, "", TV_H_CHROMA_0+0x20, 0x2ea03640, 0},
{W, 1, "", TV_H_CHROMA_0+0x24, 0x34002d80, 0},
{W, 1, "", TV_H_CHROMA_0+0x28, 0x3000b120, 0},
{W, 1, "", TV_H_CHROMA_0+0x2c, 0x36e0b160, 0},
{W, 1, "", TV_H_CHROMA_0+0x30, 0x2d202ef0, 0},
{W, 1, "", TV_H_CHROMA_0+0x34, 0xb1203380, 0},
{W, 1, "", TV_H_CHROMA_0+0x38, 0xb1603000, 0},
{W, 1, "", TV_H_CHROMA_0+0x3c, 0x2f303780, 0},
{W, 1, "", TV_H_CHROMA_0+0x40, 0x33002cc0, 0},
{W, 1, "", TV_H_CHROMA_0+0x44, 0x3000b100, 0},
{W, 1, "", TV_H_CHROMA_0+0x48, 0x3820b160, 0},
{W, 1, "", TV_H_CHROMA_0+0x4c, 0x2c802f50, 0},
{W, 1, "", TV_H_CHROMA_0+0x50, 0xb10032a0, 0},
{W, 1, "", TV_H_CHROMA_0+0x54, 0xb1603000, 0},
{W, 1, "", TV_H_CHROMA_0+0x58, 0x2f9038c0, 0},
{W, 1, "", TV_H_CHROMA_0+0x5c, 0x32202c20, 0},
{W, 1, "", TV_H_CHROMA_0+0x60, 0x3000b0e0, 0},
{W, 1, "", TV_H_CHROMA_0+0x64, 0x3980b160, 0},
{W, 1, "", TV_H_CHROMA_0+0x68, 0x2bc02fc0, 0},
{W, 1, "", TV_H_CHROMA_0+0x6c, 0xb0e031c0, 0},
{W, 1, "", TV_H_CHROMA_0+0x70, 0xb1603000, 0},
{W, 1, "", TV_H_CHROMA_0+0x74, 0x2ff03a20, 0},
{W, 1, "", TV_H_CHROMA_0+0x78, 0x31602b60, 0},
{W, 1, "", TV_H_CHROMA_0+0x7c, 0xb020b0c0, 0},
{W, 1, "", 0x68280, 0x3ae0b160, 0},
{W, 1, "", 0x68284, 0x2b001810, 0},
{W, 1, "", 0x68288, 0xb0c03120, 0},
{W, 1, "", 0x6828c, 0xb140b020, 0},
{W, 1, "", 0x68290, 0x18283ba0, 0},
{W, 1, "", 0x68294, 0x30c02a80, 0},
{W, 1, "", 0x68298, 0xb020b0a0, 0},
{W, 1, "", 0x6829c, 0x3c60b140, 0},
{W, 1, "", 0x682a0, 0x2a201838, 0},
{W, 1, "", 0x682a4, 0xb0a03080, 0},
{W, 1, "", 0x682a8, 0xb120b020, 0},
{W, 1, "", 0x682ac, 0x18383d20, 0},
{W, 1, "", 0x682b0, 0x304029c0, 0},
{W, 1, "", 0x682b4, 0xb040b080, 0},
{W, 1, "", 0x682b8, 0x3de0b100, 0},
{W, 1, "", 0x682bc, 0x29601848, 0},
{W, 1, "", 0x682c0, 0xb0803000, 0},
{W, 1, "", 0x682c4, 0xb100b040, 0},
{W, 1, "", 0x682c8, 0x18483ec0, 0},
{W, 1, "", 0x682cc, 0xb0402900, 0},
{W, 1, "", 0x682d0, 0xb040b060, 0},
{W, 1, "", 0x682d4, 0x3f80b0c0, 0},
{W, 1, "", 0x682d8, 0x28801858, 0},
{W, 1, "", 0x682dc, 0xb060b080, 0},
{W, 1, "", 0x682e0, 0xb0a0b060, 0},
{W, 1, "", 0x682e4, 0x18602820, 0},
{W, 1, "", 0x682e8, 0xb0a02820, 0},
{W, 1, "", TV_H_CHROMA_59, 0x0000b060, 0},
{W, 1, "", TV_V_LUMA_0, 0x36403000, 0},
{W, 1, "", TV_V_LUMA_0+0x4, 0x2d002cc0, 0},
{W, 1, "", TV_V_LUMA_0+0x8, 0x30003640, 0},
{W, 1, "", TV_V_LUMA_0+0xc, 0x2d0036c0, 0},
{W, 1, "", TV_V_LUMA_0+0x10, 0x35c02cc0, 0},
{W, 1, "", TV_V_LUMA_0+0x14, 0x37403000, 0},
{W, 1, "", TV_V_LUMA_0+0x18, 0x2c802d40, 0},
{W, 1, "", TV_V_LUMA_0+0x1c, 0x30003540, 0},
{W, 1, "", TV_V_LUMA_0+0x20, 0x2d8037c0, 0},
{W, 1, "", TV_V_LUMA_0+0x24, 0x34c02c40, 0},
{W, 1, "", TV_V_LUMA_0+0x28, 0x38403000, 0},
{W, 1, "", TV_V_LUMA_0+0x2c, 0x2bc02e00, 0},
{W, 1, "", TV_V_LUMA_0+0x30, 0x30003440, 0},
{W, 1, "", TV_V_LUMA_0+0x34, 0x2e2038c0, 0},
{W, 1, "", TV_V_LUMA_0+0x38, 0x34002b80, 0},
{W, 1, "", TV_V_LUMA_0+0x3c, 0x39803000, 0},
{W, 1, "", TV_V_LUMA_0+0x40, 0x2b402e40, 0},
{W, 1, "", TV_V_LUMA_0+0x44, 0x30003380, 0},
{W, 1, "", TV_V_LUMA_0+0x48, 0x2e603a00, 0},
{W, 1, "", TV_V_LUMA_0+0x4c, 0x33402b00, 0},
{W, 1, "", TV_V_LUMA_0+0x50, 0x3a803040, 0},
{W, 1, "", TV_V_LUMA_0+0x54, 0x2a802ea0, 0},
{W, 1, "", TV_V_LUMA_0+0x58, 0x30403300, 0},
{W, 1, "", TV_V_LUMA_0+0x5c, 0x2ec03b40, 0},
{W, 1, "", TV_V_LUMA_0+0x60, 0x32802a40, 0},
{W, 1, "", TV_V_LUMA_0+0x64, 0x3c003040, 0},
{W, 1, "", TV_V_LUMA_0+0x68, 0x2a002ec0, 0},
{W, 1, "", TV_V_LUMA_0+0x6c, 0x30803240, 0},
{W, 1, "", TV_V_LUMA_0+0x70, 0x2ec03c80, 0},
{W, 1, "", TV_V_LUMA_0+0x74, 0x320029c0, 0},
{W, 1, "", TV_V_LUMA_0+0x78, 0x3d403080, 0},
{W, 1, "", TV_V_LUMA_0+0x7c, 0x29402f00, 0},
{W, 1, "", 0x68380, 0x308031c0, 0},
{W, 1, "", 0x68384, 0x2f203dc0, 0},
{W, 1, "", 0x68388, 0x31802900, 0},
{W, 1, "", 0x6838c, 0x3e8030c0, 0},
{W, 1, "", 0x68390, 0x28802f40, 0},
{W, 1, "", 0x68394, 0x30c03140, 0},
{W, 1, "", 0x68398, 0x2f203f40, 0},
{W, 1, "", 0x6839c, 0x31402840, 0},
{W, 1, "", 0x683a0, 0x28003100, 0},
{W, 1, "", 0x683a4, 0x28002f00, 0},
{W, 1, "", TV_V_LUMA_42, 0x00003100, 0},
{W, 1, "", TV_V_CHROMA_0, 0x36403000, 0},
{W, 1, "", TV_V_CHROMA_0+0x4, 0x2d002cc0, 0},
{W, 1, "", TV_V_CHROMA_0+0x8, 0x30003640, 0},
{W, 1, "", TV_V_CHROMA_0+0xc, 0x2d0036c0, 0},
{W, 1, "", TV_V_CHROMA_0+0x10, 0x35c02cc0, 0},
{W, 1, "", TV_V_CHROMA_0+0x14, 0x37403000, 0},
{W, 1, "", TV_V_CHROMA_0+0x18, 0x2c802d40, 0},
{W, 1, "", TV_V_CHROMA_0+0x1c, 0x30003540, 0},
{W, 1, "", TV_V_CHROMA_0+0x20, 0x2d8037c0, 0},
{W, 1, "", TV_V_CHROMA_0+0x24, 0x34c02c40, 0},
{W, 1, "", TV_V_CHROMA_0+0x28, 0x38403000, 0},
{W, 1, "", TV_V_CHROMA_0+0x2c, 0x2bc02e00, 0},
{W, 1, "", TV_V_CHROMA_0+0x30, 0x30003440, 0},
{W, 1, "", TV_V_CHROMA_0+0x34, 0x2e2038c0, 0},
{W, 1, "", TV_V_CHROMA_0+0x38, 0x34002b80, 0},
{W, 1, "", TV_V_CHROMA_0+0x3c, 0x39803000, 0},
{W, 1, "", TV_V_CHROMA_0+0x40, 0x2b402e40, 0},
{W, 1, "", TV_V_CHROMA_0+0x44, 0x30003380, 0},
{W, 1, "", TV_V_CHROMA_0+0x48, 0x2e603a00, 0},
{W, 1, "", TV_V_CHROMA_0+0x4c, 0x33402b00, 0},
{W, 1, "", TV_V_CHROMA_0+0x50, 0x3a803040, 0},
{W, 1, "", TV_V_CHROMA_0+0x54, 0x2a802ea0, 0},
{W, 1, "", TV_V_CHROMA_0+0x58, 0x30403300, 0},
{W, 1, "", TV_V_CHROMA_0+0x5c, 0x2ec03b40, 0},
{W, 1, "", TV_V_CHROMA_0+0x60, 0x32802a40, 0},
{W, 1, "", TV_V_CHROMA_0+0x64, 0x3c003040, 0},
{W, 1, "", TV_V_CHROMA_0+0x68, 0x2a002ec0, 0},
{W, 1, "", TV_V_CHROMA_0+0x6c, 0x30803240, 0},
{W, 1, "", TV_V_CHROMA_0+0x70, 0x2ec03c80, 0},
{W, 1, "", TV_V_CHROMA_0+0x74, 0x320029c0, 0},
{W, 1, "", TV_V_CHROMA_0+0x78, 0x3d403080, 0},
{W, 1, "", TV_V_CHROMA_0+0x7c, 0x29402f00, 0},
{W, 1, "", 0x68480, 0x308031c0, 0},
{W, 1, "", 0x68484, 0x2f203dc0, 0},
{W, 1, "", 0x68488, 0x31802900, 0},
{W, 1, "", 0x6848c, 0x3e8030c0, 0},
{W, 1, "", 0x68490, 0x28802f40, 0},
{W, 1, "", 0x68494, 0x30c03140, 0},
{W, 1, "", 0x68498, 0x2f203f40, 0},
{W, 1, "", 0x6849c, 0x31402840, 0},
{W, 1, "", 0x684a0, 0x28003100, 0},
{W, 1, "", 0x684a4, 0x28002f00, 0},
{W, 1, "", TV_V_CHROMA_42, 0x00003100, 0},
{R, 1, "", TV_DAC, 0x70000000, 0},
{W, 1, "", TV_DAC, 0x00000000, 0},
{W, 1, "", TV_CTL, 0x000c0000, 0},
{R, 2, "", DSPARB, ( DSPARB_CSTART_SHIFT &0x4)|0x00001d9c, 0},
{W, 1, "", INSTPM+0x20,  FW_BLC_SELF_EN_MASK |0x80000000, 0},
{W, 1, "", INSTPM+0x20, 0x0001002f, 0},
{W, 1, "", FW_BLC, 0x0101011a, 0},
{W, 1, "", FW_BLC2, 0x00000102, 0},
{W, 1, "", INSTPM+0x20,  FW_BLC_SELF_EN_MASK |0x80008000, 0},
{R, 1, "", PP_CONTROL, 0xabcd0000, 0},
{R, 1, "", LVDS, 0x40000000, 0},
{R, 1, "", _DPLL_A, 0x94020003, 0},
{W, 3, "", _DPLL_A, 0x94020003, 0},
{R, 1, "", _DPLL_A, 0x94020003, 0},
{R, 2, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _DSPBCNTR, 0x58000000, 0},
{W, 1, "", _DSPBCNTR, 0xd8000000, 0},
{R, 1, "", _DSPBADDR, 0x00020000, 0},
{W, 1, "", _DSPBADDR, 0x00020000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{W, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{R, 2, "", _PIPEASTAT, 0x00000000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{W, 1, "", _PALETTE_A, 0x00000000, 0},
{W, 1, "", _PALETTE_A+0x4, 0x00010101, 0},
{W, 1, "", _PALETTE_A+0x8, 0x00020202, 0},
{W, 1, "", _PALETTE_A+0xc, 0x00030303, 0},
{W, 1, "", _PALETTE_A+0x10, 0x00040404, 0},
{W, 1, "", _PALETTE_A+0x14, 0x00050505, 0},
{W, 1, "", _PALETTE_A+0x18, 0x00060606, 0},
{W, 1, "", _PALETTE_A+0x1c, 0x00070707, 0},
{W, 1, "", _PALETTE_A+0x20, 0x00080808, 0},
{W, 1, "", _PALETTE_A+0x24, 0x00090909, 0},
{W, 1, "", _PALETTE_A+0x28, 0x000a0a0a, 0},
{W, 1, "", _PALETTE_A+0x2c, 0x000b0b0b, 0},
{W, 1, "", _PALETTE_A+0x30, 0x000c0c0c, 0},
{W, 1, "", _PALETTE_A+0x34, 0x000d0d0d, 0},
{W, 1, "", _PALETTE_A+0x38, 0x000e0e0e, 0},
{W, 1, "", _PALETTE_A+0x3c, 0x000f0f0f, 0},
{W, 1, "", _PALETTE_A+0x40, 0x00101010, 0},
{W, 1, "", _PALETTE_A+0x44, 0x00111111, 0},
{W, 1, "", _PALETTE_A+0x48, 0x00121212, 0},
{W, 1, "", _PALETTE_A+0x4c, 0x00131313, 0},
{W, 1, "", _PALETTE_A+0x50, 0x00141414, 0},
{W, 1, "", _PALETTE_A+0x54, 0x00151515, 0},
{W, 1, "", _PALETTE_A+0x58, 0x00161616, 0},
{W, 1, "", _PALETTE_A+0x5c, 0x00171717, 0},
{W, 1, "", _PALETTE_A+0x60, 0x00181818, 0},
{W, 1, "", _PALETTE_A+0x64, 0x00191919, 0},
{W, 1, "", _PALETTE_A+0x68, 0x001a1a1a, 0},
{W, 1, "", _PALETTE_A+0x6c, 0x001b1b1b, 0},
{W, 1, "", _PALETTE_A+0x70, 0x001c1c1c, 0},
{W, 1, "", _PALETTE_A+0x74, 0x001d1d1d, 0},
{W, 1, "", _PALETTE_A+0x78, 0x001e1e1e, 0},
{W, 1, "", _PALETTE_A+0x7c, 0x001f1f1f, 0},
{W, 1, "", 0xa080, 0x00202020, 0},
{W, 1, "", 0xa084, 0x00212121, 0},
{W, 1, "", 0xa088, 0x00222222, 0},
{W, 1, "", 0xa08c, 0x00232323, 0},
{W, 1, "", 0xa090, 0x00242424, 0},
{W, 1, "", 0xa094, 0x00252525, 0},
{W, 1, "", 0xa098, 0x00262626, 0},
{W, 1, "", 0xa09c, 0x00272727, 0},
{W, 1, "", 0xa0a0, 0x00282828, 0},
{W, 1, "", 0xa0a4, 0x00292929, 0},
{W, 1, "", 0xa0a8, 0x002a2a2a, 0},
{W, 1, "", 0xa0ac, 0x002b2b2b, 0},
{W, 1, "", 0xa0b0, 0x002c2c2c, 0},
{W, 1, "", 0xa0b4, 0x002d2d2d, 0},
{W, 1, "", 0xa0b8, 0x002e2e2e, 0},
{W, 1, "", 0xa0bc, 0x002f2f2f, 0},
{W, 1, "", 0xa0c0, 0x00303030, 0},
{W, 1, "", 0xa0c4, 0x00313131, 0},
{W, 1, "", 0xa0c8, 0x00323232, 0},
{W, 1, "", 0xa0cc, 0x00333333, 0},
{W, 1, "", 0xa0d0, 0x00343434, 0},
{W, 1, "", 0xa0d4, 0x00353535, 0},
{W, 1, "", 0xa0d8, 0x00363636, 0},
{W, 1, "", 0xa0dc, 0x00373737, 0},
{W, 1, "", 0xa0e0, 0x00383838, 0},
{W, 1, "", 0xa0e4, 0x00393939, 0},
{W, 1, "", 0xa0e8, 0x003a3a3a, 0},
{W, 1, "", 0xa0ec, 0x003b3b3b, 0},
{W, 1, "", 0xa0f0, 0x003c3c3c, 0},
{W, 1, "", 0xa0f4, 0x003d3d3d, 0},
{W, 1, "", 0xa0f8, 0x003e3e3e, 0},
{W, 1, "", 0xa0fc, 0x003f3f3f, 0},
{W, 1, "", 0xa100, 0x00404040, 0},
{W, 1, "", 0xa104, 0x00414141, 0},
{W, 1, "", 0xa108, 0x00424242, 0},
{W, 1, "", 0xa10c, 0x00434343, 0},
{W, 1, "", 0xa110, 0x00444444, 0},
{W, 1, "", 0xa114, 0x00454545, 0},
{W, 1, "", 0xa118, 0x00464646, 0},
{W, 1, "", 0xa11c, 0x00474747, 0},
{W, 1, "", 0xa120, 0x00484848, 0},
{W, 1, "", 0xa124, 0x00494949, 0},
{W, 1, "", 0xa128, 0x004a4a4a, 0},
{W, 1, "", 0xa12c, 0x004b4b4b, 0},
{W, 1, "", 0xa130, 0x004c4c4c, 0},
{W, 1, "", 0xa134, 0x004d4d4d, 0},
{W, 1, "", 0xa138, 0x004e4e4e, 0},
{W, 1, "", 0xa13c, 0x004f4f4f, 0},
{W, 1, "", 0xa140, 0x00505050, 0},
{W, 1, "", 0xa144, 0x00515151, 0},
{W, 1, "", 0xa148, 0x00525252, 0},
{W, 1, "", 0xa14c, 0x00535353, 0},
{W, 1, "", 0xa150, 0x00545454, 0},
{W, 1, "", 0xa154, 0x00555555, 0},
{W, 1, "", 0xa158, 0x00565656, 0},
{W, 1, "", 0xa15c, 0x00575757, 0},
{W, 1, "", 0xa160, 0x00585858, 0},
{W, 1, "", 0xa164, 0x00595959, 0},
{W, 1, "", 0xa168, 0x005a5a5a, 0},
{W, 1, "", 0xa16c, 0x005b5b5b, 0},
{W, 1, "", 0xa170, 0x005c5c5c, 0},
{W, 1, "", 0xa174, 0x005d5d5d, 0},
{W, 1, "", 0xa178, 0x005e5e5e, 0},
{W, 1, "", 0xa17c, 0x005f5f5f, 0},
{W, 1, "", 0xa180, 0x00606060, 0},
{W, 1, "", 0xa184, 0x00616161, 0},
{W, 1, "", FORCEWAKE_MT, 0x00626262, 0},
{W, 1, "", FORCEWAKE, 0x00636363, 0},
{W, 1, "", 0xa190, 0x00646464, 0},
{W, 1, "", 0xa194, 0x00656565, 0},
{W, 1, "", 0xa198, 0x00666666, 0},
{W, 1, "", 0xa19c, 0x00676767, 0},
{W, 1, "", 0xa1a0, 0x00686868, 0},
{W, 1, "", 0xa1a4, 0x00696969, 0},
{W, 1, "", 0xa1a8, 0x006a6a6a, 0},
{W, 1, "", 0xa1ac, 0x006b6b6b, 0},
{W, 1, "", 0xa1b0, 0x006c6c6c, 0},
{W, 1, "", 0xa1b4, 0x006d6d6d, 0},
{W, 1, "", 0xa1b8, 0x006e6e6e, 0},
{W, 1, "", 0xa1bc, 0x006f6f6f, 0},
{W, 1, "", 0xa1c0, 0x00707070, 0},
{W, 1, "", 0xa1c4, 0x00717171, 0},
{W, 1, "", 0xa1c8, 0x00727272, 0},
{W, 1, "", 0xa1cc, 0x00737373, 0},
{W, 1, "", 0xa1d0, 0x00747474, 0},
{W, 1, "", 0xa1d4, 0x00757575, 0},
{W, 1, "", 0xa1d8, 0x00767676, 0},
{W, 1, "", 0xa1dc, 0x00777777, 0},
{W, 1, "", 0xa1e0, 0x00787878, 0},
{W, 1, "", 0xa1e4, 0x00797979, 0},
{W, 1, "", 0xa1e8, 0x007a7a7a, 0},
{W, 1, "", 0xa1ec, 0x007b7b7b, 0},
{W, 1, "", 0xa1f0, 0x007c7c7c, 0},
{W, 1, "", 0xa1f4, 0x007d7d7d, 0},
{W, 1, "", 0xa1f8, 0x007e7e7e, 0},
{W, 1, "", 0xa1fc, 0x007f7f7f, 0},
{W, 1, "", 0xa200, 0x00808080, 0},
{W, 1, "", 0xa204, 0x00818181, 0},
{W, 1, "", 0xa208, 0x00828282, 0},
{W, 1, "", 0xa20c, 0x00838383, 0},
{W, 1, "", 0xa210, 0x00848484, 0},
{W, 1, "", 0xa214, 0x00858585, 0},
{W, 1, "", 0xa218, 0x00868686, 0},
{W, 1, "", 0xa21c, 0x00878787, 0},
{W, 1, "", 0xa220, 0x00888888, 0},
{W, 1, "", 0xa224, 0x00898989, 0},
{W, 1, "", 0xa228, 0x008a8a8a, 0},
{W, 1, "", 0xa22c, 0x008b8b8b, 0},
{W, 1, "", 0xa230, 0x008c8c8c, 0},
{W, 1, "", 0xa234, 0x008d8d8d, 0},
{W, 1, "", 0xa238, 0x008e8e8e, 0},
{W, 1, "", 0xa23c, 0x008f8f8f, 0},
{W, 1, "", 0xa240, 0x00909090, 0},
{W, 1, "", 0xa244, 0x00919191, 0},
{W, 1, "", 0xa248, 0x00929292, 0},
{W, 1, "", 0xa24c, 0x00939393, 0},
{W, 1, "", 0xa250, 0x00949494, 0},
{W, 1, "", 0xa254, 0x00959595, 0},
{W, 1, "", 0xa258, 0x00969696, 0},
{W, 1, "", 0xa25c, 0x00979797, 0},
{W, 1, "", 0xa260, 0x00989898, 0},
{W, 1, "", 0xa264, 0x00999999, 0},
{W, 1, "", 0xa268, 0x009a9a9a, 0},
{W, 1, "", 0xa26c, 0x009b9b9b, 0},
{W, 1, "", 0xa270, 0x009c9c9c, 0},
{W, 1, "", 0xa274, 0x009d9d9d, 0},
{W, 1, "", 0xa278, 0x009e9e9e, 0},
{W, 1, "", 0xa27c, 0x009f9f9f, 0},
{W, 1, "", 0xa280, 0x00a0a0a0, 0},
{W, 1, "", 0xa284, 0x00a1a1a1, 0},
{W, 1, "", 0xa288, 0x00a2a2a2, 0},
{W, 1, "", 0xa28c, 0x00a3a3a3, 0},
{W, 1, "", 0xa290, 0x00a4a4a4, 0},
{W, 1, "", 0xa294, 0x00a5a5a5, 0},
{W, 1, "", 0xa298, 0x00a6a6a6, 0},
{W, 1, "", 0xa29c, 0x00a7a7a7, 0},
{W, 1, "", 0xa2a0, 0x00a8a8a8, 0},
{W, 1, "", 0xa2a4, 0x00a9a9a9, 0},
{W, 1, "", 0xa2a8, 0x00aaaaaa, 0},
{W, 1, "", 0xa2ac, 0x00ababab, 0},
{W, 1, "", 0xa2b0, 0x00acacac, 0},
{W, 1, "", 0xa2b4, 0x00adadad, 0},
{W, 1, "", 0xa2b8, 0x00aeaeae, 0},
{W, 1, "", 0xa2bc, 0x00afafaf, 0},
{W, 1, "", 0xa2c0, 0x00b0b0b0, 0},
{W, 1, "", 0xa2c4, 0x00b1b1b1, 0},
{W, 1, "", 0xa2c8, 0x00b2b2b2, 0},
{W, 1, "", 0xa2cc, 0x00b3b3b3, 0},
{W, 1, "", 0xa2d0, 0x00b4b4b4, 0},
{W, 1, "", 0xa2d4, 0x00b5b5b5, 0},
{W, 1, "", 0xa2d8, 0x00b6b6b6, 0},
{W, 1, "", 0xa2dc, 0x00b7b7b7, 0},
{W, 1, "", 0xa2e0, 0x00b8b8b8, 0},
{W, 1, "", 0xa2e4, 0x00b9b9b9, 0},
{W, 1, "", 0xa2e8, 0x00bababa, 0},
{W, 1, "", 0xa2ec, 0x00bbbbbb, 0},
{W, 1, "", 0xa2f0, 0x00bcbcbc, 0},
{W, 1, "", 0xa2f4, 0x00bdbdbd, 0},
{W, 1, "", 0xa2f8, 0x00bebebe, 0},
{W, 1, "", 0xa2fc, 0x00bfbfbf, 0},
{W, 1, "", 0xa300, 0x00c0c0c0, 0},
{W, 1, "", 0xa304, 0x00c1c1c1, 0},
{W, 1, "", 0xa308, 0x00c2c2c2, 0},
{W, 1, "", 0xa30c, 0x00c3c3c3, 0},
{W, 1, "", 0xa310, 0x00c4c4c4, 0},
{W, 1, "", 0xa314, 0x00c5c5c5, 0},
{W, 1, "", 0xa318, 0x00c6c6c6, 0},
{W, 1, "", 0xa31c, 0x00c7c7c7, 0},
{W, 1, "", 0xa320, 0x00c8c8c8, 0},
{W, 1, "", 0xa324, 0x00c9c9c9, 0},
{W, 1, "", 0xa328, 0x00cacaca, 0},
{W, 1, "", 0xa32c, 0x00cbcbcb, 0},
{W, 1, "", 0xa330, 0x00cccccc, 0},
{W, 1, "", 0xa334, 0x00cdcdcd, 0},
{W, 1, "", 0xa338, 0x00cecece, 0},
{W, 1, "", 0xa33c, 0x00cfcfcf, 0},
{W, 1, "", 0xa340, 0x00d0d0d0, 0},
{W, 1, "", 0xa344, 0x00d1d1d1, 0},
{W, 1, "", 0xa348, 0x00d2d2d2, 0},
{W, 1, "", 0xa34c, 0x00d3d3d3, 0},
{W, 1, "", 0xa350, 0x00d4d4d4, 0},
{W, 1, "", 0xa354, 0x00d5d5d5, 0},
{W, 1, "", 0xa358, 0x00d6d6d6, 0},
{W, 1, "", 0xa35c, 0x00d7d7d7, 0},
{W, 1, "", 0xa360, 0x00d8d8d8, 0},
{W, 1, "", 0xa364, 0x00d9d9d9, 0},
{W, 1, "", 0xa368, 0x00dadada, 0},
{W, 1, "", 0xa36c, 0x00dbdbdb, 0},
{W, 1, "", 0xa370, 0x00dcdcdc, 0},
{W, 1, "", 0xa374, 0x00dddddd, 0},
{W, 1, "", 0xa378, 0x00dedede, 0},
{W, 1, "", 0xa37c, 0x00dfdfdf, 0},
{W, 1, "", 0xa380, 0x00e0e0e0, 0},
{W, 1, "", 0xa384, 0x00e1e1e1, 0},
{W, 1, "", 0xa388, 0x00e2e2e2, 0},
{W, 1, "", 0xa38c, 0x00e3e3e3, 0},
{W, 1, "", 0xa390, 0x00e4e4e4, 0},
{W, 1, "", 0xa394, 0x00e5e5e5, 0},
{W, 1, "", 0xa398, 0x00e6e6e6, 0},
{W, 1, "", 0xa39c, 0x00e7e7e7, 0},
{W, 1, "", 0xa3a0, 0x00e8e8e8, 0},
{W, 1, "", 0xa3a4, 0x00e9e9e9, 0},
{W, 1, "", 0xa3a8, 0x00eaeaea, 0},
{W, 1, "", 0xa3ac, 0x00ebebeb, 0},
{W, 1, "", 0xa3b0, 0x00ececec, 0},
{W, 1, "", 0xa3b4, 0x00ededed, 0},
{W, 1, "", 0xa3b8, 0x00eeeeee, 0},
{W, 1, "", 0xa3bc, 0x00efefef, 0},
{W, 1, "", 0xa3c0, 0x00f0f0f0, 0},
{W, 1, "", 0xa3c4, 0x00f1f1f1, 0},
{W, 1, "", 0xa3c8, 0x00f2f2f2, 0},
{W, 1, "", 0xa3cc, 0x00f3f3f3, 0},
{W, 1, "", 0xa3d0, 0x00f4f4f4, 0},
{W, 1, "", 0xa3d4, 0x00f5f5f5, 0},
{W, 1, "", 0xa3d8, 0x00f6f6f6, 0},
{W, 1, "", 0xa3dc, 0x00f7f7f7, 0},
{W, 1, "", 0xa3e0, 0x00f8f8f8, 0},
{W, 1, "", 0xa3e4, 0x00f9f9f9, 0},
{W, 1, "", 0xa3e8, 0x00fafafa, 0},
{W, 1, "", 0xa3ec, 0x00fbfbfb, 0},
{W, 1, "", 0xa3f0, 0x00fcfcfc, 0},
{W, 1, "", 0xa3f4, 0x00fdfdfd, 0},
{W, 1, "", 0xa3f8, 0x00fefefe, 0},
{W, 1, "", 0xa3fc, 0x00ffffff, 0},
{R, 1, "", TV_CTL, 0x000c0000, 0},
{W, 1, "", TV_CTL, 0x800c0000, 0},
{R, 1, "", LVDS, 0x40000000, 0},
{R, 1, "", _FDI_TXB_CTL, 0x00000000, 0},
{R, 2, "", TV_CTL, 0x800c0000, 0},
{R, 1, "", LVDS, 0x40000000, 0},
{R, 1, "", _FDI_TXB_CTL, 0x00000000, 0},
{R, 1, "", TV_CTL, 0x800c0000, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _PIPEBCONF, 0x00000000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{W, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{R, 2, "", _PIPEASTAT, 0x00000000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{R, 1, "", TV_DAC, 0x70000000, 0},
{R, 1, "", TV_CTL, 0x800c0000, 0},
{W, 1, "", TV_CTL, 0x000c0007, 0},
{W, 1, "", TV_DAC, 0x0f0000aa, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{W, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{R, 2, "", _PIPEASTAT, 0x00000000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{R, 1, "", TV_DAC, 0x7f0000aa, 0},
{W, 1, "", TV_DAC, 0x70000000, 0},
{W, 1, "", TV_CTL, 0x800c0000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{W, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{R, 4, "", _PIPEASTAT, 0x00000000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{R, 1, "", TV_CTL, 0x800c0000, 0},
{W, 1, "", TV_CTL, 0x000c0000, 0},
{W, 1, "", INSTPM, 0x08000800, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x62029b1b, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _VTOTAL_A, 0x044f03ff, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x6217572c, 0},
{R, 1, "", _HTOTAL_A, 0x06af04ff, 0},
{R, 1, "", _VBLANK_A, 0x044f03ff, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _VTOTAL_A, 0x044f03ff, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x63156af7, 0},
{R, 1, "", _HTOTAL_A, 0x06af04ff, 0},
{R, 1, "", _VBLANK_A, 0x044f03ff, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _VTOTAL_A, 0x044f03ff, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x64137fac, 0},
{R, 1, "", _HTOTAL_A, 0x06af04ff, 0},
{R, 1, "", _VBLANK_A, 0x044f03ff, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x6510b8c6, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x6607c3b5, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _VTOTAL_A, 0x044f03ff, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x661c804f, 0},
{R, 1, "", _HTOTAL_A, 0x06af04ff, 0},
{R, 1, "", _VBLANK_A, 0x044f03ff, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _VTOTAL_A, 0x044f03ff, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x671a949c, 0},
{R, 1, "", _HTOTAL_A, 0x06af04ff, 0},
{R, 1, "", _VBLANK_A, 0x044f03ff, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _VTOTAL_A, 0x044f03ff, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x6818a96d, 0},
{R, 1, "", _HTOTAL_A, 0x06af04ff, 0},
{R, 1, "", _VBLANK_A, 0x044f03ff, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x6915e1d1, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x6a0cec77, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _VTOTAL_A, 0x044f03ff, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x6b04d273, 0},
{R, 1, "", _HTOTAL_A, 0x06af04ff, 0},
{R, 1, "", _VBLANK_A, 0x044f03ff, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _VTOTAL_A, 0x044f03ff, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x6c02e710, 0},
{R, 1, "", _HTOTAL_A, 0x06af04ff, 0},
{R, 1, "", _VBLANK_A, 0x044f03ff, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _VTOTAL_A, 0x044f03ff, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x6d00fb0c, 0},
{R, 1, "", _HTOTAL_A, 0x06af04ff, 0},
{R, 1, "", _VBLANK_A, 0x044f03ff, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _PIPEA_FLIPCOUNT_GM45, 0x6d1b0b04, 0},
{R, 1, "", _PIPEA_FRMCOUNT_GM45, 0x00000000, 0},
{R, 1, "", _DSPBCNTR, 0xd8000000, 0},
{W, 1, "", _DSPBCNTR, 0x58000000, 0},
{R, 1, "", _DSPBADDR, 0x00020000, 0},
{W, 1, "", _DSPBADDR, 0x00020000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{W, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{R, 2, "", _PIPEASTAT, 0x00000000, 0},
{R, 1, "", _PIPEASTAT,  PIPE_VSYNC_INTERRUPT_STATUS | PIPE_VBLANK_INTERRUPT_STATUS | PIPE_OVERLAY_UPDATED_STATUS |0x00000203, 0},
{R, 1, "", _DSPACNTR, 0x00000000, 0},
{R, 1, "", _DSPBCNTR, 0x58000000, 0},
{R, 1, "", _PIPEACONF,  PIPECONF_ENABLE |0x80000000, 0},
{W, 1, "", _PIPEACONF, 0x00000000, 0},
{R, 2, "", _PIPEADSL, 0x000003ff, 0},
{R, 1, "", _PIPEACONF, 0x00000000, 0},
{R, 1, "", _DPLL_A, 0x94020003, 0},
{W, 1, "", _DPLL_A, 0x14020003, 0},
{R, 2, "", DSPARB, ( DSPARB_CSTART_SHIFT &0x4)|0x00001d9c, 0},
{W, 1, "", INSTPM+0x20,  FW_BLC_SELF_EN_MASK |0x80000000, 0},
{W, 1, "", FW_BLC, 0x011d011a, 0},
{W, 1, "", FW_BLC2, 0x00000102, 0},
{R, 1, "", _DSPBCNTR, 0x58000000, 0},
{R, 1, "", _PIPEACONF, 0x00000000, 0},
{R, 1, "", LVDS, 0x40000000, 0},
{R, 1, "", _FDI_TXB_CTL, 0x00000000, 0},
{R, 1, "", TV_CTL, 0x000c0000, 0},
{R, 1, "", LVDS, 0x40000000, 0},
{R, 1, "", _FDI_TXB_CTL, 0x00000000, 0},
{R, 1, "", TV_CTL, 0x000c0000, 0},
{R, 1, "", _PIPEACONF, 0x00000000, 0},
{R, 1, "", _PIPEBCONF, 0x00000000, 0},
{M, 1, "fbcon:inteldrmfb (fb0) is primary device", 0x0, 0x0, 0},
{R, 1, "", _PIPEBCONF, 0x00000000, 0},
{R, 2, "", LVDS, 0x40000000, 0},
{W, 1, "", _FPB0, 0x00020e09, 0},
{W, 1, "", _FPB1,  FP_M1_DIV_SHIFT | DPLLA_INPUT_BUFFER_ENABLE | VF_UNIT_CLOCK_GATE_DISABLE |0x00020e09, 0},
{W, 1, "", _DPLL_B,  DPLL_VGA_MODE_DIS | DPLLB_MODE_LVDS |0x18046000, 0},
{R, 1, "", LVDS, 0x40000000, 0},
{W, 1, "", LVDS,  LVDS_ON | PLL_P1_DIVIDE_BY_TWO | DISPLAY_RATE_SELECT_FPA1 |0xc0300300, 0},
{W, 2, "", _DPLL_B,  DPLL_VCO_ENABLE | DPLL_VGA_MODE_DIS | DPLLB_MODE_LVDS |0x98046000, 0},
{R, 1, "", _PIPEBCONF, 0x00000000, 0},
{W, 1, "", _HTOTAL_B, 0x053f03ff, 0},
{W, 1, "", _HBLANK_B, 0x053f03ff, 0},
{W, 1, "", _HSYNC_B, 0x049f0417, 0},
{W, 1, "", _VTOTAL_B, 0x032502ff, 0},
{W, 1, "", _VBLANK_B, 0x032502ff, 0},
{W, 1, "", _VSYNC_B, 0x03080302, 0},
{W, 1, "", _PIPEBSRC, 0x03ff02ff, 0},
{W, 1, "", _DSPASIZE, 0x02ff03ff, 0},
{W, 1, "", _DSPASTRIDE+0x4, 0x00000000, 0},
{W, 1, "", _PIPEBCONF, 0x00000000, 0},
{R, 1, "", _DPLL_B,  DPLL_VCO_ENABLE | DPLL_VGA_MODE_DIS | DPLLB_MODE_LVDS |0x98046000, 0},
{R, 1, "", _PIPEBCONF, 0x00000000, 0},
{W, 1, "", _PIPEBCONF, 0x80000000, 0},
{R, 1, "", _PIPEBSTAT, 0x00000040, 0},
{W, 1, "", _PIPEBSTAT, 0x00000042, 0},
{R, 1, "", _PIPEBSTAT, 0x00000000, 0},
{R, 2, "", _PIPEBSTAT, 0x00000202, 0},
{W, 1, "", _PIPEBSTAT, 0x00000202, 0},
{R, 3, "", _PIPEBSTAT, 0x00000000, 0},
{R, 1, "", _PIPEBSTAT, 0x00000202, 0},
{W, 1, "", _DSPACNTR, 0x41000000, 0},
{R, 1, "", _DSPACNTR, 0x41000000, 0},
{W, 1, "", _DSPACNTR, 0x59000000, 0},
{W, 1, "", _DSPASTRIDE, 0x00001000, 0},
{W, 1, "", _DSPAADDR, 0x00020000, 0},
{R, 2, "", DSPARB, ( DSPARB_CSTART_SHIFT &0x4)|0x00001d9c, 0},
{W, 1, "", INSTPM+0x20,  FW_BLC_SELF_EN_MASK |0x80000000, 0},
{W, 1, "", FW_BLC, 0x011d011a, 0},
{W, 1, "", FW_BLC2, 0x00000102, 0},
{R, 2, "", DSPARB, ( DSPARB_CSTART_SHIFT &0x4)|0x00001d9c, 0},
{W, 1, "", INSTPM+0x20,  FW_BLC_SELF_EN_MASK |0x80000000, 0},
{W, 1, "", INSTPM+0x20, 0x0001003f, 0},
{W, 1, "", FW_BLC, 0x011d0109, 0},
{W, 1, "", FW_BLC2, 0x00000102, 0},
{W, 1, "", INSTPM+0x20,  FW_BLC_SELF_EN_MASK |0x80008000, 0},
{R, 1, "", PP_CONTROL, 0xabcd0000, 0},
{R, 1, "", LVDS,  LVDS_ON | PLL_P1_DIVIDE_BY_TWO | DISPLAY_RATE_SELECT_FPA1 |0xc0300300, 0},
{R, 1, "", _DPLL_B,  DPLL_VCO_ENABLE | DPLL_VGA_MODE_DIS | DPLLB_MODE_LVDS |0x98046000, 0},
{W, 3, "", _DPLL_B,  DPLL_VCO_ENABLE | DPLL_VGA_MODE_DIS | DPLLB_MODE_LVDS |0x98046000, 0},
{R, 1, "", _DPLL_B,  DPLL_VCO_ENABLE | DPLL_VGA_MODE_DIS | DPLLB_MODE_LVDS |0x98046000, 0},
{R, 2, "", _PIPEBCONF, 0x80000000, 0},
{R, 1, "", _DSPACNTR,  0x59000000, 0},
{W, 1, "", _DSPACNTR,  0xd9000000, 0},
{R, 1, "", _DSPAADDR, 0x00020000, 0},
{W, 1, "", _DSPAADDR, 0x00020000, 0},
{R, 1, "", _PIPEBSTAT, 0x00000202, 0},
{W, 1, "", _PIPEBSTAT, 0x00000202, 0},
{R, 3, "", _PIPEBSTAT, 0x00000000, 0},
{R, 1, "", _PIPEBSTAT, 0x00000202, 0},
{W, 1, "", _PALETTE_B, 0x00000000, 0},
{W, 1, "", _PALETTE_B+0x4, 0x00010101, 0},
{W, 1, "", _PALETTE_B+0x8, 0x00020202, 0},
{W, 1, "", _PALETTE_B+0xc, 0x00030303, 0},
{W, 1, "", _PALETTE_B+0x10, 0x00040404, 0},
{W, 1, "", _PALETTE_B+0x14, 0x00050505, 0},
{W, 1, "", _PALETTE_B+0x18, 0x00060606, 0},
{W, 1, "", _PALETTE_B+0x1c, 0x00070707, 0},
{W, 1, "", _PALETTE_B+0x20, 0x00080808, 0},
{W, 1, "", _PALETTE_B+0x24, 0x00090909, 0},
{W, 1, "", _PALETTE_B+0x28, 0x000a0a0a, 0},
{W, 1, "", _PALETTE_B+0x2c, 0x000b0b0b, 0},
{W, 1, "", _PALETTE_B+0x30, 0x000c0c0c, 0},
{W, 1, "", _PALETTE_B+0x34, 0x000d0d0d, 0},
{W, 1, "", _PALETTE_B+0x38, 0x000e0e0e, 0},
{W, 1, "", _PALETTE_B+0x3c, 0x000f0f0f, 0},
{W, 1, "", _PALETTE_B+0x40, 0x00101010, 0},
{W, 1, "", _PALETTE_B+0x44, 0x00111111, 0},
{W, 1, "", _PALETTE_B+0x48, 0x00121212, 0},
{W, 1, "", _PALETTE_B+0x4c, 0x00131313, 0},
{W, 1, "", _PALETTE_B+0x50, 0x00141414, 0},
{W, 1, "", _PALETTE_B+0x54, 0x00151515, 0},
{W, 1, "", _PALETTE_B+0x58, 0x00161616, 0},
{W, 1, "", _PALETTE_B+0x5c, 0x00171717, 0},
{W, 1, "", _PALETTE_B+0x60, 0x00181818, 0},
{W, 1, "", _PALETTE_B+0x64, 0x00191919, 0},
{W, 1, "", _PALETTE_B+0x68, 0x001a1a1a, 0},
{W, 1, "", _PALETTE_B+0x6c, 0x001b1b1b, 0},
{W, 1, "", _PALETTE_B+0x70, 0x001c1c1c, 0},
{W, 1, "", _PALETTE_B+0x74, 0x001d1d1d, 0},
{W, 1, "", _PALETTE_B+0x78, 0x001e1e1e, 0},
{W, 1, "", _PALETTE_B+0x7c, 0x001f1f1f, 0},
{W, 1, "", 0xa880, 0x00202020, 0},
{W, 1, "", 0xa884, 0x00212121, 0},
{W, 1, "", 0xa888, 0x00222222, 0},
{W, 1, "", 0xa88c, 0x00232323, 0},
{W, 1, "", 0xa890, 0x00242424, 0},
{W, 1, "", 0xa894, 0x00252525, 0},
{W, 1, "", 0xa898, 0x00262626, 0},
{W, 1, "", 0xa89c, 0x00272727, 0},
{W, 1, "", 0xa8a0, 0x00282828, 0},
{W, 1, "", 0xa8a4, 0x00292929, 0},
{W, 1, "", 0xa8a8, 0x002a2a2a, 0},
{W, 1, "", 0xa8ac, 0x002b2b2b, 0},
{W, 1, "", 0xa8b0, 0x002c2c2c, 0},
{W, 1, "", 0xa8b4, 0x002d2d2d, 0},
{W, 1, "", 0xa8b8, 0x002e2e2e, 0},
{W, 1, "", 0xa8bc, 0x002f2f2f, 0},
{W, 1, "", 0xa8c0, 0x00303030, 0},
{W, 1, "", 0xa8c4, 0x00313131, 0},
{W, 1, "", 0xa8c8, 0x00323232, 0},
{W, 1, "", 0xa8cc, 0x00333333, 0},
{W, 1, "", 0xa8d0, 0x00343434, 0},
{W, 1, "", 0xa8d4, 0x00353535, 0},
{W, 1, "", 0xa8d8, 0x00363636, 0},
{W, 1, "", 0xa8dc, 0x00373737, 0},
{W, 1, "", 0xa8e0, 0x00383838, 0},
{W, 1, "", 0xa8e4, 0x00393939, 0},
{W, 1, "", 0xa8e8, 0x003a3a3a, 0},
{W, 1, "", 0xa8ec, 0x003b3b3b, 0},
{W, 1, "", 0xa8f0, 0x003c3c3c, 0},
{W, 1, "", 0xa8f4, 0x003d3d3d, 0},
{W, 1, "", 0xa8f8, 0x003e3e3e, 0},
{W, 1, "", 0xa8fc, 0x003f3f3f, 0},
{W, 1, "", 0xa900, 0x00404040, 0},
{W, 1, "", 0xa904, 0x00414141, 0},
{W, 1, "", 0xa908, 0x00424242, 0},
{W, 1, "", 0xa90c, 0x00434343, 0},
{W, 1, "", 0xa910, 0x00444444, 0},
{W, 1, "", 0xa914, 0x00454545, 0},
{W, 1, "", 0xa918, 0x00464646, 0},
{W, 1, "", 0xa91c, 0x00474747, 0},
{W, 1, "", 0xa920, 0x00484848, 0},
{W, 1, "", 0xa924, 0x00494949, 0},
{W, 1, "", 0xa928, 0x004a4a4a, 0},
{W, 1, "", 0xa92c, 0x004b4b4b, 0},
{W, 1, "", 0xa930, 0x004c4c4c, 0},
{W, 1, "", 0xa934, 0x004d4d4d, 0},
{W, 1, "", 0xa938, 0x004e4e4e, 0},
{W, 1, "", 0xa93c, 0x004f4f4f, 0},
{W, 1, "", 0xa940, 0x00505050, 0},
{W, 1, "", 0xa944, 0x00515151, 0},
{W, 1, "", 0xa948, 0x00525252, 0},
{W, 1, "", 0xa94c, 0x00535353, 0},
{W, 1, "", 0xa950, 0x00545454, 0},
{W, 1, "", 0xa954, 0x00555555, 0},
{W, 1, "", 0xa958, 0x00565656, 0},
{W, 1, "", 0xa95c, 0x00575757, 0},
{W, 1, "", 0xa960, 0x00585858, 0},
{W, 1, "", 0xa964, 0x00595959, 0},
{W, 1, "", 0xa968, 0x005a5a5a, 0},
{W, 1, "", 0xa96c, 0x005b5b5b, 0},
{W, 1, "", 0xa970, 0x005c5c5c, 0},
{W, 1, "", 0xa974, 0x005d5d5d, 0},
{W, 1, "", 0xa978, 0x005e5e5e, 0},
{W, 1, "", 0xa97c, 0x005f5f5f, 0},
{W, 1, "", 0xa980, 0x00606060, 0},
{W, 1, "", 0xa984, 0x00616161, 0},
{W, 1, "", 0xa988, 0x00626262, 0},
{W, 1, "", 0xa98c, 0x00636363, 0},
{W, 1, "", 0xa990, 0x00646464, 0},
{W, 1, "", 0xa994, 0x00656565, 0},
{W, 1, "", 0xa998, 0x00666666, 0},
{W, 1, "", 0xa99c, 0x00676767, 0},
{W, 1, "", 0xa9a0, 0x00686868, 0},
{W, 1, "", 0xa9a4, 0x00696969, 0},
{W, 1, "", 0xa9a8, 0x006a6a6a, 0},
{W, 1, "", 0xa9ac, 0x006b6b6b, 0},
{W, 1, "", 0xa9b0, 0x006c6c6c, 0},
{W, 1, "", 0xa9b4, 0x006d6d6d, 0},
{W, 1, "", 0xa9b8, 0x006e6e6e, 0},
{W, 1, "", 0xa9bc, 0x006f6f6f, 0},
{W, 1, "", 0xa9c0, 0x00707070, 0},
{W, 1, "", 0xa9c4, 0x00717171, 0},
{W, 1, "", 0xa9c8, 0x00727272, 0},
{W, 1, "", 0xa9cc, 0x00737373, 0},
{W, 1, "", 0xa9d0, 0x00747474, 0},
{W, 1, "", 0xa9d4, 0x00757575, 0},
{W, 1, "", 0xa9d8, 0x00767676, 0},
{W, 1, "", 0xa9dc, 0x00777777, 0},
{W, 1, "", 0xa9e0, 0x00787878, 0},
{W, 1, "", 0xa9e4, 0x00797979, 0},
{W, 1, "", 0xa9e8, 0x007a7a7a, 0},
{W, 1, "", 0xa9ec, 0x007b7b7b, 0},
{W, 1, "", 0xa9f0, 0x007c7c7c, 0},
{W, 1, "", 0xa9f4, 0x007d7d7d, 0},
{W, 1, "", 0xa9f8, 0x007e7e7e, 0},
{W, 1, "", 0xa9fc, 0x007f7f7f, 0},
{W, 1, "", 0xaa00, 0x00808080, 0},
{W, 1, "", 0xaa04, 0x00818181, 0},
{W, 1, "", 0xaa08, 0x00828282, 0},
{W, 1, "", 0xaa0c, 0x00838383, 0},
{W, 1, "", 0xaa10, 0x00848484, 0},
{W, 1, "", 0xaa14, 0x00858585, 0},
{W, 1, "", 0xaa18, 0x00868686, 0},
{W, 1, "", 0xaa1c, 0x00878787, 0},
{W, 1, "", 0xaa20, 0x00888888, 0},
{W, 1, "", 0xaa24, 0x00898989, 0},
{W, 1, "", 0xaa28, 0x008a8a8a, 0},
{W, 1, "", 0xaa2c, 0x008b8b8b, 0},
{W, 1, "", 0xaa30, 0x008c8c8c, 0},
{W, 1, "", 0xaa34, 0x008d8d8d, 0},
{W, 1, "", 0xaa38, 0x008e8e8e, 0},
{W, 1, "", 0xaa3c, 0x008f8f8f, 0},
{W, 1, "", 0xaa40, 0x00909090, 0},
{W, 1, "", 0xaa44, 0x00919191, 0},
{W, 1, "", 0xaa48, 0x00929292, 0},
{W, 1, "", 0xaa4c, 0x00939393, 0},
{W, 1, "", 0xaa50, 0x00949494, 0},
{W, 1, "", 0xaa54, 0x00959595, 0},
{W, 1, "", 0xaa58, 0x00969696, 0},
{W, 1, "", 0xaa5c, 0x00979797, 0},
{W, 1, "", 0xaa60, 0x00989898, 0},
{W, 1, "", 0xaa64, 0x00999999, 0},
{W, 1, "", 0xaa68, 0x009a9a9a, 0},
{W, 1, "", 0xaa6c, 0x009b9b9b, 0},
{W, 1, "", 0xaa70, 0x009c9c9c, 0},
{W, 1, "", 0xaa74, 0x009d9d9d, 0},
{W, 1, "", 0xaa78, 0x009e9e9e, 0},
{W, 1, "", 0xaa7c, 0x009f9f9f, 0},
{W, 1, "", 0xaa80, 0x00a0a0a0, 0},
{W, 1, "", 0xaa84, 0x00a1a1a1, 0},
{W, 1, "", 0xaa88, 0x00a2a2a2, 0},
{W, 1, "", 0xaa8c, 0x00a3a3a3, 0},
{W, 1, "", 0xaa90, 0x00a4a4a4, 0},
{W, 1, "", 0xaa94, 0x00a5a5a5, 0},
{W, 1, "", 0xaa98, 0x00a6a6a6, 0},
{W, 1, "", 0xaa9c, 0x00a7a7a7, 0},
{W, 1, "", 0xaaa0, 0x00a8a8a8, 0},
{W, 1, "", 0xaaa4, 0x00a9a9a9, 0},
{W, 1, "", 0xaaa8, 0x00aaaaaa, 0},
{W, 1, "", 0xaaac, 0x00ababab, 0},
{W, 1, "", 0xaab0, 0x00acacac, 0},
{W, 1, "", 0xaab4, 0x00adadad, 0},
{W, 1, "", 0xaab8, 0x00aeaeae, 0},
{W, 1, "", 0xaabc, 0x00afafaf, 0},
{W, 1, "", 0xaac0, 0x00b0b0b0, 0},
{W, 1, "", 0xaac4, 0x00b1b1b1, 0},
{W, 1, "", 0xaac8, 0x00b2b2b2, 0},
{W, 1, "", 0xaacc, 0x00b3b3b3, 0},
{W, 1, "", 0xaad0, 0x00b4b4b4, 0},
{W, 1, "", 0xaad4, 0x00b5b5b5, 0},
{W, 1, "", 0xaad8, 0x00b6b6b6, 0},
{W, 1, "", 0xaadc, 0x00b7b7b7, 0},
{W, 1, "", 0xaae0, 0x00b8b8b8, 0},
{W, 1, "", 0xaae4, 0x00b9b9b9, 0},
{W, 1, "", 0xaae8, 0x00bababa, 0},
{W, 1, "", 0xaaec, 0x00bbbbbb, 0},
{W, 1, "", 0xaaf0, 0x00bcbcbc, 0},
{W, 1, "", 0xaaf4, 0x00bdbdbd, 0},
{W, 1, "", 0xaaf8, 0x00bebebe, 0},
{W, 1, "", 0xaafc, 0x00bfbfbf, 0},
{W, 1, "", 0xab00, 0x00c0c0c0, 0},
{W, 1, "", 0xab04, 0x00c1c1c1, 0},
{W, 1, "", 0xab08, 0x00c2c2c2, 0},
{W, 1, "", 0xab0c, 0x00c3c3c3, 0},
{W, 1, "", 0xab10, 0x00c4c4c4, 0},
{W, 1, "", 0xab14, 0x00c5c5c5, 0},
{W, 1, "", 0xab18, 0x00c6c6c6, 0},
{W, 1, "", 0xab1c, 0x00c7c7c7, 0},
{W, 1, "", 0xab20, 0x00c8c8c8, 0},
{W, 1, "", 0xab24, 0x00c9c9c9, 0},
{W, 1, "", 0xab28, 0x00cacaca, 0},
{W, 1, "", 0xab2c, 0x00cbcbcb, 0},
{W, 1, "", 0xab30, 0x00cccccc, 0},
{W, 1, "", 0xab34, 0x00cdcdcd, 0},
{W, 1, "", 0xab38, 0x00cecece, 0},
{W, 1, "", 0xab3c, 0x00cfcfcf, 0},
{W, 1, "", 0xab40, 0x00d0d0d0, 0},
{W, 1, "", 0xab44, 0x00d1d1d1, 0},
{W, 1, "", 0xab48, 0x00d2d2d2, 0},
{W, 1, "", 0xab4c, 0x00d3d3d3, 0},
{W, 1, "", 0xab50, 0x00d4d4d4, 0},
{W, 1, "", 0xab54, 0x00d5d5d5, 0},
{W, 1, "", 0xab58, 0x00d6d6d6, 0},
{W, 1, "", 0xab5c, 0x00d7d7d7, 0},
{W, 1, "", 0xab60, 0x00d8d8d8, 0},
{W, 1, "", 0xab64, 0x00d9d9d9, 0},
{W, 1, "", 0xab68, 0x00dadada, 0},
{W, 1, "", 0xab6c, 0x00dbdbdb, 0},
{W, 1, "", 0xab70, 0x00dcdcdc, 0},
{W, 1, "", 0xab74, 0x00dddddd, 0},
{W, 1, "", 0xab78, 0x00dedede, 0},
{W, 1, "", 0xab7c, 0x00dfdfdf, 0},
{W, 1, "", 0xab80, 0x00e0e0e0, 0},
{W, 1, "", 0xab84, 0x00e1e1e1, 0},
{W, 1, "", 0xab88, 0x00e2e2e2, 0},
{W, 1, "", 0xab8c, 0x00e3e3e3, 0},
{W, 1, "", 0xab90, 0x00e4e4e4, 0},
{W, 1, "", 0xab94, 0x00e5e5e5, 0},
{W, 1, "", 0xab98, 0x00e6e6e6, 0},
{W, 1, "", 0xab9c, 0x00e7e7e7, 0},
{W, 1, "", 0xaba0, 0x00e8e8e8, 0},
{W, 1, "", 0xaba4, 0x00e9e9e9, 0},
{W, 1, "", 0xaba8, 0x00eaeaea, 0},
{W, 1, "", 0xabac, 0x00ebebeb, 0},
{W, 1, "", 0xabb0, 0x00ececec, 0},
{W, 1, "", 0xabb4, 0x00ededed, 0},
{W, 1, "", 0xabb8, 0x00eeeeee, 0},
{W, 1, "", 0xabbc, 0x00efefef, 0},
{W, 1, "", 0xabc0, 0x00f0f0f0, 0},
{W, 1, "", 0xabc4, 0x00f1f1f1, 0},
{W, 1, "", 0xabc8, 0x00f2f2f2, 0},
{W, 1, "", 0xabcc, 0x00f3f3f3, 0},
{W, 1, "", 0xabd0, 0x00f4f4f4, 0},
{W, 1, "", 0xabd4, 0x00f5f5f5, 0},
{W, 1, "", 0xabd8, 0x00f6f6f6, 0},
{W, 1, "", 0xabdc, 0x00f7f7f7, 0},
{W, 1, "", 0xabe0, 0x00f8f8f8, 0},
{W, 1, "", 0xabe4, 0x00f9f9f9, 0},
{W, 1, "", 0xabe8, 0x00fafafa, 0},
{W, 1, "", 0xabec, 0x00fbfbfb, 0},
{W, 1, "", 0xabf0, 0x00fcfcfc, 0},
{W, 1, "", 0xabf4, 0x00fdfdfd, 0},
{W, 1, "", 0xabf8, 0x00fefefe, 0},
{W, 1, "", 0xabfc, 0x00ffffff, 0},
{R, 1, "", LVDS,  LVDS_ON | PLL_P1_DIVIDE_BY_TWO | DISPLAY_RATE_SELECT_FPA1 |0xc0300300, 0},
{W, 1, "", LVDS,  LVDS_ON | PLL_P1_DIVIDE_BY_TWO | DISPLAY_RATE_SELECT_FPA1 |0xc0300300, 0},
{W, 1, "", PFIT_PGM_RATIOS, 0x00000000, 0},
{W, 1, "", PFIT_CONTROL, ( PFIT_PIPE_SHIFT &0x8)|0x00000008, 0},
{R, 1, "", PP_CONTROL, 0xabcd0000, 0},
{W, 1, "", PP_CONTROL,  POWER_TARGET_ON |0xabcd0001, 0},
{R, 1, "", PP_STATUS,  PP_READY |( PP_SEQUENCE_SHIFT &0x8)|0x4000000a, 0},
{R, 1, "", PP_STATUS,  PP_ON | PP_READY | PP_SEQUENCE_POWER_UP |( PP_SEQUENCE_SHIFT &0x8)|0xd000000a, 0},
{R, 1, "", BLC_PWM_CTL, 0x00000000, 0},
{M, 1, "i915:fixme:max PWM is zero", 0x0, 0x0, 0},
{R, 1, "", BLC_PWM_CTL, 0x00000000, 0},
{W, 1, "", BLC_PWM_CTL, 0x00000002, 0},
{R, 2, "", LVDS,  LVDS_ON | PLL_P1_DIVIDE_BY_TWO | DISPLAY_RATE_SELECT_FPA1 |0xc0300300, 0},
{R, 1, "", _FDI_TXB_CTL, 0x00000000, 0},
{R, 1, "", TV_CTL, 0x000c0000, 0},
{R, 1, "", LVDS,  LVDS_ON | PLL_P1_DIVIDE_BY_TWO | DISPLAY_RATE_SELECT_FPA1 |0xc0300300, 0},
{R, 1, "", _FDI_TXB_CTL, 0x00000000, 0},
{R, 1, "", TV_CTL, 0x000c0000, 0},
{R, 1, "", _PIPEACONF, 0x00000000, 0},
{R, 1, "", _PIPEBCONF, 0x80000000, 0},
{W, 1, "", _PALETTE_B, 0x00000000, 0},
{W, 1, "", _PALETTE_B+0x4, 0x00010101, 0},
{W, 1, "", _PALETTE_B+0x8, 0x00020202, 0},
{W, 1, "", _PALETTE_B+0xc, 0x00030303, 0},
{W, 1, "", _PALETTE_B+0x10, 0x00040404, 0},
{W, 1, "", _PALETTE_B+0x14, 0x00050505, 0},
{W, 1, "", _PALETTE_B+0x18, 0x00060606, 0},
{W, 1, "", _PALETTE_B+0x1c, 0x00070707, 0},
{W, 1, "", _PALETTE_B+0x20, 0x00080808, 0},
{W, 1, "", _PALETTE_B+0x24, 0x00090909, 0},
{W, 1, "", _PALETTE_B+0x28, 0x000a0a0a, 0},
{W, 1, "", _PALETTE_B+0x2c, 0x000b0b0b, 0},
{W, 1, "", _PALETTE_B+0x30, 0x000c0c0c, 0},
{W, 1, "", _PALETTE_B+0x34, 0x000d0d0d, 0},
{W, 1, "", _PALETTE_B+0x38, 0x000e0e0e, 0},
{W, 1, "", _PALETTE_B+0x3c, 0x000f0f0f, 0},
{W, 1, "", _PALETTE_B+0x40, 0x00101010, 0},
{W, 1, "", _PALETTE_B+0x44, 0x00111111, 0},
{W, 1, "", _PALETTE_B+0x48, 0x00121212, 0},
{W, 1, "", _PALETTE_B+0x4c, 0x00131313, 0},
{W, 1, "", _PALETTE_B+0x50, 0x00141414, 0},
{W, 1, "", _PALETTE_B+0x54, 0x00151515, 0},
{W, 1, "", _PALETTE_B+0x58, 0x00161616, 0},
{W, 1, "", _PALETTE_B+0x5c, 0x00171717, 0},
{W, 1, "", _PALETTE_B+0x60, 0x00181818, 0},
{W, 1, "", _PALETTE_B+0x64, 0x00191919, 0},
{W, 1, "", _PALETTE_B+0x68, 0x001a1a1a, 0},
{W, 1, "", _PALETTE_B+0x6c, 0x001b1b1b, 0},
{W, 1, "", _PALETTE_B+0x70, 0x001c1c1c, 0},
{W, 1, "", _PALETTE_B+0x74, 0x001d1d1d, 0},
{W, 1, "", _PALETTE_B+0x78, 0x001e1e1e, 0},
{W, 1, "", _PALETTE_B+0x7c, 0x001f1f1f, 0},
{W, 1, "", 0xa880, 0x00202020, 0},
{W, 1, "", 0xa884, 0x00212121, 0},
{W, 1, "", 0xa888, 0x00222222, 0},
{W, 1, "", 0xa88c, 0x00232323, 0},
{W, 1, "", 0xa890, 0x00242424, 0},
{W, 1, "", 0xa894, 0x00252525, 0},
{W, 1, "", 0xa898, 0x00262626, 0},
{W, 1, "", 0xa89c, 0x00272727, 0},
{W, 1, "", 0xa8a0, 0x00282828, 0},
{W, 1, "", 0xa8a4, 0x00292929, 0},
{W, 1, "", 0xa8a8, 0x002a2a2a, 0},
{W, 1, "", 0xa8ac, 0x002b2b2b, 0},
{W, 1, "", 0xa8b0, 0x002c2c2c, 0},
{W, 1, "", 0xa8b4, 0x002d2d2d, 0},
{W, 1, "", 0xa8b8, 0x002e2e2e, 0},
{W, 1, "", 0xa8bc, 0x002f2f2f, 0},
{W, 1, "", 0xa8c0, 0x00303030, 0},
{W, 1, "", 0xa8c4, 0x00313131, 0},
{W, 1, "", 0xa8c8, 0x00323232, 0},
{W, 1, "", 0xa8cc, 0x00333333, 0},
{W, 1, "", 0xa8d0, 0x00343434, 0},
{W, 1, "", 0xa8d4, 0x00353535, 0},
{W, 1, "", 0xa8d8, 0x00363636, 0},
{W, 1, "", 0xa8dc, 0x00373737, 0},
{W, 1, "", 0xa8e0, 0x00383838, 0},
{W, 1, "", 0xa8e4, 0x00393939, 0},
{W, 1, "", 0xa8e8, 0x003a3a3a, 0},
{W, 1, "", 0xa8ec, 0x003b3b3b, 0},
{W, 1, "", 0xa8f0, 0x003c3c3c, 0},
{W, 1, "", 0xa8f4, 0x003d3d3d, 0},
{W, 1, "", 0xa8f8, 0x003e3e3e, 0},
{W, 1, "", 0xa8fc, 0x003f3f3f, 0},
{W, 1, "", 0xa900, 0x00404040, 0},
{W, 1, "", 0xa904, 0x00414141, 0},
{W, 1, "", 0xa908, 0x00424242, 0},
{W, 1, "", 0xa90c, 0x00434343, 0},
{W, 1, "", 0xa910, 0x00444444, 0},
{W, 1, "", 0xa914, 0x00454545, 0},
{W, 1, "", 0xa918, 0x00464646, 0},
{W, 1, "", 0xa91c, 0x00474747, 0},
{W, 1, "", 0xa920, 0x00484848, 0},
{W, 1, "", 0xa924, 0x00494949, 0},
{W, 1, "", 0xa928, 0x004a4a4a, 0},
{W, 1, "", 0xa92c, 0x004b4b4b, 0},
{W, 1, "", 0xa930, 0x004c4c4c, 0},
{W, 1, "", 0xa934, 0x004d4d4d, 0},
{W, 1, "", 0xa938, 0x004e4e4e, 0},
{W, 1, "", 0xa93c, 0x004f4f4f, 0},
{W, 1, "", 0xa940, 0x00505050, 0},
{W, 1, "", 0xa944, 0x00515151, 0},
{W, 1, "", 0xa948, 0x00525252, 0},
{W, 1, "", 0xa94c, 0x00535353, 0},
{W, 1, "", 0xa950, 0x00545454, 0},
{W, 1, "", 0xa954, 0x00555555, 0},
{W, 1, "", 0xa958, 0x00565656, 0},
{W, 1, "", 0xa95c, 0x00575757, 0},
{W, 1, "", 0xa960, 0x00585858, 0},
{W, 1, "", 0xa964, 0x00595959, 0},
{W, 1, "", 0xa968, 0x005a5a5a, 0},
{W, 1, "", 0xa96c, 0x005b5b5b, 0},
{W, 1, "", 0xa970, 0x005c5c5c, 0},
{W, 1, "", 0xa974, 0x005d5d5d, 0},
{W, 1, "", 0xa978, 0x005e5e5e, 0},
{W, 1, "", 0xa97c, 0x005f5f5f, 0},
{W, 1, "", 0xa980, 0x00606060, 0},
{W, 1, "", 0xa984, 0x00616161, 0},
{W, 1, "", 0xa988, 0x00626262, 0},
{W, 1, "", 0xa98c, 0x00636363, 0},
{W, 1, "", 0xa990, 0x00646464, 0},
{W, 1, "", 0xa994, 0x00656565, 0},
{W, 1, "", 0xa998, 0x00666666, 0},
{W, 1, "", 0xa99c, 0x00676767, 0},
{W, 1, "", 0xa9a0, 0x00686868, 0},
{W, 1, "", 0xa9a4, 0x00696969, 0},
{W, 1, "", 0xa9a8, 0x006a6a6a, 0},
{W, 1, "", 0xa9ac, 0x006b6b6b, 0},
{W, 1, "", 0xa9b0, 0x006c6c6c, 0},
{W, 1, "", 0xa9b4, 0x006d6d6d, 0},
{W, 1, "", 0xa9b8, 0x006e6e6e, 0},
{W, 1, "", 0xa9bc, 0x006f6f6f, 0},
{W, 1, "", 0xa9c0, 0x00707070, 0},
{W, 1, "", 0xa9c4, 0x00717171, 0},
{W, 1, "", 0xa9c8, 0x00727272, 0},
{W, 1, "", 0xa9cc, 0x00737373, 0},
{W, 1, "", 0xa9d0, 0x00747474, 0},
{W, 1, "", 0xa9d4, 0x00757575, 0},
{W, 1, "", 0xa9d8, 0x00767676, 0},
{W, 1, "", 0xa9dc, 0x00777777, 0},
{W, 1, "", 0xa9e0, 0x00787878, 0},
{W, 1, "", 0xa9e4, 0x00797979, 0},
{W, 1, "", 0xa9e8, 0x007a7a7a, 0},
{W, 1, "", 0xa9ec, 0x007b7b7b, 0},
{W, 1, "", 0xa9f0, 0x007c7c7c, 0},
{W, 1, "", 0xa9f4, 0x007d7d7d, 0},
{W, 1, "", 0xa9f8, 0x007e7e7e, 0},
{W, 1, "", 0xa9fc, 0x007f7f7f, 0},
{W, 1, "", 0xaa00, 0x00808080, 0},
{W, 1, "", 0xaa04, 0x00818181, 0},
{W, 1, "", 0xaa08, 0x00828282, 0},
{W, 1, "", 0xaa0c, 0x00838383, 0},
{W, 1, "", 0xaa10, 0x00848484, 0},
{W, 1, "", 0xaa14, 0x00858585, 0},
{W, 1, "", 0xaa18, 0x00868686, 0},
{W, 1, "", 0xaa1c, 0x00878787, 0},
{W, 1, "", 0xaa20, 0x00888888, 0},
{W, 1, "", 0xaa24, 0x00898989, 0},
{W, 1, "", 0xaa28, 0x008a8a8a, 0},
{W, 1, "", 0xaa2c, 0x008b8b8b, 0},
{W, 1, "", 0xaa30, 0x008c8c8c, 0},
{W, 1, "", 0xaa34, 0x008d8d8d, 0},
{W, 1, "", 0xaa38, 0x008e8e8e, 0},
{W, 1, "", 0xaa3c, 0x008f8f8f, 0},
{W, 1, "", 0xaa40, 0x00909090, 0},
{W, 1, "", 0xaa44, 0x00919191, 0},
{W, 1, "", 0xaa48, 0x00929292, 0},
{W, 1, "", 0xaa4c, 0x00939393, 0},
{W, 1, "", 0xaa50, 0x00949494, 0},
{W, 1, "", 0xaa54, 0x00959595, 0},
{W, 1, "", 0xaa58, 0x00969696, 0},
{W, 1, "", 0xaa5c, 0x00979797, 0},
{W, 1, "", 0xaa60, 0x00989898, 0},
{W, 1, "", 0xaa64, 0x00999999, 0},
{W, 1, "", 0xaa68, 0x009a9a9a, 0},
{W, 1, "", 0xaa6c, 0x009b9b9b, 0},
{W, 1, "", 0xaa70, 0x009c9c9c, 0},
{W, 1, "", 0xaa74, 0x009d9d9d, 0},
{W, 1, "", 0xaa78, 0x009e9e9e, 0},
{W, 1, "", 0xaa7c, 0x009f9f9f, 0},
{W, 1, "", 0xaa80, 0x00a0a0a0, 0},
{W, 1, "", 0xaa84, 0x00a1a1a1, 0},
{W, 1, "", 0xaa88, 0x00a2a2a2, 0},
{W, 1, "", 0xaa8c, 0x00a3a3a3, 0},
{W, 1, "", 0xaa90, 0x00a4a4a4, 0},
{W, 1, "", 0xaa94, 0x00a5a5a5, 0},
{W, 1, "", 0xaa98, 0x00a6a6a6, 0},
{W, 1, "", 0xaa9c, 0x00a7a7a7, 0},
{W, 1, "", 0xaaa0, 0x00a8a8a8, 0},
{W, 1, "", 0xaaa4, 0x00a9a9a9, 0},
{W, 1, "", 0xaaa8, 0x00aaaaaa, 0},
{W, 1, "", 0xaaac, 0x00ababab, 0},
{W, 1, "", 0xaab0, 0x00acacac, 0},
{W, 1, "", 0xaab4, 0x00adadad, 0},
{W, 1, "", 0xaab8, 0x00aeaeae, 0},
{W, 1, "", 0xaabc, 0x00afafaf, 0},
{W, 1, "", 0xaac0, 0x00b0b0b0, 0},
{W, 1, "", 0xaac4, 0x00b1b1b1, 0},
{W, 1, "", 0xaac8, 0x00b2b2b2, 0},
{W, 1, "", 0xaacc, 0x00b3b3b3, 0},
{W, 1, "", 0xaad0, 0x00b4b4b4, 0},
{W, 1, "", 0xaad4, 0x00b5b5b5, 0},
{W, 1, "", 0xaad8, 0x00b6b6b6, 0},
{W, 1, "", 0xaadc, 0x00b7b7b7, 0},
{W, 1, "", 0xaae0, 0x00b8b8b8, 0},
{W, 1, "", 0xaae4, 0x00b9b9b9, 0},
{W, 1, "", 0xaae8, 0x00bababa, 0},
{W, 1, "", 0xaaec, 0x00bbbbbb, 0},
{W, 1, "", 0xaaf0, 0x00bcbcbc, 0},
{W, 1, "", 0xaaf4, 0x00bdbdbd, 0},
{W, 1, "", 0xaaf8, 0x00bebebe, 0},
{W, 1, "", 0xaafc, 0x00bfbfbf, 0},
{W, 1, "", 0xab00, 0x00c0c0c0, 0},
{W, 1, "", 0xab04, 0x00c1c1c1, 0},
{W, 1, "", 0xab08, 0x00c2c2c2, 0},
{W, 1, "", 0xab0c, 0x00c3c3c3, 0},
{W, 1, "", 0xab10, 0x00c4c4c4, 0},
{W, 1, "", 0xab14, 0x00c5c5c5, 0},
{W, 1, "", 0xab18, 0x00c6c6c6, 0},
{W, 1, "", 0xab1c, 0x00c7c7c7, 0},
{W, 1, "", 0xab20, 0x00c8c8c8, 0},
{W, 1, "", 0xab24, 0x00c9c9c9, 0},
{W, 1, "", 0xab28, 0x00cacaca, 0},
{W, 1, "", 0xab2c, 0x00cbcbcb, 0},
{W, 1, "", 0xab30, 0x00cccccc, 0},
{W, 1, "", 0xab34, 0x00cdcdcd, 0},
{W, 1, "", 0xab38, 0x00cecece, 0},
{W, 1, "", 0xab3c, 0x00cfcfcf, 0},
{W, 1, "", 0xab40, 0x00d0d0d0, 0},
{W, 1, "", 0xab44, 0x00d1d1d1, 0},
{W, 1, "", 0xab48, 0x00d2d2d2, 0},
{W, 1, "", 0xab4c, 0x00d3d3d3, 0},
{W, 1, "", 0xab50, 0x00d4d4d4, 0},
{W, 1, "", 0xab54, 0x00d5d5d5, 0},
{W, 1, "", 0xab58, 0x00d6d6d6, 0},
{W, 1, "", 0xab5c, 0x00d7d7d7, 0},
{W, 1, "", 0xab60, 0x00d8d8d8, 0},
{W, 1, "", 0xab64, 0x00d9d9d9, 0},
{W, 1, "", 0xab68, 0x00dadada, 0},
{W, 1, "", 0xab6c, 0x00dbdbdb, 0},
{W, 1, "", 0xab70, 0x00dcdcdc, 0},
{W, 1, "", 0xab74, 0x00dddddd, 0},
{W, 1, "", 0xab78, 0x00dedede, 0},
{W, 1, "", 0xab7c, 0x00dfdfdf, 0},
{W, 1, "", 0xab80, 0x00e0e0e0, 0},
{W, 1, "", 0xab84, 0x00e1e1e1, 0},
{W, 1, "", 0xab88, 0x00e2e2e2, 0},
{W, 1, "", 0xab8c, 0x00e3e3e3, 0},
{W, 1, "", 0xab90, 0x00e4e4e4, 0},
{W, 1, "", 0xab94, 0x00e5e5e5, 0},
{W, 1, "", 0xab98, 0x00e6e6e6, 0},
{W, 1, "", 0xab9c, 0x00e7e7e7, 0},
{W, 1, "", 0xaba0, 0x00e8e8e8, 0},
{W, 1, "", 0xaba4, 0x00e9e9e9, 0},
{W, 1, "", 0xaba8, 0x00eaeaea, 0},
{W, 1, "", 0xabac, 0x00ebebeb, 0},
{W, 1, "", 0xabb0, 0x00ececec, 0},
{W, 1, "", 0xabb4, 0x00ededed, 0},
{W, 1, "", 0xabb8, 0x00eeeeee, 0},
{W, 1, "", 0xabbc, 0x00efefef, 0},
{W, 1, "", 0xabc0, 0x00f0f0f0, 0},
{W, 1, "", 0xabc4, 0x00f1f1f1, 0},
{W, 1, "", 0xabc8, 0x00f2f2f2, 0},
{W, 1, "", 0xabcc, 0x00f3f3f3, 0},
{W, 1, "", 0xabd0, 0x00f4f4f4, 0},
{W, 1, "", 0xabd4, 0x00f5f5f5, 0},
{W, 1, "", 0xabd8, 0x00f6f6f6, 0},
{W, 1, "", 0xabdc, 0x00f7f7f7, 0},
{W, 1, "", 0xabe0, 0x00f8f8f8, 0},
{W, 1, "", 0xabe4, 0x00f9f9f9, 0},
{W, 1, "", 0xabe8, 0x00fafafa, 0},
{W, 1, "", 0xabec, 0x00fbfbfb, 0},
{W, 1, "", 0xabf0, 0x00fcfcfc, 0},
{W, 1, "", 0xabf4, 0x00fdfdfd, 0},
{W, 1, "", 0xabf8, 0x00fefefe, 0},
{W, 1, "", 0xabfc, 0x00ffffff, 0},
{W, 1, "", _PALETTE_B, 0x00000000, 0},
{W, 1, "", _PALETTE_B+0x4, 0x00010101, 0},
{W, 1, "", _PALETTE_B+0x8, 0x00020202, 0},
{W, 1, "", _PALETTE_B+0xc, 0x00030303, 0},
{W, 1, "", _PALETTE_B+0x10, 0x00040404, 0},
{W, 1, "", _PALETTE_B+0x14, 0x00050505, 0},
{W, 1, "", _PALETTE_B+0x18, 0x00060606, 0},
{W, 1, "", _PALETTE_B+0x1c, 0x00070707, 0},
{W, 1, "", _PALETTE_B+0x20, 0x00080808, 0},
{W, 1, "", _PALETTE_B+0x24, 0x00090909, 0},
{W, 1, "", _PALETTE_B+0x28, 0x000a0a0a, 0},
{W, 1, "", _PALETTE_B+0x2c, 0x000b0b0b, 0},
{W, 1, "", _PALETTE_B+0x30, 0x000c0c0c, 0},
{W, 1, "", _PALETTE_B+0x34, 0x000d0d0d, 0},
{W, 1, "", _PALETTE_B+0x38, 0x000e0e0e, 0},
{W, 1, "", _PALETTE_B+0x3c, 0x000f0f0f, 0},
{W, 1, "", _PALETTE_B+0x40, 0x00101010, 0},
{W, 1, "", _PALETTE_B+0x44, 0x00111111, 0},
{W, 1, "", _PALETTE_B+0x48, 0x00121212, 0},
{W, 1, "", _PALETTE_B+0x4c, 0x00131313, 0},
{W, 1, "", _PALETTE_B+0x50, 0x00141414, 0},
{W, 1, "", _PALETTE_B+0x54, 0x00151515, 0},
{W, 1, "", _PALETTE_B+0x58, 0x00161616, 0},
{W, 1, "", _PALETTE_B+0x5c, 0x00171717, 0},
{W, 1, "", _PALETTE_B+0x60, 0x00181818, 0},
{W, 1, "", _PALETTE_B+0x64, 0x00191919, 0},
{W, 1, "", _PALETTE_B+0x68, 0x001a1a1a, 0},
{W, 1, "", _PALETTE_B+0x6c, 0x001b1b1b, 0},
{W, 1, "", _PALETTE_B+0x70, 0x001c1c1c, 0},
{W, 1, "", _PALETTE_B+0x74, 0x001d1d1d, 0},
{W, 1, "", _PALETTE_B+0x78, 0x001e1e1e, 0},
{W, 1, "", _PALETTE_B+0x7c, 0x001f1f1f, 0},
{W, 1, "", 0xa880, 0x00202020, 0},
{W, 1, "", 0xa884, 0x00212121, 0},
{W, 1, "", 0xa888, 0x00222222, 0},
{W, 1, "", 0xa88c, 0x00232323, 0},
{W, 1, "", 0xa890, 0x00242424, 0},
{W, 1, "", 0xa894, 0x00252525, 0},
{W, 1, "", 0xa898, 0x00262626, 0},
{W, 1, "", 0xa89c, 0x00272727, 0},
{W, 1, "", 0xa8a0, 0x00282828, 0},
{W, 1, "", 0xa8a4, 0x00292929, 0},
{W, 1, "", 0xa8a8, 0x002a2a2a, 0},
{W, 1, "", 0xa8ac, 0x002b2b2b, 0},
{W, 1, "", 0xa8b0, 0x002c2c2c, 0},
{W, 1, "", 0xa8b4, 0x002d2d2d, 0},
{W, 1, "", 0xa8b8, 0x002e2e2e, 0},
{W, 1, "", 0xa8bc, 0x002f2f2f, 0},
{W, 1, "", 0xa8c0, 0x00303030, 0},
{W, 1, "", 0xa8c4, 0x00313131, 0},
{W, 1, "", 0xa8c8, 0x00323232, 0},
{W, 1, "", 0xa8cc, 0x00333333, 0},
{W, 1, "", 0xa8d0, 0x00343434, 0},
{W, 1, "", 0xa8d4, 0x00353535, 0},
{W, 1, "", 0xa8d8, 0x00363636, 0},
{W, 1, "", 0xa8dc, 0x00373737, 0},
{W, 1, "", 0xa8e0, 0x00383838, 0},
{W, 1, "", 0xa8e4, 0x00393939, 0},
{W, 1, "", 0xa8e8, 0x003a3a3a, 0},
{W, 1, "", 0xa8ec, 0x003b3b3b, 0},
{W, 1, "", 0xa8f0, 0x003c3c3c, 0},
{W, 1, "", 0xa8f4, 0x003d3d3d, 0},
{W, 1, "", 0xa8f8, 0x003e3e3e, 0},
{W, 1, "", 0xa8fc, 0x003f3f3f, 0},
{W, 1, "", 0xa900, 0x00404040, 0},
{W, 1, "", 0xa904, 0x00414141, 0},
{W, 1, "", 0xa908, 0x00424242, 0},
{W, 1, "", 0xa90c, 0x00434343, 0},
{W, 1, "", 0xa910, 0x00444444, 0},
{W, 1, "", 0xa914, 0x00454545, 0},
{W, 1, "", 0xa918, 0x00464646, 0},
{W, 1, "", 0xa91c, 0x00474747, 0},
{W, 1, "", 0xa920, 0x00484848, 0},
{W, 1, "", 0xa924, 0x00494949, 0},
{W, 1, "", 0xa928, 0x004a4a4a, 0},
{W, 1, "", 0xa92c, 0x004b4b4b, 0},
{W, 1, "", 0xa930, 0x004c4c4c, 0},
{W, 1, "", 0xa934, 0x004d4d4d, 0},
{W, 1, "", 0xa938, 0x004e4e4e, 0},
{W, 1, "", 0xa93c, 0x004f4f4f, 0},
{W, 1, "", 0xa940, 0x00505050, 0},
{W, 1, "", 0xa944, 0x00515151, 0},
{W, 1, "", 0xa948, 0x00525252, 0},
{W, 1, "", 0xa94c, 0x00535353, 0},
{W, 1, "", 0xa950, 0x00545454, 0},
{W, 1, "", 0xa954, 0x00555555, 0},
{W, 1, "", 0xa958, 0x00565656, 0},
{W, 1, "", 0xa95c, 0x00575757, 0},
{W, 1, "", 0xa960, 0x00585858, 0},
{W, 1, "", 0xa964, 0x00595959, 0},
{W, 1, "", 0xa968, 0x005a5a5a, 0},
{W, 1, "", 0xa96c, 0x005b5b5b, 0},
{W, 1, "", 0xa970, 0x005c5c5c, 0},
{W, 1, "", 0xa974, 0x005d5d5d, 0},
{W, 1, "", 0xa978, 0x005e5e5e, 0},
{W, 1, "", 0xa97c, 0x005f5f5f, 0},
{W, 1, "", 0xa980, 0x00606060, 0},
{W, 1, "", 0xa984, 0x00616161, 0},
{W, 1, "", 0xa988, 0x00626262, 0},
{W, 1, "", 0xa98c, 0x00636363, 0},
{W, 1, "", 0xa990, 0x00646464, 0},
{W, 1, "", 0xa994, 0x00656565, 0},
{W, 1, "", 0xa998, 0x00666666, 0},
{W, 1, "", 0xa99c, 0x00676767, 0},
{W, 1, "", 0xa9a0, 0x00686868, 0},
{W, 1, "", 0xa9a4, 0x00696969, 0},
{W, 1, "", 0xa9a8, 0x006a6a6a, 0},
{W, 1, "", 0xa9ac, 0x006b6b6b, 0},
{W, 1, "", 0xa9b0, 0x006c6c6c, 0},
{W, 1, "", 0xa9b4, 0x006d6d6d, 0},
{W, 1, "", 0xa9b8, 0x006e6e6e, 0},
{W, 1, "", 0xa9bc, 0x006f6f6f, 0},
{W, 1, "", 0xa9c0, 0x00707070, 0},
{W, 1, "", 0xa9c4, 0x00717171, 0},
{W, 1, "", 0xa9c8, 0x00727272, 0},
{W, 1, "", 0xa9cc, 0x00737373, 0},
{W, 1, "", 0xa9d0, 0x00747474, 0},
{W, 1, "", 0xa9d4, 0x00757575, 0},
{W, 1, "", 0xa9d8, 0x00767676, 0},
{W, 1, "", 0xa9dc, 0x00777777, 0},
{W, 1, "", 0xa9e0, 0x00787878, 0},
{W, 1, "", 0xa9e4, 0x00797979, 0},
{W, 1, "", 0xa9e8, 0x007a7a7a, 0},
{W, 1, "", 0xa9ec, 0x007b7b7b, 0},
{W, 1, "", 0xa9f0, 0x007c7c7c, 0},
{W, 1, "", 0xa9f4, 0x007d7d7d, 0},
{W, 1, "", 0xa9f8, 0x007e7e7e, 0},
{W, 1, "", 0xa9fc, 0x007f7f7f, 0},
{W, 1, "", 0xaa00, 0x00808080, 0},
{W, 1, "", 0xaa04, 0x00818181, 0},
{W, 1, "", 0xaa08, 0x00828282, 0},
{W, 1, "", 0xaa0c, 0x00838383, 0},
{W, 1, "", 0xaa10, 0x00848484, 0},
{W, 1, "", 0xaa14, 0x00858585, 0},
{W, 1, "", 0xaa18, 0x00868686, 0},
{W, 1, "", 0xaa1c, 0x00878787, 0},
{W, 1, "", 0xaa20, 0x00888888, 0},
{W, 1, "", 0xaa24, 0x00898989, 0},
{W, 1, "", 0xaa28, 0x008a8a8a, 0},
{W, 1, "", 0xaa2c, 0x008b8b8b, 0},
{W, 1, "", 0xaa30, 0x008c8c8c, 0},
{W, 1, "", 0xaa34, 0x008d8d8d, 0},
{W, 1, "", 0xaa38, 0x008e8e8e, 0},
{W, 1, "", 0xaa3c, 0x008f8f8f, 0},
{W, 1, "", 0xaa40, 0x00909090, 0},
{W, 1, "", 0xaa44, 0x00919191, 0},
{W, 1, "", 0xaa48, 0x00929292, 0},
{W, 1, "", 0xaa4c, 0x00939393, 0},
{W, 1, "", 0xaa50, 0x00949494, 0},
{W, 1, "", 0xaa54, 0x00959595, 0},
{W, 1, "", 0xaa58, 0x00969696, 0},
{W, 1, "", 0xaa5c, 0x00979797, 0},
{W, 1, "", 0xaa60, 0x00989898, 0},
{W, 1, "", 0xaa64, 0x00999999, 0},
{W, 1, "", 0xaa68, 0x009a9a9a, 0},
{W, 1, "", 0xaa6c, 0x009b9b9b, 0},
{W, 1, "", 0xaa70, 0x009c9c9c, 0},
{W, 1, "", 0xaa74, 0x009d9d9d, 0},
{W, 1, "", 0xaa78, 0x009e9e9e, 0},
{W, 1, "", 0xaa7c, 0x009f9f9f, 0},
{W, 1, "", 0xaa80, 0x00a0a0a0, 0},
{W, 1, "", 0xaa84, 0x00a1a1a1, 0},
{W, 1, "", 0xaa88, 0x00a2a2a2, 0},
{W, 1, "", 0xaa8c, 0x00a3a3a3, 0},
{W, 1, "", 0xaa90, 0x00a4a4a4, 0},
{W, 1, "", 0xaa94, 0x00a5a5a5, 0},
{W, 1, "", 0xaa98, 0x00a6a6a6, 0},
{W, 1, "", 0xaa9c, 0x00a7a7a7, 0},
{W, 1, "", 0xaaa0, 0x00a8a8a8, 0},
{W, 1, "", 0xaaa4, 0x00a9a9a9, 0},
{W, 1, "", 0xaaa8, 0x00aaaaaa, 0},
{W, 1, "", 0xaaac, 0x00ababab, 0},
{W, 1, "", 0xaab0, 0x00acacac, 0},
{W, 1, "", 0xaab4, 0x00adadad, 0},
{W, 1, "", 0xaab8, 0x00aeaeae, 0},
{W, 1, "", 0xaabc, 0x00afafaf, 0},
{W, 1, "", 0xaac0, 0x00b0b0b0, 0},
{W, 1, "", 0xaac4, 0x00b1b1b1, 0},
{W, 1, "", 0xaac8, 0x00b2b2b2, 0},
{W, 1, "", 0xaacc, 0x00b3b3b3, 0},
{W, 1, "", 0xaad0, 0x00b4b4b4, 0},
{W, 1, "", 0xaad4, 0x00b5b5b5, 0},
{W, 1, "", 0xaad8, 0x00b6b6b6, 0},
{W, 1, "", 0xaadc, 0x00b7b7b7, 0},
{W, 1, "", 0xaae0, 0x00b8b8b8, 0},
{W, 1, "", 0xaae4, 0x00b9b9b9, 0},
{W, 1, "", 0xaae8, 0x00bababa, 0},
{W, 1, "", 0xaaec, 0x00bbbbbb, 0},
{W, 1, "", 0xaaf0, 0x00bcbcbc, 0},
{W, 1, "", 0xaaf4, 0x00bdbdbd, 0},
{W, 1, "", 0xaaf8, 0x00bebebe, 0},
{W, 1, "", 0xaafc, 0x00bfbfbf, 0},
{W, 1, "", 0xab00, 0x00c0c0c0, 0},
{W, 1, "", 0xab04, 0x00c1c1c1, 0},
{W, 1, "", 0xab08, 0x00c2c2c2, 0},
{W, 1, "", 0xab0c, 0x00c3c3c3, 0},
{W, 1, "", 0xab10, 0x00c4c4c4, 0},
{W, 1, "", 0xab14, 0x00c5c5c5, 0},
{W, 1, "", 0xab18, 0x00c6c6c6, 0},
{W, 1, "", 0xab1c, 0x00c7c7c7, 0},
{W, 1, "", 0xab20, 0x00c8c8c8, 0},
{W, 1, "", 0xab24, 0x00c9c9c9, 0},
{W, 1, "", 0xab28, 0x00cacaca, 0},
{W, 1, "", 0xab2c, 0x00cbcbcb, 0},
{W, 1, "", 0xab30, 0x00cccccc, 0},
{W, 1, "", 0xab34, 0x00cdcdcd, 0},
{W, 1, "", 0xab38, 0x00cecece, 0},
{W, 1, "", 0xab3c, 0x00cfcfcf, 0},
{W, 1, "", 0xab40, 0x00d0d0d0, 0},
{W, 1, "", 0xab44, 0x00d1d1d1, 0},
{W, 1, "", 0xab48, 0x00d2d2d2, 0},
{W, 1, "", 0xab4c, 0x00d3d3d3, 0},
{W, 1, "", 0xab50, 0x00d4d4d4, 0},
{W, 1, "", 0xab54, 0x00d5d5d5, 0},
{W, 1, "", 0xab58, 0x00d6d6d6, 0},
{W, 1, "", 0xab5c, 0x00d7d7d7, 0},
{W, 1, "", 0xab60, 0x00d8d8d8, 0},
{W, 1, "", 0xab64, 0x00d9d9d9, 0},
{W, 1, "", 0xab68, 0x00dadada, 0},
{W, 1, "", 0xab6c, 0x00dbdbdb, 0},
{W, 1, "", 0xab70, 0x00dcdcdc, 0},
{W, 1, "", 0xab74, 0x00dddddd, 0},
{W, 1, "", 0xab78, 0x00dedede, 0},
{W, 1, "", 0xab7c, 0x00dfdfdf, 0},
{W, 1, "", 0xab80, 0x00e0e0e0, 0},
{W, 1, "", 0xab84, 0x00e1e1e1, 0},
{W, 1, "", 0xab88, 0x00e2e2e2, 0},
{W, 1, "", 0xab8c, 0x00e3e3e3, 0},
{W, 1, "", 0xab90, 0x00e4e4e4, 0},
{W, 1, "", 0xab94, 0x00e5e5e5, 0},
{W, 1, "", 0xab98, 0x00e6e6e6, 0},
{W, 1, "", 0xab9c, 0x00e7e7e7, 0},
{W, 1, "", 0xaba0, 0x00e8e8e8, 0},
{W, 1, "", 0xaba4, 0x00e9e9e9, 0},
{W, 1, "", 0xaba8, 0x00eaeaea, 0},
{W, 1, "", 0xabac, 0x00ebebeb, 0},
{W, 1, "", 0xabb0, 0x00ececec, 0},
{W, 1, "", 0xabb4, 0x00ededed, 0},
{W, 1, "", 0xabb8, 0x00eeeeee, 0},
{W, 1, "", 0xabbc, 0x00efefef, 0},
{W, 1, "", 0xabc0, 0x00f0f0f0, 0},
{W, 1, "", 0xabc4, 0x00f1f1f1, 0},
{W, 1, "", 0xabc8, 0x00f2f2f2, 0},
{W, 1, "", 0xabcc, 0x00f3f3f3, 0},
{W, 1, "", 0xabd0, 0x00f4f4f4, 0},
{W, 1, "", 0xabd4, 0x00f5f5f5, 0},
{W, 1, "", 0xabd8, 0x00f6f6f6, 0},
{W, 1, "", 0xabdc, 0x00f7f7f7, 0},
{W, 1, "", 0xabe0, 0x00f8f8f8, 0},
{W, 1, "", 0xabe4, 0x00f9f9f9, 0},
{W, 1, "", 0xabe8, 0x00fafafa, 0},
{W, 1, "", 0xabec, 0x00fbfbfb, 0},
{W, 1, "", 0xabf0, 0x00fcfcfc, 0},
{W, 1, "", 0xabf4, 0x00fdfdfd, 0},
{W, 1, "", 0xabf8, 0x00fefefe, 0},
{W, 1, "", 0xabfc, 0x00ffffff, 0},
{M, 1, "Console:switching to colour frame buffer device 128x48", 0x0, 0x0, 0},
{W, 1, "", _PALETTE_B, 0x00000000, 0},
{W, 1, "", _PALETTE_B+0x4, 0x00010101, 0},
{W, 1, "", _PALETTE_B+0x8, 0x00020202, 0},
{W, 1, "", _PALETTE_B+0xc, 0x00030303, 0},
{W, 1, "", _PALETTE_B+0x10, 0x00040404, 0},
{W, 1, "", _PALETTE_B+0x14, 0x00050505, 0},
{W, 1, "", _PALETTE_B+0x18, 0x00060606, 0},
{W, 1, "", _PALETTE_B+0x1c, 0x00070707, 0},
{W, 1, "", _PALETTE_B+0x20, 0x00080808, 0},
{W, 1, "", _PALETTE_B+0x24, 0x00090909, 0},
{W, 1, "", _PALETTE_B+0x28, 0x000a0a0a, 0},
{W, 1, "", _PALETTE_B+0x2c, 0x000b0b0b, 0},
{W, 1, "", _PALETTE_B+0x30, 0x000c0c0c, 0},
{W, 1, "", _PALETTE_B+0x34, 0x000d0d0d, 0},
{W, 1, "", _PALETTE_B+0x38, 0x000e0e0e, 0},
{W, 1, "", _PALETTE_B+0x3c, 0x000f0f0f, 0},
{W, 1, "", _PALETTE_B+0x40, 0x00101010, 0},
{W, 1, "", _PALETTE_B+0x44, 0x00111111, 0},
{W, 1, "", _PALETTE_B+0x48, 0x00121212, 0},
{W, 1, "", _PALETTE_B+0x4c, 0x00131313, 0},
{W, 1, "", _PALETTE_B+0x50, 0x00141414, 0},
{W, 1, "", _PALETTE_B+0x54, 0x00151515, 0},
{W, 1, "", _PALETTE_B+0x58, 0x00161616, 0},
{W, 1, "", _PALETTE_B+0x5c, 0x00171717, 0},
{W, 1, "", _PALETTE_B+0x60, 0x00181818, 0},
{W, 1, "", _PALETTE_B+0x64, 0x00191919, 0},
{W, 1, "", _PALETTE_B+0x68, 0x001a1a1a, 0},
{W, 1, "", _PALETTE_B+0x6c, 0x001b1b1b, 0},
{W, 1, "", _PALETTE_B+0x70, 0x001c1c1c, 0},
{W, 1, "", _PALETTE_B+0x74, 0x001d1d1d, 0},
{W, 1, "", _PALETTE_B+0x78, 0x001e1e1e, 0},
{W, 1, "", _PALETTE_B+0x7c, 0x001f1f1f, 0},
{W, 1, "", 0xa880, 0x00202020, 0},
{W, 1, "", 0xa884, 0x00212121, 0},
{W, 1, "", 0xa888, 0x00222222, 0},
{W, 1, "", 0xa88c, 0x00232323, 0},
{W, 1, "", 0xa890, 0x00242424, 0},
{W, 1, "", 0xa894, 0x00252525, 0},
{W, 1, "", 0xa898, 0x00262626, 0},
{W, 1, "", 0xa89c, 0x00272727, 0},
{W, 1, "", 0xa8a0, 0x00282828, 0},
{W, 1, "", 0xa8a4, 0x00292929, 0},
{W, 1, "", 0xa8a8, 0x002a2a2a, 0},
{W, 1, "", 0xa8ac, 0x002b2b2b, 0},
{W, 1, "", 0xa8b0, 0x002c2c2c, 0},
{W, 1, "", 0xa8b4, 0x002d2d2d, 0},
{W, 1, "", 0xa8b8, 0x002e2e2e, 0},
{W, 1, "", 0xa8bc, 0x002f2f2f, 0},
{W, 1, "", 0xa8c0, 0x00303030, 0},
{W, 1, "", 0xa8c4, 0x00313131, 0},
{W, 1, "", 0xa8c8, 0x00323232, 0},
{W, 1, "", 0xa8cc, 0x00333333, 0},
{W, 1, "", 0xa8d0, 0x00343434, 0},
{W, 1, "", 0xa8d4, 0x00353535, 0},
{W, 1, "", 0xa8d8, 0x00363636, 0},
{W, 1, "", 0xa8dc, 0x00373737, 0},
{W, 1, "", 0xa8e0, 0x00383838, 0},
{W, 1, "", 0xa8e4, 0x00393939, 0},
{W, 1, "", 0xa8e8, 0x003a3a3a, 0},
{W, 1, "", 0xa8ec, 0x003b3b3b, 0},
{W, 1, "", 0xa8f0, 0x003c3c3c, 0},
{W, 1, "", 0xa8f4, 0x003d3d3d, 0},
{W, 1, "", 0xa8f8, 0x003e3e3e, 0},
{W, 1, "", 0xa8fc, 0x003f3f3f, 0},
{W, 1, "", 0xa900, 0x00404040, 0},
{W, 1, "", 0xa904, 0x00414141, 0},
{W, 1, "", 0xa908, 0x00424242, 0},
{W, 1, "", 0xa90c, 0x00434343, 0},
{W, 1, "", 0xa910, 0x00444444, 0},
{W, 1, "", 0xa914, 0x00454545, 0},
{W, 1, "", 0xa918, 0x00464646, 0},
{W, 1, "", 0xa91c, 0x00474747, 0},
{W, 1, "", 0xa920, 0x00484848, 0},
{W, 1, "", 0xa924, 0x00494949, 0},
{W, 1, "", 0xa928, 0x004a4a4a, 0},
{W, 1, "", 0xa92c, 0x004b4b4b, 0},
{W, 1, "", 0xa930, 0x004c4c4c, 0},
{W, 1, "", 0xa934, 0x004d4d4d, 0},
{W, 1, "", 0xa938, 0x004e4e4e, 0},
{W, 1, "", 0xa93c, 0x004f4f4f, 0},
{W, 1, "", 0xa940, 0x00505050, 0},
{W, 1, "", 0xa944, 0x00515151, 0},
{W, 1, "", 0xa948, 0x00525252, 0},
{W, 1, "", 0xa94c, 0x00535353, 0},
{W, 1, "", 0xa950, 0x00545454, 0},
{W, 1, "", 0xa954, 0x00555555, 0},
{W, 1, "", 0xa958, 0x00565656, 0},
{W, 1, "", 0xa95c, 0x00575757, 0},
{W, 1, "", 0xa960, 0x00585858, 0},
{W, 1, "", 0xa964, 0x00595959, 0},
{W, 1, "", 0xa968, 0x005a5a5a, 0},
{W, 1, "", 0xa96c, 0x005b5b5b, 0},
{W, 1, "", 0xa970, 0x005c5c5c, 0},
{W, 1, "", 0xa974, 0x005d5d5d, 0},
{W, 1, "", 0xa978, 0x005e5e5e, 0},
{W, 1, "", 0xa97c, 0x005f5f5f, 0},
{W, 1, "", 0xa980, 0x00606060, 0},
{W, 1, "", 0xa984, 0x00616161, 0},
{W, 1, "", 0xa988, 0x00626262, 0},
{W, 1, "", 0xa98c, 0x00636363, 0},
{W, 1, "", 0xa990, 0x00646464, 0},
{W, 1, "", 0xa994, 0x00656565, 0},
{W, 1, "", 0xa998, 0x00666666, 0},
{W, 1, "", 0xa99c, 0x00676767, 0},
{W, 1, "", 0xa9a0, 0x00686868, 0},
{W, 1, "", 0xa9a4, 0x00696969, 0},
{W, 1, "", 0xa9a8, 0x006a6a6a, 0},
{W, 1, "", 0xa9ac, 0x006b6b6b, 0},
{W, 1, "", 0xa9b0, 0x006c6c6c, 0},
{W, 1, "", 0xa9b4, 0x006d6d6d, 0},
{W, 1, "", 0xa9b8, 0x006e6e6e, 0},
{W, 1, "", 0xa9bc, 0x006f6f6f, 0},
{W, 1, "", 0xa9c0, 0x00707070, 0},
{W, 1, "", 0xa9c4, 0x00717171, 0},
{W, 1, "", 0xa9c8, 0x00727272, 0},
{W, 1, "", 0xa9cc, 0x00737373, 0},
{W, 1, "", 0xa9d0, 0x00747474, 0},
{W, 1, "", 0xa9d4, 0x00757575, 0},
{W, 1, "", 0xa9d8, 0x00767676, 0},
{W, 1, "", 0xa9dc, 0x00777777, 0},
{W, 1, "", 0xa9e0, 0x00787878, 0},
{W, 1, "", 0xa9e4, 0x00797979, 0},
{W, 1, "", 0xa9e8, 0x007a7a7a, 0},
{W, 1, "", 0xa9ec, 0x007b7b7b, 0},
{W, 1, "", 0xa9f0, 0x007c7c7c, 0},
{W, 1, "", 0xa9f4, 0x007d7d7d, 0},
{W, 1, "", 0xa9f8, 0x007e7e7e, 0},
{W, 1, "", 0xa9fc, 0x007f7f7f, 0},
{W, 1, "", 0xaa00, 0x00808080, 0},
{W, 1, "", 0xaa04, 0x00818181, 0},
{W, 1, "", 0xaa08, 0x00828282, 0},
{W, 1, "", 0xaa0c, 0x00838383, 0},
{W, 1, "", 0xaa10, 0x00848484, 0},
{W, 1, "", 0xaa14, 0x00858585, 0},
{W, 1, "", 0xaa18, 0x00868686, 0},
{W, 1, "", 0xaa1c, 0x00878787, 0},
{W, 1, "", 0xaa20, 0x00888888, 0},
{W, 1, "", 0xaa24, 0x00898989, 0},
{W, 1, "", 0xaa28, 0x008a8a8a, 0},
{W, 1, "", 0xaa2c, 0x008b8b8b, 0},
{W, 1, "", 0xaa30, 0x008c8c8c, 0},
{W, 1, "", 0xaa34, 0x008d8d8d, 0},
{W, 1, "", 0xaa38, 0x008e8e8e, 0},
{W, 1, "", 0xaa3c, 0x008f8f8f, 0},
{W, 1, "", 0xaa40, 0x00909090, 0},
{W, 1, "", 0xaa44, 0x00919191, 0},
{W, 1, "", 0xaa48, 0x00929292, 0},
{W, 1, "", 0xaa4c, 0x00939393, 0},
{W, 1, "", 0xaa50, 0x00949494, 0},
{W, 1, "", 0xaa54, 0x00959595, 0},
{W, 1, "", 0xaa58, 0x00969696, 0},
{W, 1, "", 0xaa5c, 0x00979797, 0},
{W, 1, "", 0xaa60, 0x00989898, 0},
{W, 1, "", 0xaa64, 0x00999999, 0},
{W, 1, "", 0xaa68, 0x009a9a9a, 0},
{W, 1, "", 0xaa6c, 0x009b9b9b, 0},
{W, 1, "", 0xaa70, 0x009c9c9c, 0},
{W, 1, "", 0xaa74, 0x009d9d9d, 0},
{W, 1, "", 0xaa78, 0x009e9e9e, 0},
{W, 1, "", 0xaa7c, 0x009f9f9f, 0},
{W, 1, "", 0xaa80, 0x00a0a0a0, 0},
{W, 1, "", 0xaa84, 0x00a1a1a1, 0},
{W, 1, "", 0xaa88, 0x00a2a2a2, 0},
{W, 1, "", 0xaa8c, 0x00a3a3a3, 0},
{W, 1, "", 0xaa90, 0x00a4a4a4, 0},
{W, 1, "", 0xaa94, 0x00a5a5a5, 0},
{W, 1, "", 0xaa98, 0x00a6a6a6, 0},
{W, 1, "", 0xaa9c, 0x00a7a7a7, 0},
{W, 1, "", 0xaaa0, 0x00a8a8a8, 0},
{W, 1, "", 0xaaa4, 0x00a9a9a9, 0},
{W, 1, "", 0xaaa8, 0x00aaaaaa, 0},
{W, 1, "", 0xaaac, 0x00ababab, 0},
{W, 1, "", 0xaab0, 0x00acacac, 0},
{W, 1, "", 0xaab4, 0x00adadad, 0},
{W, 1, "", 0xaab8, 0x00aeaeae, 0},
{W, 1, "", 0xaabc, 0x00afafaf, 0},
{W, 1, "", 0xaac0, 0x00b0b0b0, 0},
{W, 1, "", 0xaac4, 0x00b1b1b1, 0},
{W, 1, "", 0xaac8, 0x00b2b2b2, 0},
{W, 1, "", 0xaacc, 0x00b3b3b3, 0},
{W, 1, "", 0xaad0, 0x00b4b4b4, 0},
{W, 1, "", 0xaad4, 0x00b5b5b5, 0},
{W, 1, "", 0xaad8, 0x00b6b6b6, 0},
{W, 1, "", 0xaadc, 0x00b7b7b7, 0},
{W, 1, "", 0xaae0, 0x00b8b8b8, 0},
{W, 1, "", 0xaae4, 0x00b9b9b9, 0},
{W, 1, "", 0xaae8, 0x00bababa, 0},
{W, 1, "", 0xaaec, 0x00bbbbbb, 0},
{W, 1, "", 0xaaf0, 0x00bcbcbc, 0},
{W, 1, "", 0xaaf4, 0x00bdbdbd, 0},
{W, 1, "", 0xaaf8, 0x00bebebe, 0},
{W, 1, "", 0xaafc, 0x00bfbfbf, 0},
{W, 1, "", 0xab00, 0x00c0c0c0, 0},
{W, 1, "", 0xab04, 0x00c1c1c1, 0},
{W, 1, "", 0xab08, 0x00c2c2c2, 0},
{W, 1, "", 0xab0c, 0x00c3c3c3, 0},
{W, 1, "", 0xab10, 0x00c4c4c4, 0},
{W, 1, "", 0xab14, 0x00c5c5c5, 0},
{W, 1, "", 0xab18, 0x00c6c6c6, 0},
{W, 1, "", 0xab1c, 0x00c7c7c7, 0},
{W, 1, "", 0xab20, 0x00c8c8c8, 0},
{W, 1, "", 0xab24, 0x00c9c9c9, 0},
{W, 1, "", 0xab28, 0x00cacaca, 0},
{W, 1, "", 0xab2c, 0x00cbcbcb, 0},
{W, 1, "", 0xab30, 0x00cccccc, 0},
{W, 1, "", 0xab34, 0x00cdcdcd, 0},
{W, 1, "", 0xab38, 0x00cecece, 0},
{W, 1, "", 0xab3c, 0x00cfcfcf, 0},
{W, 1, "", 0xab40, 0x00d0d0d0, 0},
{W, 1, "", 0xab44, 0x00d1d1d1, 0},
{W, 1, "", 0xab48, 0x00d2d2d2, 0},
{W, 1, "", 0xab4c, 0x00d3d3d3, 0},
{W, 1, "", 0xab50, 0x00d4d4d4, 0},
{W, 1, "", 0xab54, 0x00d5d5d5, 0},
{W, 1, "", 0xab58, 0x00d6d6d6, 0},
{W, 1, "", 0xab5c, 0x00d7d7d7, 0},
{W, 1, "", 0xab60, 0x00d8d8d8, 0},
{W, 1, "", 0xab64, 0x00d9d9d9, 0},
{W, 1, "", 0xab68, 0x00dadada, 0},
{W, 1, "", 0xab6c, 0x00dbdbdb, 0},
{W, 1, "", 0xab70, 0x00dcdcdc, 0},
{W, 1, "", 0xab74, 0x00dddddd, 0},
{W, 1, "", 0xab78, 0x00dedede, 0},
{W, 1, "", 0xab7c, 0x00dfdfdf, 0},
{W, 1, "", 0xab80, 0x00e0e0e0, 0},
{W, 1, "", 0xab84, 0x00e1e1e1, 0},
{W, 1, "", 0xab88, 0x00e2e2e2, 0},
{W, 1, "", 0xab8c, 0x00e3e3e3, 0},
{W, 1, "", 0xab90, 0x00e4e4e4, 0},
{W, 1, "", 0xab94, 0x00e5e5e5, 0},
{W, 1, "", 0xab98, 0x00e6e6e6, 0},
{W, 1, "", 0xab9c, 0x00e7e7e7, 0},
{W, 1, "", 0xaba0, 0x00e8e8e8, 0},
{W, 1, "", 0xaba4, 0x00e9e9e9, 0},
{W, 1, "", 0xaba8, 0x00eaeaea, 0},
{W, 1, "", 0xabac, 0x00ebebeb, 0},
{W, 1, "", 0xabb0, 0x00ececec, 0},
{W, 1, "", 0xabb4, 0x00ededed, 0},
{W, 1, "", 0xabb8, 0x00eeeeee, 0},
{W, 1, "", 0xabbc, 0x00efefef, 0},
{W, 1, "", 0xabc0, 0x00f0f0f0, 0},
{W, 1, "", 0xabc4, 0x00f1f1f1, 0},
{W, 1, "", 0xabc8, 0x00f2f2f2, 0},
{W, 1, "", 0xabcc, 0x00f3f3f3, 0},
{W, 1, "", 0xabd0, 0x00f4f4f4, 0},
{W, 1, "", 0xabd4, 0x00f5f5f5, 0},
{W, 1, "", 0xabd8, 0x00f6f6f6, 0},
{W, 1, "", 0xabdc, 0x00f7f7f7, 0},
{W, 1, "", 0xabe0, 0x00f8f8f8, 0},
{W, 1, "", 0xabe4, 0x00f9f9f9, 0},
{W, 1, "", 0xabe8, 0x00fafafa, 0},
{W, 1, "", 0xabec, 0x00fbfbfb, 0},
{W, 1, "", 0xabf0, 0x00fcfcfc, 0},
{W, 1, "", 0xabf4, 0x00fdfdfd, 0},
{W, 1, "", 0xabf8, 0x00fefefe, 0},
{W, 1, "", 0xabfc, 0x00ffffff, 0},
{W, 1, "", _PALETTE_B, 0x00000000, 0},
{W, 1, "", _PALETTE_B+0x4, 0x00010101, 0},
{W, 1, "", _PALETTE_B+0x8, 0x00020202, 0},
{W, 1, "", _PALETTE_B+0xc, 0x00030303, 0},
{W, 1, "", _PALETTE_B+0x10, 0x00040404, 0},
{W, 1, "", _PALETTE_B+0x14, 0x00050505, 0},
{W, 1, "", _PALETTE_B+0x18, 0x00060606, 0},
{W, 1, "", _PALETTE_B+0x1c, 0x00070707, 0},
{W, 1, "", _PALETTE_B+0x20, 0x00080808, 0},
{W, 1, "", _PALETTE_B+0x24, 0x00090909, 0},
{W, 1, "", _PALETTE_B+0x28, 0x000a0a0a, 0},
{W, 1, "", _PALETTE_B+0x2c, 0x000b0b0b, 0},
{W, 1, "", _PALETTE_B+0x30, 0x000c0c0c, 0},
{W, 1, "", _PALETTE_B+0x34, 0x000d0d0d, 0},
{W, 1, "", _PALETTE_B+0x38, 0x000e0e0e, 0},
{W, 1, "", _PALETTE_B+0x3c, 0x000f0f0f, 0},
{W, 1, "", _PALETTE_B+0x40, 0x00101010, 0},
{W, 1, "", _PALETTE_B+0x44, 0x00111111, 0},
{W, 1, "", _PALETTE_B+0x48, 0x00121212, 0},
{W, 1, "", _PALETTE_B+0x4c, 0x00131313, 0},
{W, 1, "", _PALETTE_B+0x50, 0x00141414, 0},
{W, 1, "", _PALETTE_B+0x54, 0x00151515, 0},
{W, 1, "", _PALETTE_B+0x58, 0x00161616, 0},
{W, 1, "", _PALETTE_B+0x5c, 0x00171717, 0},
{W, 1, "", _PALETTE_B+0x60, 0x00181818, 0},
{W, 1, "", _PALETTE_B+0x64, 0x00191919, 0},
{W, 1, "", _PALETTE_B+0x68, 0x001a1a1a, 0},
{W, 1, "", _PALETTE_B+0x6c, 0x001b1b1b, 0},
{W, 1, "", _PALETTE_B+0x70, 0x001c1c1c, 0},
{W, 1, "", _PALETTE_B+0x74, 0x001d1d1d, 0},
{W, 1, "", _PALETTE_B+0x78, 0x001e1e1e, 0},
{W, 1, "", _PALETTE_B+0x7c, 0x001f1f1f, 0},
{W, 1, "", 0xa880, 0x00202020, 0},
{W, 1, "", 0xa884, 0x00212121, 0},
{W, 1, "", 0xa888, 0x00222222, 0},
{W, 1, "", 0xa88c, 0x00232323, 0},
{W, 1, "", 0xa890, 0x00242424, 0},
{W, 1, "", 0xa894, 0x00252525, 0},
{W, 1, "", 0xa898, 0x00262626, 0},
{W, 1, "", 0xa89c, 0x00272727, 0},
{W, 1, "", 0xa8a0, 0x00282828, 0},
{W, 1, "", 0xa8a4, 0x00292929, 0},
{W, 1, "", 0xa8a8, 0x002a2a2a, 0},
{W, 1, "", 0xa8ac, 0x002b2b2b, 0},
{W, 1, "", 0xa8b0, 0x002c2c2c, 0},
{W, 1, "", 0xa8b4, 0x002d2d2d, 0},
{W, 1, "", 0xa8b8, 0x002e2e2e, 0},
{W, 1, "", 0xa8bc, 0x002f2f2f, 0},
{W, 1, "", 0xa8c0, 0x00303030, 0},
{W, 1, "", 0xa8c4, 0x00313131, 0},
{W, 1, "", 0xa8c8, 0x00323232, 0},
{W, 1, "", 0xa8cc, 0x00333333, 0},
{W, 1, "", 0xa8d0, 0x00343434, 0},
{W, 1, "", 0xa8d4, 0x00353535, 0},
{W, 1, "", 0xa8d8, 0x00363636, 0},
{W, 1, "", 0xa8dc, 0x00373737, 0},
{W, 1, "", 0xa8e0, 0x00383838, 0},
{W, 1, "", 0xa8e4, 0x00393939, 0},
{W, 1, "", 0xa8e8, 0x003a3a3a, 0},
{W, 1, "", 0xa8ec, 0x003b3b3b, 0},
{W, 1, "", 0xa8f0, 0x003c3c3c, 0},
{W, 1, "", 0xa8f4, 0x003d3d3d, 0},
{W, 1, "", 0xa8f8, 0x003e3e3e, 0},
{W, 1, "", 0xa8fc, 0x003f3f3f, 0},
{W, 1, "", 0xa900, 0x00404040, 0},
{W, 1, "", 0xa904, 0x00414141, 0},
{W, 1, "", 0xa908, 0x00424242, 0},
{W, 1, "", 0xa90c, 0x00434343, 0},
{W, 1, "", 0xa910, 0x00444444, 0},
{W, 1, "", 0xa914, 0x00454545, 0},
{W, 1, "", 0xa918, 0x00464646, 0},
{W, 1, "", 0xa91c, 0x00474747, 0},
{W, 1, "", 0xa920, 0x00484848, 0},
{W, 1, "", 0xa924, 0x00494949, 0},
{W, 1, "", 0xa928, 0x004a4a4a, 0},
{W, 1, "", 0xa92c, 0x004b4b4b, 0},
{W, 1, "", 0xa930, 0x004c4c4c, 0},
{W, 1, "", 0xa934, 0x004d4d4d, 0},
{W, 1, "", 0xa938, 0x004e4e4e, 0},
{W, 1, "", 0xa93c, 0x004f4f4f, 0},
{W, 1, "", 0xa940, 0x00505050, 0},
{W, 1, "", 0xa944, 0x00515151, 0},
{W, 1, "", 0xa948, 0x00525252, 0},
{W, 1, "", 0xa94c, 0x00535353, 0},
{W, 1, "", 0xa950, 0x00545454, 0},
{W, 1, "", 0xa954, 0x00555555, 0},
{W, 1, "", 0xa958, 0x00565656, 0},
{W, 1, "", 0xa95c, 0x00575757, 0},
{W, 1, "", 0xa960, 0x00585858, 0},
{W, 1, "", 0xa964, 0x00595959, 0},
{W, 1, "", 0xa968, 0x005a5a5a, 0},
{W, 1, "", 0xa96c, 0x005b5b5b, 0},
{W, 1, "", 0xa970, 0x005c5c5c, 0},
{W, 1, "", 0xa974, 0x005d5d5d, 0},
{W, 1, "", 0xa978, 0x005e5e5e, 0},
{W, 1, "", 0xa97c, 0x005f5f5f, 0},
{W, 1, "", 0xa980, 0x00606060, 0},
{W, 1, "", 0xa984, 0x00616161, 0},
{W, 1, "", 0xa988, 0x00626262, 0},
{W, 1, "", 0xa98c, 0x00636363, 0},
{W, 1, "", 0xa990, 0x00646464, 0},
{W, 1, "", 0xa994, 0x00656565, 0},
{W, 1, "", 0xa998, 0x00666666, 0},
{W, 1, "", 0xa99c, 0x00676767, 0},
{W, 1, "", 0xa9a0, 0x00686868, 0},
{W, 1, "", 0xa9a4, 0x00696969, 0},
{W, 1, "", 0xa9a8, 0x006a6a6a, 0},
{W, 1, "", 0xa9ac, 0x006b6b6b, 0},
{W, 1, "", 0xa9b0, 0x006c6c6c, 0},
{W, 1, "", 0xa9b4, 0x006d6d6d, 0},
{W, 1, "", 0xa9b8, 0x006e6e6e, 0},
{W, 1, "", 0xa9bc, 0x006f6f6f, 0},
{W, 1, "", 0xa9c0, 0x00707070, 0},
{W, 1, "", 0xa9c4, 0x00717171, 0},
{W, 1, "", 0xa9c8, 0x00727272, 0},
{W, 1, "", 0xa9cc, 0x00737373, 0},
{W, 1, "", 0xa9d0, 0x00747474, 0},
{W, 1, "", 0xa9d4, 0x00757575, 0},
{W, 1, "", 0xa9d8, 0x00767676, 0},
{W, 1, "", 0xa9dc, 0x00777777, 0},
{W, 1, "", 0xa9e0, 0x00787878, 0},
{W, 1, "", 0xa9e4, 0x00797979, 0},
{W, 1, "", 0xa9e8, 0x007a7a7a, 0},
{W, 1, "", 0xa9ec, 0x007b7b7b, 0},
{W, 1, "", 0xa9f0, 0x007c7c7c, 0},
{W, 1, "", 0xa9f4, 0x007d7d7d, 0},
{W, 1, "", 0xa9f8, 0x007e7e7e, 0},
{W, 1, "", 0xa9fc, 0x007f7f7f, 0},
{W, 1, "", 0xaa00, 0x00808080, 0},
{W, 1, "", 0xaa04, 0x00818181, 0},
{W, 1, "", 0xaa08, 0x00828282, 0},
{W, 1, "", 0xaa0c, 0x00838383, 0},
{W, 1, "", 0xaa10, 0x00848484, 0},
{W, 1, "", 0xaa14, 0x00858585, 0},
{W, 1, "", 0xaa18, 0x00868686, 0},
{W, 1, "", 0xaa1c, 0x00878787, 0},
{W, 1, "", 0xaa20, 0x00888888, 0},
{W, 1, "", 0xaa24, 0x00898989, 0},
{W, 1, "", 0xaa28, 0x008a8a8a, 0},
{W, 1, "", 0xaa2c, 0x008b8b8b, 0},
{W, 1, "", 0xaa30, 0x008c8c8c, 0},
{W, 1, "", 0xaa34, 0x008d8d8d, 0},
{W, 1, "", 0xaa38, 0x008e8e8e, 0},
{W, 1, "", 0xaa3c, 0x008f8f8f, 0},
{W, 1, "", 0xaa40, 0x00909090, 0},
{W, 1, "", 0xaa44, 0x00919191, 0},
{W, 1, "", 0xaa48, 0x00929292, 0},
{W, 1, "", 0xaa4c, 0x00939393, 0},
{W, 1, "", 0xaa50, 0x00949494, 0},
{W, 1, "", 0xaa54, 0x00959595, 0},
{W, 1, "", 0xaa58, 0x00969696, 0},
{W, 1, "", 0xaa5c, 0x00979797, 0},
{W, 1, "", 0xaa60, 0x00989898, 0},
{W, 1, "", 0xaa64, 0x00999999, 0},
{W, 1, "", 0xaa68, 0x009a9a9a, 0},
{W, 1, "", 0xaa6c, 0x009b9b9b, 0},
{W, 1, "", 0xaa70, 0x009c9c9c, 0},
{W, 1, "", 0xaa74, 0x009d9d9d, 0},
{W, 1, "", 0xaa78, 0x009e9e9e, 0},
{W, 1, "", 0xaa7c, 0x009f9f9f, 0},
{W, 1, "", 0xaa80, 0x00a0a0a0, 0},
{W, 1, "", 0xaa84, 0x00a1a1a1, 0},
{W, 1, "", 0xaa88, 0x00a2a2a2, 0},
{W, 1, "", 0xaa8c, 0x00a3a3a3, 0},
{W, 1, "", 0xaa90, 0x00a4a4a4, 0},
{W, 1, "", 0xaa94, 0x00a5a5a5, 0},
{W, 1, "", 0xaa98, 0x00a6a6a6, 0},
{W, 1, "", 0xaa9c, 0x00a7a7a7, 0},
{W, 1, "", 0xaaa0, 0x00a8a8a8, 0},
{W, 1, "", 0xaaa4, 0x00a9a9a9, 0},
{W, 1, "", 0xaaa8, 0x00aaaaaa, 0},
{W, 1, "", 0xaaac, 0x00ababab, 0},
{W, 1, "", 0xaab0, 0x00acacac, 0},
{W, 1, "", 0xaab4, 0x00adadad, 0},
{W, 1, "", 0xaab8, 0x00aeaeae, 0},
{W, 1, "", 0xaabc, 0x00afafaf, 0},
{W, 1, "", 0xaac0, 0x00b0b0b0, 0},
{W, 1, "", 0xaac4, 0x00b1b1b1, 0},
{W, 1, "", 0xaac8, 0x00b2b2b2, 0},
{W, 1, "", 0xaacc, 0x00b3b3b3, 0},
{W, 1, "", 0xaad0, 0x00b4b4b4, 0},
{W, 1, "", 0xaad4, 0x00b5b5b5, 0},
{W, 1, "", 0xaad8, 0x00b6b6b6, 0},
{W, 1, "", 0xaadc, 0x00b7b7b7, 0},
{W, 1, "", 0xaae0, 0x00b8b8b8, 0},
{W, 1, "", 0xaae4, 0x00b9b9b9, 0},
{W, 1, "", 0xaae8, 0x00bababa, 0},
{W, 1, "", 0xaaec, 0x00bbbbbb, 0},
{W, 1, "", 0xaaf0, 0x00bcbcbc, 0},
{W, 1, "", 0xaaf4, 0x00bdbdbd, 0},
{W, 1, "", 0xaaf8, 0x00bebebe, 0},
{W, 1, "", 0xaafc, 0x00bfbfbf, 0},
{W, 1, "", 0xab00, 0x00c0c0c0, 0},
{W, 1, "", 0xab04, 0x00c1c1c1, 0},
{W, 1, "", 0xab08, 0x00c2c2c2, 0},
{W, 1, "", 0xab0c, 0x00c3c3c3, 0},
{W, 1, "", 0xab10, 0x00c4c4c4, 0},
{W, 1, "", 0xab14, 0x00c5c5c5, 0},
{W, 1, "", 0xab18, 0x00c6c6c6, 0},
{W, 1, "", 0xab1c, 0x00c7c7c7, 0},
{W, 1, "", 0xab20, 0x00c8c8c8, 0},
{W, 1, "", 0xab24, 0x00c9c9c9, 0},
{W, 1, "", 0xab28, 0x00cacaca, 0},
{W, 1, "", 0xab2c, 0x00cbcbcb, 0},
{W, 1, "", 0xab30, 0x00cccccc, 0},
{W, 1, "", 0xab34, 0x00cdcdcd, 0},
{W, 1, "", 0xab38, 0x00cecece, 0},
{W, 1, "", 0xab3c, 0x00cfcfcf, 0},
{W, 1, "", 0xab40, 0x00d0d0d0, 0},
{W, 1, "", 0xab44, 0x00d1d1d1, 0},
{W, 1, "", 0xab48, 0x00d2d2d2, 0},
{W, 1, "", 0xab4c, 0x00d3d3d3, 0},
{W, 1, "", 0xab50, 0x00d4d4d4, 0},
{W, 1, "", 0xab54, 0x00d5d5d5, 0},
{W, 1, "", 0xab58, 0x00d6d6d6, 0},
{W, 1, "", 0xab5c, 0x00d7d7d7, 0},
{W, 1, "", 0xab60, 0x00d8d8d8, 0},
{W, 1, "", 0xab64, 0x00d9d9d9, 0},
{W, 1, "", 0xab68, 0x00dadada, 0},
{W, 1, "", 0xab6c, 0x00dbdbdb, 0},
{W, 1, "", 0xab70, 0x00dcdcdc, 0},
{W, 1, "", 0xab74, 0x00dddddd, 0},
{W, 1, "", 0xab78, 0x00dedede, 0},
{W, 1, "", 0xab7c, 0x00dfdfdf, 0},
{W, 1, "", 0xab80, 0x00e0e0e0, 0},
{W, 1, "", 0xab84, 0x00e1e1e1, 0},
{W, 1, "", 0xab88, 0x00e2e2e2, 0},
{W, 1, "", 0xab8c, 0x00e3e3e3, 0},
{W, 1, "", 0xab90, 0x00e4e4e4, 0},
{W, 1, "", 0xab94, 0x00e5e5e5, 0},
{W, 1, "", 0xab98, 0x00e6e6e6, 0},
{W, 1, "", 0xab9c, 0x00e7e7e7, 0},
{W, 1, "", 0xaba0, 0x00e8e8e8, 0},
{W, 1, "", 0xaba4, 0x00e9e9e9, 0},
{W, 1, "", 0xaba8, 0x00eaeaea, 0},
{W, 1, "", 0xabac, 0x00ebebeb, 0},
{W, 1, "", 0xabb0, 0x00ececec, 0},
{W, 1, "", 0xabb4, 0x00ededed, 0},
{W, 1, "", 0xabb8, 0x00eeeeee, 0},
{W, 1, "", 0xabbc, 0x00efefef, 0},
{W, 1, "", 0xabc0, 0x00f0f0f0, 0},
{W, 1, "", 0xabc4, 0x00f1f1f1, 0},
{W, 1, "", 0xabc8, 0x00f2f2f2, 0},
{W, 1, "", 0xabcc, 0x00f3f3f3, 0},
{W, 1, "", 0xabd0, 0x00f4f4f4, 0},
{W, 1, "", 0xabd4, 0x00f5f5f5, 0},
{W, 1, "", 0xabd8, 0x00f6f6f6, 0},
{W, 1, "", 0xabdc, 0x00f7f7f7, 0},
{W, 1, "", 0xabe0, 0x00f8f8f8, 0},
{W, 1, "", 0xabe4, 0x00f9f9f9, 0},
{W, 1, "", 0xabe8, 0x00fafafa, 0},
{W, 1, "", 0xabec, 0x00fbfbfb, 0},
{W, 1, "", 0xabf0, 0x00fcfcfc, 0},
{W, 1, "", 0xabf4, 0x00fdfdfd, 0},
{W, 1, "", 0xabf8, 0x00fefefe, 0},
{W, 1, "", 0xabfc, 0x00ffffff, 0},
{M, 1, "i915 0000:00:02.0:fb0:inteldrmfb frame buffer device", 0x0, 0x0, 0},
{M, 1, "i915 0000:00:02.0:registered panic notifier", 0x0, 0x0, 0},
{M, 1, "[drm] Initialized i915 1.6.0 20080730 for 0000:00:02.0 on minor 0", 0x0, 0x0, 0},
{0,},
};

int niodefs = sizeof (iodefs) / sizeof (iodefs[0]);
