
#define UINT8 unsigned char
#define INT16 signed short int
#define UINT16 unsigned short int
#define TRUE 1
#define FALSE 0
#define BOOLEAN int
#define STATIC
#define IN
#define OUT

#define SPD_TYPE 2
#define JED_DDR3SDRAM 0xB
#define SPD_BYTE_USED 0

// function below from:
// http://tracker.coreboot.org/trac/coreboot/browser/trunk/src/vendorcode/amd/agesa/Proc/Mem/Tech/DDR3/mtspd3.c
/* -----------------------------------------------------------------------------*/
/**
 *
 *       This function determines if the checksum is correct
 *
 *     @param[in]   *SPDPtr - Pointer to SPD data
 *
 *     @return    TRUE  - CRC check passes
 *     @return    FALSE - CRC check fails
 */

BOOLEAN
STATIC
MemTCRCCheck3 (
  IN OUT   UINT8 *SPDPtr
  )
{
  UINT16 Crc;
  INT16 i;
  INT16 j;
  INT16 Count;

  if (SPDPtr[SPD_TYPE] == JED_DDR3SDRAM) {
    Count = (SPDPtr[SPD_BYTE_USED] & 0x80) ? 117 : 126;
    Crc = 0;
    for (j = 0; j < Count; j++) {
      Crc = Crc ^ ((UINT16)SPDPtr[j] << 8);
      for (i = 0; i < 8; i++) {
        if (Crc & 0x8000) {
          Crc = (Crc << 1) ^ 0x1021;
        } else {
          Crc = (Crc << 1);
        }
      }
    }
    if (*(UINT16 *) (SPDPtr + 126) == Crc) {
      return TRUE;
    }
  }

  return FALSE;
}

