//----------------------------------------------------------------------------
#include <stdio.h>
#include <intrin.h>
//----------------------------------------------------------------------------

int MemTCRCCheck3 (unsigned char *buffer);


static unsigned char spd [256] = 
   {
   0x11, 0x10, 0x0B, 0x01, 0x05, 0x22, 0x00, 0x01, 0x03, 0x51, 0x01, 0x08, 0x10, 0x00, 0x7E, 0x00,
   0x78, 0x78, 0x78, 0x50, 0x78, 0x11, 0x2C, 0xA4, 0x70, 0x03, 0x3C, 0x3C, 0x01, 0x40, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFB, 0x65,
   0x4D, 0x54, 0x34, 0x31, 0x4A, 0x31, 0x32, 0x38, 0x4D, 0x38, 0x42, 0x59, 0x2D, 0x32, 0x35, 0x45,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   };


//----------------------------------------------------------------------------
//
// test ddr3 crc function
// 
int main (int argc, char *argv [])
   {
   int success, count, loops;
   unsigned long long startCount, elapsedCount;

   #if defined (_MSC_VER) // Microsoft
   printf ("microsoft: ");
   #else
   printf ("gcc      : ");
   #endif

   loops = 10000000;
   startCount = __rdtsc ();
   for (count = 0; count < loops; count++)
      success = MemTCRCCheck3 (spd);
   elapsedCount = __rdtsc () - startCount;
   if (success) printf ("pass, %I64u cycles\n", elapsedCount / loops);
   else printf ("fail!\n");
   return 0;
   }

//----------------------------------------------------------------------------
