//----------------------------------------------------------------------------
//
// blcutil - a binary linear code utility
//           copyright 2013 Scott Duplichan
//           This program is free software: you can redistribute it and/or modify
//           it under the terms of the GNU General Public License as published by
//           the Free Software Foundation, either version 3 of the License, or
//           (at your option) any later version.
//
//----------------------------------------------------------------------------
#include "project.h"
//----------------------------------------------------------------------------
//
// extractBit - return the value of selected bit from na extended integer
//
int extractBit (INTEGER *data, int bitNumber)
   {
   return (data->uintn [bitNumber / UINTN_BITS] >> (bitNumber % UINTN_BITS)) & 1;
   }

//----------------------------------------------------------------------------
//
// extractBits - extract a bit field a bit from a extended integer
//
int extractBits (INTEGER *data, int lsb, int msb)
   {
   int index, total = 0;

   for (index = lsb; index <= msb; index++)
      if (extractBit (data, index))
         total |= 1 << (index - lsb);
   return total;
   }

//----------------------------------------------------------------------------
//
// setBit - set a bit in an extended integer
//
void setBit (INTEGER *data, int bitnumber)
   {
   data->uintn [bitnumber / UINTN_BITS] |= (uintn_t) 1 << (bitnumber % UINTN_BITS);
   }

//----------------------------------------------------------------------------
//
//  highestSetBit64 - finds highest set bit in 64-bit integer
//                    returns 63 if ms bit set
//                    returns  0 if only ls bit is set
//                    returns -1 if no bits set
//
int highestSetBit64 (uint64_t data)
   {
   data |= (data >> 1);
   data |= (data >> 2);
   data |= (data >> 4);
   data |= (data >> 8);
   data |= (data >> 16);
   data |= (data >> 32);
   data -= (data >> 1) & 0x5555555555555555ULL;
   data = (data & 0x3333333333333333ULL) + ((data >> 2) & 0x3333333333333333ULL);
   data = (data + (data >> 4)) & 0x0f0f0f0f0f0f0f0fULL;
   return ((data * 0x0101010101010101ULL) >> 56) - 1;
   }

//----------------------------------------------------------------------------
//
//  highestSetBit - finds highest set bit in extended integer
//
int highestSetBit (INTEGER *data, int activeBits)
   {
   int bitno = activeBits - UINT64_BITS;
   int index = activeBits / UINT64_BITS - 1;

   for (;;)
      {
      if (data->uint64 [index])
          return highestSetBit64 (data->uint64 [index]) + bitno;
      if (--index < 0) return -1;
      bitno -= UINT64_BITS;
      }
   }

//----------------------------------------------------------------------------

void shiftLeft (INTEGER *source, INTEGER *dest, int shiftCount, int activeBits)
    {
    int index;

    memset (dest, 0, activeBits / 8);
    for (index = 0; index < activeBits - shiftCount; index++)
        {
        int bit = extractBit (source, index);
        if (bit) setBit (dest, index + shiftCount);
        }
    }

//----------------------------------------------------------------------------
