@echo off
if "%mingw64%" == "" (
    echo --- unable to locate mingw 64-bit compiler
    pause
    exit /b 1
    )

if "%AMDAPPSDKROOT%" == "" (
    echo --- unable to locate the AMD OpenCL SDK
    pause
    exit /b 1
    )

setlocal
cd  /d %~dp0
md gcc >nul 2>&1

set path=%mingw64%\bin
windres resource.rc resource.obj
set cflagsBase=-O3 -march=core2 -falign-functions=1 -falign-labels=1 -falign-loops=16 -I. -Wall -Wfatal-errors

set cflags=%cflagsBase% -DMAXBITS=256
gcc %cflags% -c         -ogpr_256.obj     -DGPR_BUILD     blcutil.c
gcc %cflags% -c -mssse3 -osse_256.obj     -DSSE_BUILD     blcutil.c
gcc %cflags% -c -mabm   -oxmmpop_256.obj  -DXMMPOP_BUILD  blcutil.c
gcc %cflags% -c -mavx   -oymmpop_256.obj  -DYMMPOP_BUILD  blcutil.c
gcc %cflags% -c -mavx   -oavx_256.obj     -DAVX_BUILD     blcutil.c
gcc %cflags% -c -mavx2  -oavx2_256.obj    -DAVX2_BUILD    blcutil.c
gcc %cflags% -c -I"%AMDAPPSDKROOT%\include" -oweightdistribution.obj opencl\weightdistribution.c

set cflags=%cflagsBase% -DMAXBITS=512
gcc %cflags% -c         -ogpr_512.obj     -DGPR_BUILD     blcutil.c
gcc %cflags% -c -mssse3 -osse_512.obj     -DSSE_BUILD     blcutil.c
gcc %cflags% -c -mabm   -oxmmpop_512.obj  -DXMMPOP_BUILD  blcutil.c
gcc %cflags% -c -mavx   -oymmpop_512.obj  -DYMMPOP_BUILD  blcutil.c
gcc %cflags% -c -mavx   -oavx_512.obj     -DAVX_BUILD     blcutil.c
gcc %cflags% -c -mavx2  -oavx2_512.obj    -DAVX2_BUILD    blcutil.c

set cflags=%cflagsBase% -DMAXBITS=65536
gcc %cflags% -c         -ogpr_any.obj     -DGPR_BUILD     blcutil.c
gcc %cflags% -c -mssse3 -osse_any.obj     -DSSE_BUILD     blcutil.c
gcc %cflags% -c -mabm   -oxmmpop_any.obj  -DXMMPOP_BUILD  blcutil.c
gcc %cflags% -c -mavx   -oymmpop_any.obj  -DYMMPOP_BUILD  blcutil.c
gcc %cflags% -c -mavx   -oavx_any.obj     -DAVX_BUILD     blcutil.c
gcc %cflags% -c -mavx2  -oavx2_any.obj    -DAVX2_BUILD    blcutil.c

gcc %cflagsBase% -DMAXBITS=65536 -ogcc/blcutil.exe                                      ^
    gpr_any.obj  sse_any.obj  avx_any.obj  avx2_any.obj xmmpop_any.obj  ymmpop_any.obj  ^
    gpr_256.obj  sse_256.obj  avx_256.obj  avx2_256.obj xmmpop_256.obj  ymmpop_256.obj  ^
    gpr_512.obj  sse_512.obj  avx_512.obj  avx2_512.obj xmmpop_512.obj  ymmpop_512.obj  ^
    extendedInteger/misc_gpr.c main.c utility.c cpudetect.c weightdistribution.obj      ^
    resource.obj "%AMDAPPSDKROOT%/lib/x86_64/libOpenCL.a

objdump -Mintel --disassemble gcc\blcutil.exe > gcc\disasm.txt
del *.obj
endlocal
