@echo off

if not "%VS110COMNTOOLS%" == "" set MSCOMPILER=%VS110COMNTOOLS%
if "%MSCOMPILER%" == "" (
    echo --- unable to locate Microsoft Visual Studio 2012 C compiler
    pause
    exit /b 1
    )

setlocal
cd  /d %~dp0
md ms >nul 2>&1

call "%%MSCOMPILER%%\..\..\VC\vcvarsall.bat" amd64 >nul
set INCLUDE=%ProgramFiles(x86)%\Microsoft SDKs\Windows\7.1A\Include;%INCLUDE%
set PATH=%ProgramFiles(x86)%\Microsoft SDKs\Windows\7.1A\Bin;%PATH%
set LIB=%ProgramFiles(x86)%\Microsoft SDKs\Windows\7.1A\Lib\x64;%LIB%
set CL=/D_USING_V110_SDK71_;%CL%
set cflagsBase=-Ox -GL -Gy -nologo -I. -W2
set LINK=/SUBSYSTEM:CONSOLE,5.02 %LINK%

set cflags=%cflagsBase% -DMAXBITS=256
cl %cflags% -c            -Fogpr_256.obj    -DGPR_BUILD    blcutil.c
cl %cflags% -c            -Fosse_256.obj    -DSSE_BUILD    blcutil.c
cl %cflags% -c            -Foxmmpop_256.obj -DXMMPOP_BUILD blcutil.c
cl %cflags% -c -arch:AVX  -Foymmpop_256.obj -DYMMPOP_BUILD blcutil.c
cl %cflags% -c -arch:AVX  -Foavx_256.obj    -DAVX_BUILD    blcutil.c
cl %cflags% -c -arch:AVX  -Foavx2_256.obj   -DAVX2_BUILD   blcutil.c

set cflags=%cflagsBase% -DMAXBITS=512
cl %cflags% -c            -Fogpr_512.obj    -DGPR_BUILD    blcutil.c
cl %cflags% -c            -Fosse_512.obj    -DSSE_BUILD    blcutil.c
cl %cflags% -c            -Foxmmpop_512.obj -DXMMPOP_BUILD blcutil.c
cl %cflags% -c -arch:AVX  -Foymmpop_512.obj -DYMMPOP_BUILD blcutil.c
cl %cflags% -c -arch:AVX  -Foavx_512.obj    -DAVX_BUILD    blcutil.c
cl %cflags% -c -arch:AVX  -Foavx2_512.obj   -DAVX2_BUILD   blcutil.c

set cflags=%cflagsBase% -DMAXBITS=65536
cl %cflags% -c            -Fogpr_any.obj    -DGPR_BUILD    blcutil.c
cl %cflags% -c            -Fosse_any.obj    -DSSE_BUILD    blcutil.c
cl %cflags% -c            -Foxmmpop_any.obj -DXMMPOP_BUILD blcutil.c
cl %cflags% -c -arch:AVX  -Foymmpop_any.obj -DYMMPOP_BUILD blcutil.c
cl %cflags% -c -arch:AVX  -Foavx_any.obj    -DAVX_BUILD    blcutil.c
cl %cflags% -c -arch:AVX  -Foavx2_any.obj   -DAVX2_BUILD   blcutil.c

cl %cflagsBase% -DMAXBITS=65536 -Fems\blcutil.exe^
    gpr_any.obj  sse_any.obj  avx_any.obj  avx2_any.obj xmmpop_any.obj  ymmpop_any.obj  ^
    gpr_256.obj  sse_256.obj  avx_256.obj  avx2_256.obj xmmpop_256.obj  ymmpop_256.obj  ^
    gpr_512.obj  sse_512.obj  avx_512.obj  avx2_512.obj xmmpop_512.obj  ymmpop_512.obj  ^
    extendedInteger/misc_gpr.c main.c utility.c cpudetect.c -link /dynamicbase:no /base:0x400000

dumpbin -disasm -symbols ms\blcutil.exe > ms\disasm.txt
del *.obj
endlocal
