#include "project.h"
//----------------------------------------------------------------------------
//
// formatMessage - return formatted message in static buffer
//
char *formatMessage (char *format, ...)
   {
   #define DIMENSION(array) (sizeof (array) / sizeof (array [0]))
   va_list marker;
   static char buffer [8][200];
   static int cycle;
   char *position = buffer [cycle];
   cycle++;
   if (cycle == DIMENSION (buffer)) cycle = 0;

   va_start (marker, format);
   vsprintf (position, format, marker);
   va_end (marker);
   return position;
   }

//-----------------------------------------------------------------------------
//
// format a number as decimal ascii with commas every 3 digits
//

char *commanumber (uint64_t value)
   {
   #define MAXCOLUMNS 28
   int digit = 0;
   char outbuf [MAXCOLUMNS];
   char buffer [MAXCOLUMNS];
   char *input = buffer + MAXCOLUMNS - 2;
   char *output = outbuf + MAXCOLUMNS - 2;

   outbuf [MAXCOLUMNS - 1] = '\0';
   sprintf (buffer, "%*llu", MAXCOLUMNS - 1, value);

   for (;;)
      {
      *output = *input;
      digit++;
      input--;
      output--;
      if (*input == ' ') break;
      if (digit % 3 == 0)
         {
         *output = ',';
         output--;
         }
      }

   return formatMessage (output + 1);
   }

//-----------------------------------------------------------------------------

static size_t removeTrailingCrLf (char *buffer, size_t length)
   {
   while (length)
      {
      if (buffer [length - 1] != '\r' && buffer [length - 1] != '\n') break;
      buffer [length - 1] = '\0';
      length--;
      }
   return length;
   }

//-----------------------------------------------------------------------------

static size_t removeTrailingPeriod (char *buffer, size_t length)
   {
   while (length)
      {
      if (buffer [length - 1] != '.') break;
      buffer [length - 1] = '\0';
      length--;
      }
   return length;
   }

//-----------------------------------------------------------------------------
//
// Return text string for Windows GetLastError code
// If zero is passed, GetLastError is called
// Trailing \n is removed

char *winErrorText (int code)
   {
   static char *position;

   if (code == 0) code = GetLastError ();
   FormatMessage ( 
      FORMAT_MESSAGE_ALLOCATE_BUFFER | 
      FORMAT_MESSAGE_FROM_SYSTEM | 
      FORMAT_MESSAGE_IGNORE_INSERTS,
      NULL,
      code,
      MAKELANGID (LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
      (LPTSTR) &position,
      0,
      NULL);

   if (position == NULL) return formatMessage ("error %08X", code);

   // remove any cr/lf/. characters at the end of the message
   removeTrailingCrLf (position, strlen (position));

   // remove any period character at the end of the message
   removeTrailingPeriod (position, strlen (position));
   return position;
   }

//-----------------------------------------------------------------------------
//
//  queryPerformanceCounter - similar to QueryPerformanceCounter, but returns
//                            count directly.

uint64_t queryPerformanceCounter (void)
   {
   LARGE_INTEGER int64;
   QueryPerformanceCounter (&int64);
   return int64.QuadPart;
   }

//-----------------------------------------------------------------------------
//
// queryPerformanceFrequency - same as QueryPerformanceFrequency, but returns  count direcly.

uint64_t queryPerformanceFrequency (void)
   {
   LARGE_INTEGER int64;
   QueryPerformanceFrequency (&int64);
   return int64.QuadPart;
   }

//----------------------------------------------------------------------------

char *elapsedTimeText (double seconds)
    {
    char buffer [80];

    if (seconds >= 1000) return formatMessage ("%s seconds", commanumber (seconds));
    if (seconds < 1) sprintf (buffer, "%.3G milliseconds", seconds * 1000.0);
    else sprintf (buffer, "%.2f seconds", seconds);
    return formatMessage (buffer);
    }

//----------------------------------------------------------------------------
//
//  highestSetBit - finds highest set bit in 64-bit integer
//                  returns 63 if ms bit set
//                  returns  0 if only ls bit is set
//                  returns -1 if no bits set
//
int highestSetBit (uint64_t data)
   {
   data |= (data >> 1);
   data |= (data >> 2);
   data |= (data >> 4);
   data |= (data >> 8);
   data |= (data >> 16);
   data |= (data >> 32);
   data -= (data >> 1) & 0x5555555555555555ULL;
   data = (data & 0x3333333333333333ULL) + ((data >> 2) & 0x3333333333333333ULL);
   data = (data + (data >> 4)) & 0x0f0f0f0f0f0f0f0fULL;
   return ((data * 0x0101010101010101ULL) >> 56) - 1;
   }

//----------------------------------------------------------------------------

int dummy (void)
    {
    {volatile int a=0xaaaaaaaa;while(a);}
    return 0;
    }

//----------------------------------------------------------------------------
