//----------------------------------------------------------------------------
//
// bc - a Beal conjecture counterexample search utility
//      copyright 2013 Scott Duplichan
//      This program is free software: you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation, either version 3 of the License, or
//      (at your option) any later version.
//
//----------------------------------------------------------------------------
// use standard 'll' for long long print format
#define __USE_MINGW_ANSI_STDIO 1

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <windows.h>
#include <process.h>
#include <math.h>

//----------------------------------------------------------------------------

#if !defined (__GNUC__)
#define __attribute__(a)
#define inline
#endif

//----------------------------------------------------------------------------
// These were originally passed through threadStruct. Moved to defines
// because gcc is not keeping them in registers in the multithreaded case.
// Whithout this, gcc code is 3X slower.

// modulo values, using large primes < 2^32
#define modulus1 ((1ull << 32) - 5)
#define modulus2 ((1ull << 32) - 17)
#define modulus3 ((1ull << 32) - 65)

// compression factor for compressed c^z bitmaps. High compression results
// in excessive false hits. To little compression results in cache misses.
#define bitMapCompress 7

//----------------------------------------------------------------------------
//
// structure passed to a dispatched thread
//
typedef struct
    {
    uint32_t a;  // next base to test
    uint32_t minPower, minBase, maxBase, maxPower;
    uint32_t *czTable;
    uint32_t *bitMap1, *bitMap2, *bitMap3;
    uint32_t *bitMap1c, *bitMap2c, *bitMap3c;
    uint64_t progStartTime;    // start time (QueryPerformanceCounter count) for logging
    int64_t candidates;        // count candidates left after gcd screening
    int64_t searches;          // count candidates left after 3 prime modulo screenings
    int64_t passes;            // count candidates left after final modulo screenings
    int quiet;                 // log passing cases only, good for Pythagorean triple verify
    int verbose;               // log cases that pass first screen
    int completions;           // thread completion count, for determining overall completion
    int threadCount;           // thread completion target value
    HANDLE allThreadsComplete; // event handle to tell main that all threads have completed
    HANDLE printMutex;
    }
THREAD_STRUCT;

//----------------------------------------------------------------------------
// util.c

char *formatMessage (char *format, ...);
char *commanumber (uint64_t value);
char *winErrorText (int code);
uint64_t queryPerformanceCounter (void);
uint64_t queryPerformanceFrequency (void);
char *elapsedTimeText (double seconds);
int highestSetBit (uint64_t data);

// search.c
int bealSearchCore (int a, THREAD_STRUCT *threadStruct);

//----------------------------------------------------------------------------
